/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.rmi.RemoteException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.rmi.remote.RemoteIterator;
import org.apache.jackrabbit.rmi.remote.RemoteNode;
import org.apache.jackrabbit.rmi.remote.RemoteVersion;
import org.apache.jackrabbit.rmi.remote.RemoteVersionHistory;
import org.apache.jackrabbit.rmi.remote.RemoteVersionManager;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerObject;

public class ServerVersionManager
extends ServerObject
implements RemoteVersionManager {
    private final Session session;
    private final VersionManager manager;

    public ServerVersionManager(Session session, VersionManager manager, RemoteAdapterFactory factory) throws RemoteException {
        super(factory);
        this.session = session;
        this.manager = manager;
    }

    @Override
    public RemoteVersion checkin(String absPath) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteVersion(this.manager.checkin(absPath));
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public void checkout(String absPath) throws RepositoryException {
        try {
            this.manager.checkout(absPath);
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public RemoteVersion checkpoint(String absPath) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteVersion(this.manager.checkpoint(absPath));
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public RemoteNode createActivity(String title) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteNode(this.manager.createActivity(title));
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public RemoteNode createConfiguration(String absPath) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteNode(this.manager.createConfiguration(absPath));
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public RemoteNode getActivity() throws RepositoryException, RemoteException {
        try {
            Node activity = this.manager.getActivity();
            if (activity == null) {
                return null;
            }
            return this.getFactory().getRemoteNode(activity);
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public RemoteVersion getBaseVersion(String absPath) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteVersion(this.manager.getBaseVersion(absPath));
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public RemoteVersionHistory getVersionHistory(String absPath) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteVersionHistory(this.manager.getVersionHistory(absPath));
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public boolean isCheckedOut(String absPath) throws RepositoryException {
        try {
            return this.manager.isCheckedOut(absPath);
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public RemoteIterator merge(String absPath, String srcWorkspace, boolean bestEffort) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteNodeIterator(this.manager.merge(absPath, srcWorkspace, bestEffort));
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public RemoteIterator merge(String absPath, String srcWorkspace, boolean bestEffort, boolean isShallow) throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemoteNodeIterator(this.manager.merge(absPath, srcWorkspace, bestEffort, isShallow));
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public void restore(String absPath, String versionName, boolean removeExisting) throws RepositoryException {
        try {
            this.manager.restore(absPath, versionName, removeExisting);
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public void restoreByLabel(String absPath, String versionLabel, boolean removeExisting) throws RepositoryException {
        try {
            this.manager.restoreByLabel(absPath, versionLabel, removeExisting);
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public void cancelMerge(String absPath, String versionIdentifier) throws RepositoryException, RemoteException {
        try {
            Version version = (Version)this.session.getNodeByIdentifier(versionIdentifier);
            this.manager.cancelMerge(absPath, version);
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public void doneMerge(String absPath, String versionIdentifier) throws RepositoryException, RemoteException {
        try {
            Version version = (Version)this.session.getNodeByIdentifier(versionIdentifier);
            this.manager.doneMerge(absPath, version);
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public void restore(String[] versionIdentifiers, boolean removeExisting) throws RepositoryException, RemoteException {
        try {
            Version[] versions = new Version[versionIdentifiers.length];
            for (int i = 0; i < versions.length; ++i) {
                Version version;
                versions[i] = version = (Version)this.session.getNodeByIdentifier(versionIdentifiers[i]);
            }
            this.manager.restore(versions, removeExisting);
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public void restore(String versionIdentifier, boolean removeExisting) throws RepositoryException, RemoteException {
        try {
            Version version = (Version)this.session.getNodeByIdentifier(versionIdentifier);
            this.manager.restore(version, removeExisting);
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public RemoteNode setActivity(String activityNodeIdentifier) throws RepositoryException, RemoteException {
        try {
            Node newActivityNode = activityNodeIdentifier == null ? null : this.session.getNodeByIdentifier(activityNodeIdentifier);
            Node oldActivityNode = this.manager.setActivity(newActivityNode);
            if (oldActivityNode == null) {
                return null;
            }
            return this.getFactory().getRemoteNode(oldActivityNode);
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public void removeActivity(String activityNodeIdentifier) throws RepositoryException, RemoteException {
        try {
            Node activityNode = this.session.getNodeByIdentifier(activityNodeIdentifier);
            this.manager.removeActivity(activityNode);
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public RemoteIterator merge(String activityNodeIdentifier) throws RepositoryException, RemoteException {
        try {
            Node activityNode = this.session.getNodeByIdentifier(activityNodeIdentifier);
            return this.getFactory().getRemoteNodeIterator(this.manager.merge(activityNode));
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }

    @Override
    public void restoreVI(String absPath, String versionIdentifier, boolean removeExisting) throws RepositoryException, RemoteException {
        try {
            Version version = (Version)this.session.getNodeByIdentifier(versionIdentifier);
            this.manager.restore(absPath, version, removeExisting);
        }
        catch (RepositoryException e) {
            throw this.getRepositoryException(e);
        }
    }
}

