/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.value;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.rmi.value.StringValue;

@Deprecated
class BinaryValue
implements Value,
Serializable {
    private static final long serialVersionUID = 1719020811685971215L;
    private final Binary value;
    private transient InputStream stream = null;

    public BinaryValue(Binary value) {
        this.value = value;
    }

    public int getType() {
        return 2;
    }

    public Binary getBinary() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() throws RepositoryException {
        String string;
        InputStream stream = this.value.getStream();
        try {
            InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[1024];
            int n = reader.read(buffer);
            while (n != -1) {
                builder.append(buffer, 0, n);
                n = reader.read(buffer);
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RepositoryException("Unable to read the binary value", (Throwable)e);
            }
        }
        stream.close();
        return string;
    }

    public synchronized InputStream getStream() throws RepositoryException {
        if (this.stream == null) {
            this.stream = this.value.getStream();
        }
        return this.stream;
    }

    public boolean getBoolean() throws RepositoryException {
        return new StringValue(this.getString()).getBoolean();
    }

    public Calendar getDate() throws RepositoryException {
        return new StringValue(this.getString()).getDate();
    }

    public BigDecimal getDecimal() throws RepositoryException {
        return new StringValue(this.getString()).getDecimal();
    }

    public double getDouble() throws RepositoryException {
        return new StringValue(this.getString()).getDouble();
    }

    public long getLong() throws RepositoryException {
        return new StringValue(this.getString()).getLong();
    }
}

