/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.query.lucene.CachingMultiIndexReader;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.FieldSelectors;
import org.apache.jackrabbit.core.query.lucene.IndexingQueueStore;
import org.apache.jackrabbit.core.query.lucene.MultiIndex;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexingQueue {
    private static final Logger log = LoggerFactory.getLogger(IndexingQueue.class);
    private final IndexingQueueStore queueStore;
    private final Map pendingDocuments = new HashMap();
    private volatile boolean initialized = false;

    IndexingQueue(IndexingQueueStore queueStore) {
        this.queueStore = queueStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(MultiIndex index) throws IOException {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        CachingMultiIndexReader reader = index.getIndexReader();
        try {
            TermDocs tDocs = reader.termDocs(new Term(FieldNames.REINDEXING_REQUIRED, ""));
            try {
                while (tDocs.next()) {
                    this.queueStore.addUUID(reader.document(tDocs.doc(), FieldSelectors.UUID).get(FieldNames.UUID));
                }
            }
            finally {
                tDocs.close();
            }
        }
        finally {
            reader.release();
        }
        String[] uuids = this.queueStore.getPending();
        for (int i = 0; i < uuids.length; ++i) {
            try {
                UUID uuid = UUID.fromString(uuids[i]);
                Document doc = index.createDocument(new NodeId(uuid));
                this.pendingDocuments.put(uuids[i], doc);
                log.debug("added node {}. New size of indexing queue: {}", uuid, (Object)new Integer(this.pendingDocuments.size()));
                continue;
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid UUID in indexing queue store: " + uuids[i]);
                continue;
            }
            catch (RepositoryException e) {
                log.debug("Node with uuid {} does not exist anymore", (Object)uuids[i]);
                this.queueStore.removeUUID(uuids[i]);
            }
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document[] getFinishedDocuments() {
        this.checkInitialized();
        ArrayList finished = new ArrayList();
        IndexingQueue indexingQueue = this;
        synchronized (indexingQueue) {
            finished.addAll(this.pendingDocuments.values());
        }
        Iterator it = finished.iterator();
        while (it.hasNext()) {
            Document doc = (Document)it.next();
            if (Util.isDocumentReady(doc)) continue;
            it.remove();
        }
        return finished.toArray(new Document[finished.size()]);
    }

    public synchronized Document removeDocument(String uuid) {
        this.checkInitialized();
        Document doc = (Document)this.pendingDocuments.remove(uuid);
        if (doc != null) {
            this.queueStore.removeUUID(uuid);
            log.debug("removed node {}. New size of indexing queue: {}", (Object)uuid, (Object)new Integer(this.pendingDocuments.size()));
        }
        return doc;
    }

    public synchronized Document addDocument(Document doc) {
        this.checkInitialized();
        String uuid = doc.get(FieldNames.UUID);
        Document existing = this.pendingDocuments.put(uuid, doc);
        log.debug("added node {}. New size of indexing queue: {}", (Object)uuid, (Object)new Integer(this.pendingDocuments.size()));
        if (existing == null) {
            this.queueStore.addUUID(uuid);
        }
        return existing;
    }

    public synchronized void close() {
        this.checkInitialized();
        Iterator it = this.pendingDocuments.values().iterator();
        while (it.hasNext()) {
            Document doc = (Document)it.next();
            Util.disposeDocument(doc);
            it.remove();
        }
        this.queueStore.close();
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
    }

    synchronized int getNumPendingDocuments() {
        return this.pendingDocuments.size();
    }
}

