/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.core.AbstractNodeData;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.VersionImpl;
import org.apache.jackrabbit.core.version.VersionIteratorImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionHistoryImpl
extends NodeImpl
implements VersionHistory {
    private static Logger log = LoggerFactory.getLogger(VersionHistoryImpl.class);

    public VersionHistoryImpl(ItemManager itemMgr, SessionImpl session, AbstractNodeData data) {
        super(itemMgr, session, data);
    }

    protected InternalVersionHistory getInternalVersionHistory() throws RepositoryException {
        InternalVersionHistory history = this.session.getVersionManager().getVersionHistory((NodeId)this.id);
        if (history == null) {
            throw new InvalidItemStateException(this.id + ": the item does not exist anymore");
        }
        return history;
    }

    public Version getRootVersion() throws RepositoryException {
        return (Version)((Object)this.session.getNodeById(this.getInternalVersionHistory().getRootVersion().getId()));
    }

    public VersionIterator getAllVersions() throws RepositoryException {
        return new VersionIteratorImpl(this.session, this.getInternalVersionHistory().getRootVersion());
    }

    public Version getVersion(String versionName) throws VersionException, RepositoryException {
        try {
            Name name = this.session.getQName(versionName);
            InternalVersion v = this.getInternalVersionHistory().getVersion(name);
            if (v == null) {
                throw new VersionException("No version with name '" + versionName + "' exists in this version history.");
            }
            return (Version)((Object)this.session.getNodeById(v.getId()));
        }
        catch (NameException e) {
            throw new VersionException(e);
        }
    }

    public Version getVersionByLabel(String label) throws RepositoryException {
        try {
            Name qLabel = this.session.getQName(label);
            InternalVersion v = this.getInternalVersionHistory().getVersionByLabel(qLabel);
            if (v == null) {
                throw new VersionException("No version with label '" + label + "' exists in this version history.");
            }
            return (Version)((Object)this.session.getNodeById(v.getId()));
        }
        catch (NameException e) {
            throw new VersionException(e);
        }
    }

    public void addVersionLabel(String versionName, String label, boolean move) throws VersionException, RepositoryException {
        try {
            this.session.getVersionManager().setVersionLabel(this, this.session.getQName(versionName), this.session.getQName(label), move);
        }
        catch (NameException e) {
            throw new VersionException(e);
        }
    }

    public void removeVersionLabel(String label) throws RepositoryException {
        try {
            Version existing = this.session.getVersionManager().setVersionLabel(this, null, this.session.getQName(label), true);
            if (existing == null) {
                throw new VersionException("No version with label '" + label + "' exists in this version history.");
            }
        }
        catch (NameException e) {
            throw new VersionException(e);
        }
    }

    public String[] getVersionLabels() throws RepositoryException {
        Name[] labels = this.getInternalVersionHistory().getVersionLabels();
        String[] ret = new String[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            ret[i] = this.session.getJCRName(labels[i]);
        }
        return ret;
    }

    public String[] getVersionLabels(Version version) throws VersionException, RepositoryException {
        this.checkOwnVersion(version);
        Name[] labels = ((VersionImpl)version).getInternalVersion().getLabels();
        String[] ret = new String[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            ret[i] = this.session.getJCRName(labels[i]);
        }
        return ret;
    }

    public boolean hasVersionLabel(String label) throws RepositoryException {
        try {
            Name qLabel = this.session.getQName(label);
            return this.getInternalVersionHistory().getVersionByLabel(qLabel) != null;
        }
        catch (NameException e) {
            throw new IllegalArgumentException("Unable to resolve label: " + e);
        }
    }

    public boolean hasVersionLabel(Version version, String label) throws VersionException, RepositoryException {
        this.checkOwnVersion(version);
        try {
            Name qLabel = this.session.getQName(label);
            return ((VersionImpl)version).getInternalVersion().hasLabel(qLabel);
        }
        catch (NameException e) {
            throw new VersionException(e);
        }
    }

    public void removeVersion(String versionName) throws UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        try {
            this.session.getVersionManager().removeVersion(this, this.session.getQName(versionName));
        }
        catch (NameException e) {
            throw new RepositoryException(e);
        }
    }

    public boolean isSame(Item otherItem) {
        if (otherItem instanceof VersionHistoryImpl) {
            try {
                InternalVersionHistory other = ((VersionHistoryImpl)otherItem).getInternalVersionHistory();
                return other.getId().equals(this.getInternalVersionHistory().getId());
            }
            catch (RepositoryException e) {
                log.warn("Unable to retrieve internal version history objects: " + e.getMessage());
                log.debug("Stack dump:", e);
            }
        }
        return false;
    }

    public String getVersionableUUID() throws RepositoryException {
        return this.getInternalVersionHistory().getVersionableUUID().toString();
    }

    private void checkOwnVersion(Version version) throws VersionException, RepositoryException {
        if (!version.getParent().isSame(this)) {
            throw new VersionException("Specified version not contained in this history.");
        }
    }

    public void update(String srcWorkspaceName) throws ConstraintViolationException {
        String msg = "update operation not allowed: " + this;
        log.debug(msg);
        throw new ConstraintViolationException(msg);
    }

    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws ConstraintViolationException {
        String msg = "merge operation not allowed: " + this;
        log.debug(msg);
        throw new ConstraintViolationException(msg);
    }

    public String toString() {
        return "version history " + super.toString();
    }
}

