/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.jackrabbit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.rmi.client.ClientWorkspace;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRepositoryException;
import org.apache.jackrabbit.rmi.jackrabbit.RemoteJackrabbitWorkspace;
import org.xml.sax.InputSource;

public class ClientJackrabbitWorkspace
extends ClientWorkspace
implements JackrabbitWorkspace {
    private final RemoteJackrabbitWorkspace remote;

    public ClientJackrabbitWorkspace(Session session, RemoteJackrabbitWorkspace remote, LocalAdapterFactory factory) {
        super(session, remote, factory);
        this.remote = remote;
    }

    public void createWorkspace(String name) throws RepositoryException {
        try {
            this.remote.createWorkspace(name, null);
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createWorkspace(String name, InputSource template) throws RepositoryException {
        try {
            InputStream input = template.getByteStream();
            try {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                byte[] buffer = new byte[1000];
                int n = input.read(buffer);
                while (n != -1) {
                    output.write(buffer, 0, n);
                    n = input.read(buffer);
                }
                this.remote.createWorkspace(name, output.toByteArray());
            }
            finally {
                input.close();
            }
        }
        catch (RemoteException e) {
            throw new RemoteRepositoryException(e);
        }
        catch (IOException e) {
            throw new RepositoryException("Error reading workspace template", e);
        }
    }
}

