/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.ValueEvalToNumericXlator;
import org.apache.poi.hssf.record.formula.functions.MultiOperandNumericFunction;
import org.apache.poi.hssf.record.formula.functions.StatsLib;

public class Large
extends MultiOperandNumericFunction {
    private static final ValueEvalToNumericXlator DEFAULT_NUM_XLATOR = new ValueEvalToNumericXlator(3);

    protected ValueEvalToNumericXlator getXlator() {
        return DEFAULT_NUM_XLATOR;
    }

    public Eval evaluate(Eval[] operands, int srcCellRow, short srcCellCol) {
        ErrorEval retval = null;
        double[] ops = this.getNumberArray(operands, srcCellRow, srcCellCol);
        if (ops == null || ops.length < 2) {
            retval = ErrorEval.VALUE_INVALID;
        } else {
            double[] values = new double[ops.length - 1];
            int k = (int)ops[ops.length - 1];
            System.arraycopy(ops, 0, values, 0, values.length);
            double d = StatsLib.kthLargest(values, k);
            retval = Double.isNaN(d) || Double.isInfinite(d) ? ErrorEval.NUM_ERROR : new NumberEval(d);
        }
        return retval;
    }
}

