/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.ForeignSegmentDocId;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.MultiIndexReader;
import org.apache.jackrabbit.uuid.UUID;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;

public final class JackrabbitIndexReader
extends FilterIndexReader
implements HierarchyResolver,
MultiIndexReader {
    private final HierarchyResolver resolver;
    private final MultiIndexReader reader;

    public JackrabbitIndexReader(IndexReader in) {
        super(in);
        if (!(in instanceof MultiIndexReader)) {
            throw new IllegalArgumentException("IndexReader must also implement MultiIndexReader");
        }
        if (!(in instanceof HierarchyResolver)) {
            throw new IllegalArgumentException("IndexReader must also implement HierarchyResolver");
        }
        this.resolver = (HierarchyResolver)((Object)in);
        this.reader = (MultiIndexReader)((Object)in);
    }

    protected void doClose() throws IOException {
        this.reader.release();
    }

    public int getParent(int n) throws IOException {
        return this.resolver.getParent(n);
    }

    public IndexReader[] getIndexReaders() {
        return this.reader.getIndexReaders();
    }

    public ForeignSegmentDocId createDocId(UUID uuid) throws IOException {
        return this.reader.createDocId(uuid);
    }

    public int getDocumentNumber(ForeignSegmentDocId docId) throws IOException {
        return this.reader.getDocumentNumber(docId);
    }

    public void release() throws IOException {
        this.reader.release();
    }
}

