/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public class TextObjectBaseRecord
extends Record {
    public static final short sid = 438;
    private short field_1_options;
    private BitField reserved1 = BitFieldFactory.getInstance(1);
    private BitField HorizontalTextAlignment = BitFieldFactory.getInstance(14);
    public static final short HORIZONTAL_TEXT_ALIGNMENT_LEFT_ALIGNED = 1;
    public static final short HORIZONTAL_TEXT_ALIGNMENT_CENTERED = 2;
    public static final short HORIZONTAL_TEXT_ALIGNMENT_RIGHT_ALIGNED = 3;
    public static final short HORIZONTAL_TEXT_ALIGNMENT_JUSTIFIED = 4;
    private BitField VerticalTextAlignment = BitFieldFactory.getInstance(112);
    public static final short VERTICAL_TEXT_ALIGNMENT_TOP = 1;
    public static final short VERTICAL_TEXT_ALIGNMENT_CENTER = 2;
    public static final short VERTICAL_TEXT_ALIGNMENT_BOTTOM = 3;
    public static final short VERTICAL_TEXT_ALIGNMENT_JUSTIFY = 4;
    private BitField reserved2 = BitFieldFactory.getInstance(384);
    private BitField textLocked = BitFieldFactory.getInstance(512);
    private BitField reserved3 = BitFieldFactory.getInstance(64512);
    private short field_2_textOrientation;
    public static final short TEXT_ORIENTATION_NONE = 0;
    public static final short TEXT_ORIENTATION_TOP_TO_BOTTOM = 1;
    public static final short TEXT_ORIENTATION_ROT_RIGHT = 2;
    public static final short TEXT_ORIENTATION_ROT_LEFT = 3;
    private short field_3_reserved4;
    private short field_4_reserved5;
    private short field_5_reserved6;
    private short field_6_textLength;
    private short field_7_formattingRunLength;
    private int field_8_reserved7;

    public TextObjectBaseRecord() {
    }

    public TextObjectBaseRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 438) {
            throw new RecordFormatException("Not a TextObjectBase record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_options = in.readShort();
        this.field_2_textOrientation = in.readShort();
        this.field_3_reserved4 = in.readShort();
        this.field_4_reserved5 = in.readShort();
        this.field_5_reserved6 = in.readShort();
        this.field_6_textLength = in.readShort();
        this.field_7_formattingRunLength = in.readShort();
        this.field_8_reserved7 = in.readInt();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[TXO]\n");
        buffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .reserved1                = ").append(this.isReserved1()).append('\n');
        buffer.append("         .HorizontalTextAlignment     = ").append(this.getHorizontalTextAlignment()).append('\n');
        buffer.append("         .VerticalTextAlignment     = ").append(this.getVerticalTextAlignment()).append('\n');
        buffer.append("         .reserved2                = ").append(this.getReserved2()).append('\n');
        buffer.append("         .textLocked               = ").append(this.isTextLocked()).append('\n');
        buffer.append("         .reserved3                = ").append(this.getReserved3()).append('\n');
        buffer.append("    .textOrientation      = ").append("0x").append(HexDump.toHex(this.getTextOrientation())).append(" (").append(this.getTextOrientation()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .reserved4            = ").append("0x").append(HexDump.toHex(this.getReserved4())).append(" (").append(this.getReserved4()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .reserved5            = ").append("0x").append(HexDump.toHex(this.getReserved5())).append(" (").append(this.getReserved5()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .reserved6            = ").append("0x").append(HexDump.toHex(this.getReserved6())).append(" (").append(this.getReserved6()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .textLength           = ").append("0x").append(HexDump.toHex(this.getTextLength())).append(" (").append(this.getTextLength()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .formattingRunLength  = ").append("0x").append(HexDump.toHex(this.getFormattingRunLength())).append(" (").append(this.getFormattingRunLength()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .reserved7            = ").append("0x").append(HexDump.toHex(this.getReserved7())).append(" (").append(this.getReserved7()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/TXO]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)438);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_options);
        LittleEndian.putShort(data, 6 + offset + pos, this.field_2_textOrientation);
        LittleEndian.putShort(data, 8 + offset + pos, this.field_3_reserved4);
        LittleEndian.putShort(data, 10 + offset + pos, this.field_4_reserved5);
        LittleEndian.putShort(data, 12 + offset + pos, this.field_5_reserved6);
        LittleEndian.putShort(data, 14 + offset + pos, this.field_6_textLength);
        LittleEndian.putShort(data, 16 + offset + pos, this.field_7_formattingRunLength);
        LittleEndian.putInt(data, 18 + offset + pos, this.field_8_reserved7);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 22;
    }

    public short getSid() {
        return 438;
    }

    public Object clone() {
        TextObjectBaseRecord rec = new TextObjectBaseRecord();
        rec.field_1_options = this.field_1_options;
        rec.field_2_textOrientation = this.field_2_textOrientation;
        rec.field_3_reserved4 = this.field_3_reserved4;
        rec.field_4_reserved5 = this.field_4_reserved5;
        rec.field_5_reserved6 = this.field_5_reserved6;
        rec.field_6_textLength = this.field_6_textLength;
        rec.field_7_formattingRunLength = this.field_7_formattingRunLength;
        rec.field_8_reserved7 = this.field_8_reserved7;
        return rec;
    }

    public short getOptions() {
        return this.field_1_options;
    }

    public void setOptions(short field_1_options) {
        this.field_1_options = field_1_options;
    }

    public short getTextOrientation() {
        return this.field_2_textOrientation;
    }

    public void setTextOrientation(short field_2_textOrientation) {
        this.field_2_textOrientation = field_2_textOrientation;
    }

    public short getReserved4() {
        return this.field_3_reserved4;
    }

    public void setReserved4(short field_3_reserved4) {
        this.field_3_reserved4 = field_3_reserved4;
    }

    public short getReserved5() {
        return this.field_4_reserved5;
    }

    public void setReserved5(short field_4_reserved5) {
        this.field_4_reserved5 = field_4_reserved5;
    }

    public short getReserved6() {
        return this.field_5_reserved6;
    }

    public void setReserved6(short field_5_reserved6) {
        this.field_5_reserved6 = field_5_reserved6;
    }

    public short getTextLength() {
        return this.field_6_textLength;
    }

    public void setTextLength(short field_6_textLength) {
        this.field_6_textLength = field_6_textLength;
    }

    public short getFormattingRunLength() {
        return this.field_7_formattingRunLength;
    }

    public void setFormattingRunLength(short field_7_formattingRunLength) {
        this.field_7_formattingRunLength = field_7_formattingRunLength;
    }

    public int getReserved7() {
        return this.field_8_reserved7;
    }

    public void setReserved7(int field_8_reserved7) {
        this.field_8_reserved7 = field_8_reserved7;
    }

    public void setReserved1(boolean value) {
        this.field_1_options = this.reserved1.setShortBoolean(this.field_1_options, value);
    }

    public boolean isReserved1() {
        return this.reserved1.isSet(this.field_1_options);
    }

    public void setHorizontalTextAlignment(short value) {
        this.field_1_options = this.HorizontalTextAlignment.setShortValue(this.field_1_options, value);
    }

    public short getHorizontalTextAlignment() {
        return this.HorizontalTextAlignment.getShortValue(this.field_1_options);
    }

    public void setVerticalTextAlignment(short value) {
        this.field_1_options = this.VerticalTextAlignment.setShortValue(this.field_1_options, value);
    }

    public short getVerticalTextAlignment() {
        return this.VerticalTextAlignment.getShortValue(this.field_1_options);
    }

    public void setReserved2(short value) {
        this.field_1_options = this.reserved2.setShortValue(this.field_1_options, value);
    }

    public short getReserved2() {
        return this.reserved2.getShortValue(this.field_1_options);
    }

    public void setTextLocked(boolean value) {
        this.field_1_options = this.textLocked.setShortBoolean(this.field_1_options, value);
    }

    public boolean isTextLocked() {
        return this.textLocked.isSet(this.field_1_options);
    }

    public void setReserved3(short value) {
        this.field_1_options = this.reserved3.setShortValue(this.field_1_options, value);
    }

    public short getReserved3() {
        return this.reserved3.getShortValue(this.field_1_options);
    }
}

