/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.collections.BeanMap;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanConfig {
    private static Logger log = LoggerFactory.getLogger(BeanConfig.class);
    private static ClassLoader defaultClassLoader = BeanConfig.class.getClassLoader();
    private ClassLoader classLoader = BeanConfig.getDefaultClassLoader();
    private final String className;
    private final Properties properties;
    private boolean validate = true;

    public BeanConfig(String className, Properties properties) {
        this.className = className;
        this.properties = (Properties)properties.clone();
    }

    public BeanConfig(BeanConfig config) {
        this(config.getClassName(), config.getParameters());
    }

    protected void setValidate(boolean validate) {
        this.validate = validate;
    }

    public String getClassName() {
        return this.className;
    }

    public Properties getParameters() {
        return this.properties;
    }

    public Object newInstance() throws ConfigurationException {
        try {
            Class<?> objectClass = Class.forName(this.getClassName(), true, this.getClassLoader());
            Object object = objectClass.newInstance();
            BeanMap map = new BeanMap(object);
            Iterator iterator = map.keyIterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                String value = this.properties.getProperty(name);
                if (value == null) continue;
                map.put(name, this.properties.getProperty(name));
            }
            if (this.validate) {
                Iterator<Object> it = this.properties.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (map.containsKey(key) || this.properties.getProperty(key) == null) continue;
                    String msg = "Configured class " + object.getClass().getName() + " does not contain the property " + key + ". Please fix the repository configuration.";
                    log.error(msg);
                    throw new ConfigurationException(msg);
                }
            }
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Configured bean implementation class " + this.getClassName() + " was not found.", e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Configured bean implementation class " + this.getClassName() + " can not be instantiated.", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Configured bean implementation class " + this.getClassName() + " is protected.", e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static ClassLoader getDefaultClassLoader() {
        return defaultClassLoader;
    }

    public static void setDefaultClassLoader(ClassLoader classLoader) {
        defaultClassLoader = classLoader;
    }
}

