/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authentication;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.security.authentication.Authentication;
import org.apache.jackrabbit.core.security.authentication.CryptedSimpleCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleCredentialsAuthentication
implements Authentication {
    private static final Logger log = LoggerFactory.getLogger(SimpleCredentialsAuthentication.class);
    private final CryptedSimpleCredentials creds;

    SimpleCredentialsAuthentication(User user) throws RepositoryException {
        Credentials creds = user.getCredentials();
        if (creds instanceof CryptedSimpleCredentials) {
            this.creds = (CryptedSimpleCredentials)creds;
        } else if (creds instanceof SimpleCredentials) {
            try {
                this.creds = new CryptedSimpleCredentials((SimpleCredentials)creds);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RepositoryException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new RepositoryException(e);
            }
        } else {
            log.warn("No Credentials found with user " + user.getID());
            this.creds = null;
        }
    }

    public boolean canHandle(Credentials credentials) {
        return this.creds != null && credentials instanceof SimpleCredentials;
    }

    public boolean authenticate(Credentials credentials) throws RepositoryException {
        if (!(credentials instanceof SimpleCredentials)) {
            throw new RepositoryException("SimpleCredentials expected. Cannot handle " + credentials.getClass().getName());
        }
        try {
            if (this.creds != null && this.creds.matches((SimpleCredentials)credentials)) {
                return true;
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.debug("Failed to verify Credentials with {}: {} -> test next", (Object)credentials.toString(), (Object)e);
        }
        catch (UnsupportedEncodingException e) {
            log.debug("Failed to verify Credentials with {}: {} -> test next", (Object)credentials.toString(), (Object)e);
        }
        return false;
    }
}

