/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.xml.TextValue;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.util.Base64;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BufferedStringValue
implements TextValue {
    private static Logger log = LoggerFactory.getLogger(BufferedStringValue.class);
    private static final int MAX_BUFFER_SIZE = 65536;
    private static final int BUFFER_INCREMENT = 8192;
    private char[] buffer = new char[8192];
    private int bufferPos = 0;
    private File tmpFile = null;
    private Writer writer = null;
    private final NamePathResolver nsContext;

    protected BufferedStringValue(NamePathResolver nsContext) {
        this.nsContext = nsContext;
    }

    public long length() throws IOException {
        if (this.buffer != null) {
            return this.bufferPos;
        }
        if (this.tmpFile != null) {
            this.writer.flush();
            return this.tmpFile.length();
        }
        throw new IOException("this instance has already been disposed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retrieve() throws IOException {
        if (this.buffer != null) {
            return new String(this.buffer, 0, this.bufferPos);
        }
        if (this.tmpFile != null) {
            this.writer.flush();
            if (this.tmpFile.length() > Integer.MAX_VALUE) {
                throw new IOException("size of value is too big, use reader()");
            }
            StringBuffer sb = new StringBuffer((int)this.tmpFile.length());
            char[] chunk = new char[8192];
            FileReader reader = new FileReader(this.tmpFile);
            try {
                int read;
                while ((read = reader.read(chunk)) > -1) {
                    sb.append(chunk, 0, read);
                }
            }
            finally {
                ((Reader)reader).close();
            }
            return sb.toString();
        }
        throw new IOException("this instance has already been disposed");
    }

    public Reader reader() throws IOException {
        if (this.buffer != null) {
            return new StringReader(new String(this.buffer, 0, this.bufferPos));
        }
        if (this.tmpFile != null) {
            this.writer.flush();
            return new FileReader(this.tmpFile);
        }
        throw new IOException("this instance has already been disposed");
    }

    public void append(char[] chars, int start, int length) throws IOException {
        if (this.buffer != null) {
            if (this.bufferPos + length > 65536) {
                TransientFileFactory fileFactory = TransientFileFactory.getInstance();
                this.tmpFile = fileFactory.createTransientFile("txt", null, null);
                final FileOutputStream fout = new FileOutputStream(this.tmpFile);
                this.writer = new OutputStreamWriter(fout){

                    public void flush() throws IOException {
                        super.flush();
                        fout.getFD().sync();
                    }
                };
                this.writer.write(this.buffer, 0, this.bufferPos);
                this.writer.write(chars, start, length);
                this.buffer = null;
                this.bufferPos = 0;
            } else {
                if (this.bufferPos + length > this.buffer.length) {
                    int bufferSize = 8192 * ((this.bufferPos + length) / 8192 + 1);
                    char[] newBuffer = new char[bufferSize];
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.bufferPos);
                    this.buffer = newBuffer;
                }
                System.arraycopy(chars, start, this.buffer, this.bufferPos, length);
                this.bufferPos += length;
            }
        } else if (this.tmpFile != null) {
            this.writer.write(chars, start, length);
        } else {
            throw new IOException("this instance has already been disposed");
        }
    }

    public void close() throws IOException {
        if (this.buffer == null) {
            if (this.tmpFile != null) {
                this.writer.close();
            } else {
                throw new IOException("this instance has already been disposed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Value getValue(int targetType, NamePathResolver resolver) throws ValueFormatException, RepositoryException {
        Value value;
        if (targetType == 7 || targetType == 8) {
            InternalValue ival = InternalValue.create(ValueHelper.convert(this.retrieve(), targetType, ValueFactoryImpl.getInstance()), this.nsContext);
            return ival.toJCRValue(resolver);
        }
        if (targetType != 2) return ValueHelper.deserialize(this.retrieve(), targetType, false, ValueFactoryImpl.getInstance());
        if (this.length() < 65536L) {
            return ValueHelper.deserialize(this.retrieve(), targetType, false, ValueFactoryImpl.getInstance());
        }
        Reader reader = this.reader();
        try {
            value = ValueHelper.deserialize(reader, targetType, false, ValueFactoryImpl.getInstance());
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                String msg = "failed to retrieve serialized value";
                log.debug(msg, e);
                throw new RepositoryException(msg, e);
            }
        }
        reader.close();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalValue getInternalValue(int type) throws ValueFormatException, RepositoryException {
        try {
            if (type == 2) {
                if (this.length() < 65536L) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Base64.decode(this.retrieve(), (OutputStream)baos);
                    return InternalValue.create(baos.toByteArray());
                }
                if (InternalValue.USE_DATA_STORE) {
                    Base64ReaderInputStream in = new Base64ReaderInputStream(this.reader());
                    return InternalValue.createTemporary(in);
                }
                TransientFileFactory fileFactory = TransientFileFactory.getInstance();
                File tmpFile = fileFactory.createTransientFile("bin", null, null);
                FileOutputStream out = new FileOutputStream(tmpFile);
                Reader reader = this.reader();
                try {
                    Base64.decode(reader, (OutputStream)out);
                }
                finally {
                    reader.close();
                    out.close();
                }
                return InternalValue.create(tmpFile);
            }
            return InternalValue.create(ValueHelper.convert(this.retrieve(), type, ValueFactoryImpl.getInstance()), this.nsContext);
        }
        catch (IOException e) {
            throw new RepositoryException("Error accessing property value", e);
        }
    }

    public void dispose() {
        if (this.buffer != null) {
            this.buffer = null;
            this.bufferPos = 0;
        } else if (this.tmpFile != null) {
            try {
                this.writer.close();
                this.tmpFile.delete();
                this.tmpFile = null;
                this.writer = null;
            }
            catch (IOException e) {
                log.warn("Problem disposing property value", e);
            }
        } else {
            log.warn("this instance has already been disposed");
        }
    }

    private static class Base64ReaderInputStream
    extends InputStream {
        private static final int BUFFER_SIZE = 1024;
        private final char[] chars = new char[1024];
        private final ByteArrayOutputStream out;
        private final Reader reader;
        private int pos;
        private int remaining;
        private byte[] buffer;

        public Base64ReaderInputStream(Reader reader) {
            this.reader = reader;
            this.out = new ByteArrayOutputStream(1024);
        }

        private void fillBuffer() throws IOException {
            int len = this.reader.read(this.chars, 0, 1024);
            if (len < 0) {
                this.remaining = -1;
                return;
            }
            Base64.decode(this.chars, 0, len, this.out);
            this.buffer = this.out.toByteArray();
            this.pos = 0;
            this.remaining = this.buffer.length;
            this.out.reset();
        }

        public int read() throws IOException {
            if (this.remaining == 0) {
                this.fillBuffer();
            }
            if (this.remaining < 0) {
                return -1;
            }
            --this.remaining;
            return this.buffer[this.pos++] & 0xFF;
        }
    }
}

