/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.version.report;

import javax.jcr.Repository;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.jcr.ItemResourceConstants;
import org.apache.jackrabbit.webdav.jcr.version.report.AbstractJcrReport;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RepositoryDescriptorsReport
extends AbstractJcrReport
implements ItemResourceConstants {
    private static Logger log = LoggerFactory.getLogger(RepositoryDescriptorsReport.class);
    public static final ReportType REPOSITORY_DESCRIPTORS_REPORT = ReportType.register("repositorydescriptors", ItemResourceConstants.NAMESPACE, RepositoryDescriptorsReport.class);

    public ReportType getType() {
        return REPOSITORY_DESCRIPTORS_REPORT;
    }

    public boolean isMultiStatusReport() {
        return false;
    }

    public void init(DavResource resource, ReportInfo info) throws DavException {
        super.init(resource, info);
    }

    public Element toXml(Document document) {
        Repository repository = this.getRepositorySession().getRepository();
        Element report = DomUtil.createElement(document, "repositorydescriptors-report", NAMESPACE);
        String[] keys = repository.getDescriptorKeys();
        for (int i = 0; i < keys.length; ++i) {
            Element elem = DomUtil.addChildElement(report, "descriptor", NAMESPACE);
            DomUtil.addChildElement(elem, "descriptorkey", NAMESPACE, keys[i]);
            DomUtil.addChildElement(elem, "descriptorvalue", NAMESPACE, repository.getDescriptor(keys[i]));
        }
        return report;
    }
}

