/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.retention.RetentionManagerImpl;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.authorization.acl.ACLEditor;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;

public abstract class ProtectedItemModifier {
    private static final int DEFAULT_PERM_CHECK = -1;
    private final int permission;

    protected ProtectedItemModifier() {
        this(-1);
    }

    protected ProtectedItemModifier(int permission) {
        Class<?> cl = this.getClass();
        if (!(cl.equals(UserManagerImpl.class) || cl.equals(RetentionManagerImpl.class) || cl.equals(ACLEditor.class) || cl.equals(org.apache.jackrabbit.core.security.authorization.principalbased.ACLEditor.class))) {
            throw new IllegalArgumentException("Only UserManagerImpl, RetentionManagerImpl and ACLEditor may extend from the ProtectedItemModifier");
        }
        this.permission = permission;
    }

    protected NodeImpl addNode(NodeImpl parentImpl, Name name, Name ntName) throws RepositoryException {
        this.checkPermission(parentImpl, name, this.getPermission(true, false));
        parentImpl.checkSetProperty();
        NodeTypeImpl nodeType = parentImpl.session.getNodeTypeManager().getNodeType(ntName);
        NodeDefinitionImpl def = parentImpl.getApplicableChildNodeDefinition(name, ntName);
        NodeState thisState = (NodeState)parentImpl.getItemState();
        ChildNodeEntry cne = thisState.getChildNodeEntry(name, 1);
        if (cne != null) {
            if (!def.allowsSameNameSiblings()) {
                throw new ItemExistsException();
            }
            NodeId newId = cne.getId();
            NodeImpl n = (NodeImpl)parentImpl.session.getItemManager().getItem(newId);
            if (!n.getDefinition().allowsSameNameSiblings()) {
                throw new ItemExistsException();
            }
        }
        return parentImpl.createChildNode(name, def, nodeType, null);
    }

    protected Property setProperty(NodeImpl parentImpl, Name name, Value value) throws RepositoryException {
        return this.setProperty(parentImpl, name, value, false);
    }

    protected Property setProperty(NodeImpl parentImpl, Name name, Value value, boolean ignorePermissions) throws RepositoryException {
        if (!ignorePermissions) {
            this.checkPermission(parentImpl, name, this.getPermission(false, false));
        }
        parentImpl.checkSetProperty();
        InternalValue intVs = InternalValue.create(value, parentImpl.session);
        return parentImpl.internalSetProperty(name, intVs);
    }

    protected Property setProperty(NodeImpl parentImpl, Name name, Value[] values) throws RepositoryException {
        this.checkPermission(parentImpl, name, this.getPermission(false, false));
        parentImpl.checkSetProperty();
        InternalValue[] intVs = new InternalValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            intVs[i] = InternalValue.create(values[i], parentImpl.session);
        }
        return parentImpl.internalSetProperty(name, intVs);
    }

    protected void removeItem(ItemImpl itemImpl) throws RepositoryException {
        NodeImpl n = itemImpl.isNode() ? (NodeImpl)itemImpl : (NodeImpl)itemImpl.getParent();
        this.checkPermission(itemImpl, this.getPermission(itemImpl.isNode(), true));
        n.checkSetProperty();
        itemImpl.internalRemove(true);
    }

    private void checkPermission(ItemImpl item, int perm) throws RepositoryException {
        if (perm > 0) {
            SessionImpl sImpl = (SessionImpl)item.getSession();
            AccessManager acMgr = sImpl.getAccessManager();
            Path path = item.getPrimaryPath();
            acMgr.checkPermission(path, perm);
        }
    }

    private void checkPermission(NodeImpl node, Name childName, int perm) throws RepositoryException {
        SessionImpl sImpl;
        AccessManager acMgr;
        boolean isGranted;
        if (perm > 0 && !(isGranted = (acMgr = (sImpl = (SessionImpl)node.getSession()).getAccessManager()).isGranted(node.getPrimaryPath(), childName, perm))) {
            throw new AccessDeniedException("Permission denied.");
        }
    }

    private int getPermission(boolean isNode, boolean isRemove) {
        if (this.permission < 0) {
            if (isNode) {
                return isRemove ? 8 : 4;
            }
            return isRemove ? 16 : 2;
        }
        return this.permission;
    }
}

