/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeIdIterator;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.bundle.AbstractBundlePersistenceManager;
import org.apache.jackrabbit.core.persistence.bundle.util.BundleBinding;
import org.apache.jackrabbit.core.persistence.bundle.util.ConnectionRecoveryManager;
import org.apache.jackrabbit.core.persistence.bundle.util.DbNameIndex;
import org.apache.jackrabbit.core.persistence.bundle.util.ErrorHandling;
import org.apache.jackrabbit.core.persistence.bundle.util.NodePropBundle;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.FileSystemBLOBStore;
import org.apache.jackrabbit.core.persistence.util.Serializer;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.util.StringIndex;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleDbPersistenceManager
extends AbstractBundlePersistenceManager {
    private static Logger log = LoggerFactory.getLogger(BundleDbPersistenceManager.class);
    public static final String SCHEMA_OBJECT_PREFIX_VARIABLE = "${schemaObjectPrefix}";
    public static final int SM_BINARY_KEYS = 1;
    public static final int SM_LONGLONG_KEYS = 2;
    protected boolean initialized = false;
    protected String driver;
    protected String url;
    protected String user;
    protected String password;
    protected String databaseType;
    protected String schemaObjectPrefix;
    protected boolean consistencyCheck = false;
    protected boolean consistencyFix = false;
    protected static final int INITIAL_BUFFER_SIZE = 1024;
    protected boolean externalBLOBs;
    protected boolean blockOnConnectionLoss = false;
    protected ConnectionRecoveryManager connectionManager;
    protected String bundleInsertSQL;
    protected String bundleUpdateSQL;
    protected String bundleSelectSQL;
    protected String bundleDeleteSQL;
    protected String bundleSelectAllIdsFromSQL;
    protected String bundleSelectAllIdsSQL;
    protected String nodeReferenceInsertSQL;
    protected String nodeReferenceUpdateSQL;
    protected String nodeReferenceSelectSQL;
    protected String nodeReferenceDeleteSQL;
    protected CloseableBLOBStore blobStore;
    private StringIndex nameIndex;
    private int minBlobSize = 4096;
    protected ErrorHandling errorHandling = new ErrorHandling();
    protected BundleBinding binding;
    private String name = super.toString();
    private boolean schemaCheckEnabled = true;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getSchemaObjectPrefix() {
        return this.schemaObjectPrefix;
    }

    public void setSchemaObjectPrefix(String schemaObjectPrefix) {
        this.schemaObjectPrefix = schemaObjectPrefix.toUpperCase();
    }

    public String getSchema() {
        return this.databaseType;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public void setSchema(String databaseType) {
        this.databaseType = databaseType;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public boolean isExternalBLOBs() {
        return this.externalBLOBs;
    }

    public void setExternalBLOBs(boolean externalBLOBs) {
        this.externalBLOBs = externalBLOBs;
    }

    public String getConsistencyCheck() {
        return Boolean.toString(this.consistencyCheck);
    }

    public void setConsistencyCheck(String consistencyCheck) {
        this.consistencyCheck = Boolean.valueOf(consistencyCheck);
    }

    public String getConsistencyFix() {
        return Boolean.toString(this.consistencyFix);
    }

    public void setConsistencyFix(String consistencyFix) {
        this.consistencyFix = Boolean.valueOf(consistencyFix);
    }

    public String getMinBlobSize() {
        return String.valueOf(this.minBlobSize);
    }

    public void setMinBlobSize(String minBlobSize) {
        this.minBlobSize = Integer.decode(minBlobSize);
    }

    public void setErrorHandling(String errorHandling) {
        this.errorHandling = new ErrorHandling(errorHandling);
    }

    public String getErrorHandling() {
        return this.errorHandling.toString();
    }

    public void setBlockOnConnectionLoss(String block) {
        this.blockOnConnectionLoss = Boolean.valueOf(block);
    }

    public String getBlockOnConnectionLoss() {
        return Boolean.toString(this.blockOnConnectionLoss);
    }

    public boolean useDbBlobStore() {
        return !this.externalBLOBs;
    }

    public boolean useLocalFsBlobStore() {
        return this.externalBLOBs;
    }

    public final boolean isSchemaCheckEnabled() {
        return this.schemaCheckEnabled;
    }

    public final void setSchemaCheckEnabled(boolean enabled) {
        this.schemaCheckEnabled = enabled;
    }

    protected void checkSchema() throws SQLException, RepositoryException {
        if (!this.checkTablesExist()) {
            InputStream in = BundleDbPersistenceManager.class.getResourceAsStream(this.databaseType + ".ddl");
            if (in == null) {
                String msg = "Configuration error: The resource '" + this.databaseType + ".ddl' could not be found";
                log.debug(msg);
                throw new RepositoryException(msg);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            Statement stmt = this.connectionManager.getConnection().createStatement();
            String sql = null;
            try {
                sql = reader.readLine();
                while (sql != null) {
                    if (!sql.startsWith("#") && sql.length() > 0 && (sql.indexOf("BINVAL") < 0 || this.useDbBlobStore())) {
                        sql = this.createSchemaSQL(sql);
                        stmt.executeUpdate(sql);
                    }
                    sql = reader.readLine();
                }
            }
            catch (IOException e) {
                String msg = "Configuration error: unable to read the resource '" + this.databaseType + ".ddl': " + e;
                log.debug(msg);
                throw new RepositoryException(msg, e);
            }
            catch (SQLException e) {
                String msg = "Schema generation error: Issuing statement: " + sql;
                SQLException se = new SQLException(msg);
                se.initCause(e);
                throw se;
            }
            finally {
                IOUtils.closeQuietly(in);
                stmt.close();
            }
        }
    }

    protected String createSchemaSQL(String sql) {
        return Text.replace(sql, SCHEMA_OBJECT_PREFIX_VARIABLE, this.schemaObjectPrefix).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkTablesExist() throws SQLException, RepositoryException {
        DatabaseMetaData metaData = this.connectionManager.getConnection().getMetaData();
        String tableName = this.schemaObjectPrefix + "BUNDLE";
        if (metaData.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        } else if (metaData.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        }
        String userName = this.checkTablesWithUser() ? metaData.getUserName() : null;
        ResultSet rs = metaData.getTables(null, userName, tableName, null);
        try {
            boolean bl = rs.next();
            return bl;
        }
        finally {
            rs.close();
        }
    }

    protected boolean checkTablesWithUser() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store(ChangeLog changeLog) throws ItemStateException {
        int trials = 2;
        Throwable lastException = null;
        do {
            --trials;
            Connection con = null;
            try {
                con = this.connectionManager.getConnection();
                this.connectionManager.setAutoReconnect(false);
                con.setAutoCommit(false);
                super.store(changeLog);
                con.commit();
                con.setAutoCommit(true);
                return;
            }
            catch (Throwable th) {
                lastException = th;
                try {
                    if (con != null) {
                        con.rollback();
                    }
                }
                catch (SQLException e) {
                    this.logException("rollback failed", e);
                }
                if (!(th instanceof SQLException) && !(th.getCause() instanceof SQLException)) continue;
                this.connectionManager.close();
            }
            finally {
                this.connectionManager.setAutoReconnect(true);
            }
        } while (this.blockOnConnectionLoss || trials > 0);
        throw new ItemStateException(lastException.getMessage(), lastException);
    }

    public void init(PMContext context) throws Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        super.init(context);
        this.name = context.getHomeDir().getName();
        this.connectionManager = new ConnectionRecoveryManager(this.blockOnConnectionLoss, this.getDriver(), this.getUrl(), this.getUser(), this.getPassword());
        this.prepareSchemaObjectPrefix();
        if (this.isSchemaCheckEnabled()) {
            this.checkSchema();
        }
        this.blobStore = this.createBlobStore();
        this.buildSQLStatements();
        this.binding = new BundleBinding(this.errorHandling, this.blobStore, this.getNsIndex(), this.getNameIndex(), context.getDataStore());
        this.binding.setMinBlobSize(this.minBlobSize);
        this.initialized = true;
        if (this.consistencyCheck) {
            this.checkConsistency(null, true, this.consistencyFix);
        }
    }

    protected BundleBinding getBinding() {
        return this.binding;
    }

    protected CloseableBLOBStore createBlobStore() throws Exception {
        if (this.useLocalFsBlobStore()) {
            return this.createLocalFSBlobStore(this.context);
        }
        return this.createDBBlobStore(this.context);
    }

    public StringIndex getNameIndex() {
        try {
            if (this.nameIndex == null) {
                FileSystemResource res = new FileSystemResource(this.context.getFileSystem(), "/names.properties");
                this.nameIndex = res.exists() ? super.getNameIndex() : this.createDbNameIndex();
            }
            return this.nameIndex;
        }
        catch (Exception e) {
            IllegalStateException exception = new IllegalStateException("Unable to create nsIndex");
            exception.initCause(e);
            throw exception;
        }
    }

    protected DbNameIndex createDbNameIndex() throws SQLException {
        return new DbNameIndex(this.connectionManager, this.schemaObjectPrefix);
    }

    public int getStorageModel() {
        return 1;
    }

    protected CloseableBLOBStore createLocalFSBlobStore(PMContext context) throws Exception {
        LocalFileSystem blobFS = new LocalFileSystem();
        blobFS.setRoot(new File(context.getHomeDir(), "blobs"));
        blobFS.init();
        return new FSBlobStore(blobFS);
    }

    protected CloseableBLOBStore createDBBlobStore(PMContext context) throws Exception {
        return new DbBlobStore();
    }

    protected void checkBundleConsistency(NodeId id, NodePropBundle bundle, boolean fix, Collection modifications) {
        if (id.toString().endsWith("babecafebabe") && !id.toString().equals("cafebabe-cafe-babe-cafe-babecafebabe")) {
            return;
        }
        ArrayList<NodePropBundle.ChildNodeEntry> missingChildren = new ArrayList<NodePropBundle.ChildNodeEntry>();
        Iterator iter = bundle.getChildNodeEntries().iterator();
        while (iter.hasNext()) {
            NodePropBundle.ChildNodeEntry entry = (NodePropBundle.ChildNodeEntry)iter.next();
            if (entry.getId().toString().endsWith("babecafebabe")) continue;
            try {
                NodePropBundle child = this.loadBundle(entry.getId(), true);
                if (child == null) {
                    log.error("NodeState '" + id + "' references inexistent child" + " '" + entry.getName() + "' with id " + "'" + entry.getId() + "'");
                    missingChildren.add(entry);
                    continue;
                }
                NodeId cp = child.getParentId();
                if (cp == null) {
                    log.error("ChildNode has invalid parent uuid: <null>");
                    continue;
                }
                if (cp.equals(id)) continue;
                log.error("ChildNode has invalid parent uuid: '" + cp + "' (instead of '" + id + "')");
            }
            catch (ItemStateException e) {}
        }
        if (fix && !missingChildren.isEmpty()) {
            Iterator iterator = missingChildren.iterator();
            while (iterator.hasNext()) {
                bundle.getChildNodeEntries().remove(iterator.next());
            }
            modifications.add(bundle);
        }
        NodeId parentId = bundle.getParentId();
        try {
            if (parentId != null && !id.toString().endsWith("babecafebabe") && !this.existsBundle(parentId)) {
                log.error("NodeState '" + id + "' references inexistent parent uuid '" + parentId + "'");
            }
        }
        catch (ItemStateException e) {
            log.error("Error reading node '" + parentId + "' (parent of '" + id + "'): " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConsistency(String[] uuids, boolean recursive, boolean fix) {
        ArrayList modifications;
        int total;
        int count;
        block33: {
            int i;
            NodeId id;
            block34: {
                log.info("{}: checking workspace consistency...", (Object)this.name);
                count = 0;
                total = 0;
                modifications = new ArrayList();
                if (uuids != null) break block34;
                ResultSet rs = null;
                try {
                    String sql = "select count(*) from " + this.schemaObjectPrefix + "BUNDLE";
                    PreparedStatement stmt = this.connectionManager.executeStmt(sql, new Object[0]);
                    try {
                        rs = stmt.getResultSet();
                        if (!rs.next()) {
                            log.error("Could not retrieve total number of bundles. empty result set.");
                            this.closeResultSet(rs);
                            total = count;
                            return;
                        }
                        total = rs.getInt(1);
                    }
                    finally {
                        this.closeResultSet(rs);
                    }
                    sql = this.getStorageModel() == 1 ? "select NODE_ID from " + this.schemaObjectPrefix + "BUNDLE" : "select NODE_ID_HI, NODE_ID_LO from " + this.schemaObjectPrefix + "BUNDLE";
                    stmt = this.connectionManager.executeStmt(sql, new Object[0]);
                    rs = stmt.getResultSet();
                    while (rs.next()) {
                        id = this.getStorageModel() == 1 ? new NodeId(new UUID(rs.getBytes(1))) : new NodeId(new UUID(rs.getLong(1), rs.getLong(2)));
                        ResultSet bRs = null;
                        byte[] data = null;
                        try {
                            PreparedStatement bSmt = this.connectionManager.executeStmt(this.bundleSelectSQL, this.getKey(id.getUUID()));
                            bRs = bSmt.getResultSet();
                            if (!bRs.next()) {
                                throw new SQLException("bundle cannot be retrieved?");
                            }
                            Blob blob = bRs.getBlob(1);
                            data = this.getBytes(blob);
                            this.closeResultSet(bRs);
                        }
                        catch (Throwable throwable) {
                            this.closeResultSet(bRs);
                            throw throwable;
                        }
                        try {
                            DataInputStream din = new DataInputStream(new ByteArrayInputStream(data));
                            if (this.binding.checkBundle(din)) {
                                din = new DataInputStream(new ByteArrayInputStream(data));
                                NodePropBundle bundle = this.binding.readBundle(din, id);
                                this.checkBundleConsistency(id, bundle, fix, modifications);
                            } else {
                                log.error("invalid bundle '" + id + "', see previous BundleBinding error log entry");
                            }
                        }
                        catch (Exception e) {
                            log.error("Error in bundle " + id + ": " + e);
                        }
                        if (++count % 1000 != 0) continue;
                        log.info(this.name + ": checked " + count + "/" + total + " bundles...");
                    }
                    this.closeResultSet(rs);
                }
                catch (Exception e) {
                    log.error("Error loading bundle", e);
                    break block33;
                }
                finally {
                    this.closeResultSet(rs);
                    total = count;
                }
                total = count;
                break block33;
            }
            ArrayList<UUID> uuidList = new ArrayList<UUID>(uuids.length);
            for (i = 0; i < uuids.length; ++i) {
                try {
                    uuidList.add(new UUID(uuids[i]));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    log.error("Invalid uuid for consistency check, skipping: '" + uuids[i] + "': " + e);
                }
            }
            for (i = 0; i < uuidList.size(); ++i) {
                UUID uuid = (UUID)uuidList.get(i);
                try {
                    id = new NodeId(uuid);
                    NodePropBundle bundle = this.loadBundle(id, true);
                    if (bundle == null) {
                        log.error("No bundle found for uuid '" + uuid + "'");
                        continue;
                    }
                    this.checkBundleConsistency(id, bundle, fix, modifications);
                    if (recursive) {
                        Iterator iter = bundle.getChildNodeEntries().iterator();
                        while (iter.hasNext()) {
                            NodePropBundle.ChildNodeEntry entry = (NodePropBundle.ChildNodeEntry)iter.next();
                            uuidList.add(entry.getId().getUUID());
                        }
                    }
                    if (++count % 1000 != 0) continue;
                    log.info(this.name + ": checked " + count + "/" + uuidList.size() + " bundles...");
                    continue;
                }
                catch (ItemStateException e) {
                    // empty catch block
                }
            }
            total = uuidList.size();
        }
        if (fix && !modifications.isEmpty()) {
            log.info(this.name + ": Fixing " + modifications.size() + " inconsistent bundle(s)...");
            Iterator iterator = modifications.iterator();
            while (iterator.hasNext()) {
                NodePropBundle bundle = (NodePropBundle)iterator.next();
                try {
                    log.info(this.name + ": Fixing bundle '" + bundle.getId() + "'");
                    bundle.markOld();
                    this.storeBundle(bundle);
                    this.evictBundle(bundle.getId());
                }
                catch (ItemStateException e) {
                    log.error(this.name + ": Error storing fixed bundle: " + e);
                }
            }
        }
        log.info(this.name + ": checked " + count + "/" + total + " bundles.");
    }

    protected void prepareSchemaObjectPrefix() throws Exception {
        DatabaseMetaData metaData = this.connectionManager.getConnection().getMetaData();
        String legalChars = metaData.getExtraNameCharacters();
        legalChars = legalChars + "ABCDEFGHIJKLMNOPQRSTUVWXZY0123456789_";
        String prefix = this.schemaObjectPrefix.toUpperCase();
        StringBuffer escaped = new StringBuffer();
        for (int i = 0; i < prefix.length(); ++i) {
            char c = prefix.charAt(i);
            if (legalChars.indexOf(c) == -1) {
                escaped.append("_x");
                String hex = Integer.toHexString(c);
                escaped.append("0000".toCharArray(), 0, 4 - hex.length());
                escaped.append(hex);
                escaped.append("_");
                continue;
            }
            escaped.append(c);
        }
        this.schemaObjectPrefix = escaped.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            if (this.nameIndex instanceof DbNameIndex) {
                ((DbNameIndex)this.nameIndex).close();
            }
            this.connectionManager.close();
            this.blobStore.close();
            this.blobStore = null;
            super.close();
        }
        finally {
            this.initialized = false;
        }
    }

    protected int setKey(PreparedStatement stmt, UUID uuid, int pos) throws SQLException {
        if (this.getStorageModel() == 1) {
            stmt.setBytes(pos++, uuid.getRawBytes());
        } else {
            stmt.setLong(pos++, uuid.getMostSignificantBits());
            stmt.setLong(pos++, uuid.getLeastSignificantBits());
        }
        return pos;
    }

    protected Object[] getKey(UUID uuid) {
        if (this.getStorageModel() == 1) {
            return new Object[]{uuid.getRawBytes()};
        }
        return new Object[]{new Long(uuid.getMostSignificantBits()), new Long(uuid.getLeastSignificantBits())};
    }

    protected Object[] createParams(UUID uuid, Object p, boolean before) {
        ArrayList<Object> key = new ArrayList<Object>();
        if (this.getStorageModel() == 1) {
            key.add(uuid.getRawBytes());
        } else {
            key.add(new Long(uuid.getMostSignificantBits()));
            key.add(new Long(uuid.getLeastSignificantBits()));
        }
        ArrayList<Object> params = new ArrayList<Object>();
        if (before) {
            params.add(p);
            params.addAll(key);
        } else {
            params.addAll(key);
            params.add(p);
        }
        return params.toArray();
    }

    public synchronized NodeIdIterator getAllNodeIds(NodeId bigger, int maxCount) throws ItemStateException, RepositoryException {
        ResultSet rs = null;
        try {
            Object[] keys;
            UUID lowUuid;
            String sql;
            if (bigger == null) {
                sql = this.bundleSelectAllIdsSQL;
                lowUuid = null;
                keys = new Object[]{};
            } else {
                sql = this.bundleSelectAllIdsFromSQL;
                lowUuid = bigger.getUUID();
                keys = this.getKey(lowUuid);
            }
            if (maxCount > 0) {
                maxCount += 10;
            }
            PreparedStatement stmt = this.connectionManager.executeStmt(sql, keys, false, maxCount);
            rs = stmt.getResultSet();
            ArrayList<UUID> result = new ArrayList<UUID>();
            while ((maxCount == 0 || result.size() < maxCount) && rs.next()) {
                UUID current;
                if (this.getStorageModel() == 1) {
                    current = new UUID(rs.getBytes(1));
                } else {
                    long high = rs.getLong(1);
                    long low = rs.getLong(2);
                    current = new UUID(high, low);
                }
                if (lowUuid != null && current.compareTo(lowUuid) <= 0) continue;
                result.add(current);
            }
            ListNodeIdIterator listNodeIdIterator = new ListNodeIdIterator(result);
            this.closeResultSet(rs);
            return listNodeIdIterator;
        }
        catch (SQLException e) {
            try {
                String msg = "getAllNodeIds failed.";
                log.error(msg, e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    protected synchronized NodePropBundle loadBundle(NodeId id) throws ItemStateException {
        return this.loadBundle(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytes(Blob blob) throws SQLException, IOException {
        byte[] byArray;
        InputStream in = null;
        try {
            int read;
            long length = blob.length();
            byte[] bytes = new byte[(int)length];
            in = blob.getBinaryStream();
            int pos = 0;
            while ((read = in.read(bytes, pos, bytes.length - pos)) > 0) {
                pos += read;
            }
            byArray = bytes;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        return byArray;
    }

    protected synchronized NodePropBundle loadBundle(NodeId id, boolean checkBeforeLoading) throws ItemStateException {
        ResultSet rs;
        block8: {
            rs = null;
            PreparedStatement stmt = this.connectionManager.executeStmt(this.bundleSelectSQL, this.getKey(id.getUUID()));
            rs = stmt.getResultSet();
            if (rs.next()) break block8;
            NodePropBundle nodePropBundle = null;
            this.closeResultSet(rs);
            return nodePropBundle;
        }
        try {
            Blob b = rs.getBlob(1);
            byte[] bytes = this.getBytes(b);
            DataInputStream din = new DataInputStream(new ByteArrayInputStream(bytes));
            if (checkBeforeLoading) {
                if (this.binding.checkBundle(din)) {
                    din = new DataInputStream(new ByteArrayInputStream(bytes));
                } else {
                    throw new Exception("invalid bundle, see previous BundleBinding error log entry");
                }
            }
            NodePropBundle bundle = this.binding.readBundle(din, id);
            bundle.setSize(bytes.length);
            NodePropBundle nodePropBundle = bundle;
            this.closeResultSet(rs);
            return nodePropBundle;
        }
        catch (Exception e) {
            try {
                String msg = "failed to read bundle: " + id + ": " + e;
                log.error(msg);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    protected synchronized boolean existsBundle(NodeId id) throws ItemStateException {
        ResultSet rs = null;
        try {
            PreparedStatement stmt = this.connectionManager.executeStmt(this.bundleSelectSQL, this.getKey(id.getUUID()));
            rs = stmt.getResultSet();
            boolean bl = rs.next();
            this.closeResultSet(rs);
            return bl;
        }
        catch (Exception e) {
            try {
                String msg = "failed to check existence of bundle: " + id;
                log.error(msg, e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    protected synchronized void storeBundle(NodePropBundle bundle) throws ItemStateException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            DataOutputStream dout = new DataOutputStream(out);
            this.binding.writeBundle(dout, bundle);
            dout.close();
            String sql = bundle.isNew() ? this.bundleInsertSQL : this.bundleUpdateSQL;
            Object[] params = this.createParams(bundle.getId().getUUID(), out.toByteArray(), true);
            this.connectionManager.executeStmt(sql, params);
        }
        catch (Exception e) {
            String msg = "failed to write bundle: " + bundle.getId();
            log.error(msg, e);
            throw new ItemStateException(msg, e);
        }
    }

    protected synchronized void destroyBundle(NodePropBundle bundle) throws ItemStateException {
        try {
            this.connectionManager.executeStmt(this.bundleDeleteSQL, this.getKey(bundle.getId().getUUID()));
        }
        catch (Exception e) {
            if (e instanceof NoSuchItemStateException) {
                throw (NoSuchItemStateException)e;
            }
            String msg = "failed to delete bundle: " + bundle.getId();
            log.error(msg, e);
            throw new ItemStateException(msg, e);
        }
    }

    public synchronized NodeReferences load(NodeReferencesId targetId) throws NoSuchItemStateException, ItemStateException {
        NodeReferences nodeReferences;
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        ResultSet rs = null;
        InputStream in = null;
        try {
            PreparedStatement stmt = this.connectionManager.executeStmt(this.nodeReferenceSelectSQL, this.getKey(targetId.getTargetId().getUUID()));
            rs = stmt.getResultSet();
            if (!rs.next()) {
                throw new NoSuchItemStateException(targetId.toString());
            }
            in = rs.getBinaryStream(1);
            NodeReferences refs = new NodeReferences(targetId);
            Serializer.deserialize(refs, in);
            nodeReferences = refs;
        }
        catch (Exception e) {
            try {
                if (e instanceof NoSuchItemStateException) {
                    throw (NoSuchItemStateException)e;
                }
                String msg = "failed to read references: " + targetId;
                log.error(msg, e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                this.closeResultSet(rs);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        this.closeResultSet(rs);
        return nodeReferences;
    }

    public synchronized void store(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        boolean update = this.exists(refs.getId());
        String sql = update ? this.nodeReferenceUpdateSQL : this.nodeReferenceInsertSQL;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(refs, (OutputStream)out);
            Object[] params = this.createParams(refs.getTargetId().getUUID(), out.toByteArray(), true);
            this.connectionManager.executeStmt(sql, params);
        }
        catch (Exception e) {
            String msg = "failed to write node references: " + refs.getId();
            log.error(msg, e);
            throw new ItemStateException(msg, e);
        }
    }

    public synchronized void destroy(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            this.connectionManager.executeStmt(this.nodeReferenceDeleteSQL, this.getKey(refs.getTargetId().getUUID()));
        }
        catch (Exception e) {
            if (e instanceof NoSuchItemStateException) {
                throw (NoSuchItemStateException)e;
            }
            String msg = "failed to delete references: " + refs.getTargetId();
            log.error(msg, e);
            throw new ItemStateException(msg, e);
        }
    }

    public synchronized boolean exists(NodeReferencesId targetId) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        ResultSet rs = null;
        try {
            PreparedStatement stmt = this.connectionManager.executeStmt(this.nodeReferenceSelectSQL, this.getKey(targetId.getTargetId().getUUID()));
            rs = stmt.getResultSet();
            boolean bl = rs.next();
            this.closeResultSet(rs);
            return bl;
        }
        catch (Exception e) {
            try {
                String msg = "failed to check existence of node references: " + targetId;
                log.error(msg, e);
                throw new ItemStateException(msg, e);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    protected synchronized void resetStatement(PreparedStatement stmt) {
        if (stmt != null) {
            try {
                stmt.clearParameters();
                stmt.clearWarnings();
            }
            catch (SQLException se) {
                this.logException("Failed resetting PreparedStatement", se);
            }
        }
    }

    protected void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException se) {
                this.logException("Failed closing ResultSet", se);
            }
        }
    }

    protected void closeStatement(PreparedStatement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException se) {
                this.logException("Failed closing PreparedStatement", se);
            }
        }
    }

    protected void logException(String message, SQLException e) {
        if (message != null) {
            log.error(message);
        }
        log.error("       Reason: " + e.getMessage());
        log.error("   State/Code: " + e.getSQLState() + "/" + e.getErrorCode());
        log.debug("   dump:", e);
    }

    public String toString() {
        return this.name;
    }

    protected void buildSQLStatements() {
        if (this.getStorageModel() == 1) {
            this.bundleInsertSQL = "insert into " + this.schemaObjectPrefix + "BUNDLE (BUNDLE_DATA, NODE_ID) values (?, ?)";
            this.bundleUpdateSQL = "update " + this.schemaObjectPrefix + "BUNDLE set BUNDLE_DATA = ? where NODE_ID = ?";
            this.bundleSelectSQL = "select BUNDLE_DATA from " + this.schemaObjectPrefix + "BUNDLE where NODE_ID = ?";
            this.bundleDeleteSQL = "delete from " + this.schemaObjectPrefix + "BUNDLE where NODE_ID = ?";
            this.nodeReferenceInsertSQL = "insert into " + this.schemaObjectPrefix + "REFS (REFS_DATA, NODE_ID) values (?, ?)";
            this.nodeReferenceUpdateSQL = "update " + this.schemaObjectPrefix + "REFS set REFS_DATA = ? where NODE_ID = ?";
            this.nodeReferenceSelectSQL = "select REFS_DATA from " + this.schemaObjectPrefix + "REFS where NODE_ID = ?";
            this.nodeReferenceDeleteSQL = "delete from " + this.schemaObjectPrefix + "REFS where NODE_ID = ?";
            this.bundleSelectAllIdsSQL = "select NODE_ID from " + this.schemaObjectPrefix + "BUNDLE";
            this.bundleSelectAllIdsFromSQL = "select NODE_ID from " + this.schemaObjectPrefix + "BUNDLE WHERE NODE_ID > ? ORDER BY NODE_ID";
        } else {
            this.bundleInsertSQL = "insert into " + this.schemaObjectPrefix + "BUNDLE (BUNDLE_DATA, NODE_ID_HI, NODE_ID_LO) values (?, ?, ?)";
            this.bundleUpdateSQL = "update " + this.schemaObjectPrefix + "BUNDLE set BUNDLE_DATA = ? where NODE_ID_HI = ? and NODE_ID_LO = ?";
            this.bundleSelectSQL = "select BUNDLE_DATA from " + this.schemaObjectPrefix + "BUNDLE where NODE_ID_HI = ? and NODE_ID_LO = ?";
            this.bundleDeleteSQL = "delete from " + this.schemaObjectPrefix + "BUNDLE where NODE_ID_HI = ? and NODE_ID_LO = ?";
            this.nodeReferenceInsertSQL = "insert into " + this.schemaObjectPrefix + "REFS" + " (REFS_DATA, NODE_ID_HI, NODE_ID_LO) values (?, ?, ?)";
            this.nodeReferenceUpdateSQL = "update " + this.schemaObjectPrefix + "REFS" + " set REFS_DATA = ? where NODE_ID_HI = ? and NODE_ID_LO = ?";
            this.nodeReferenceSelectSQL = "select REFS_DATA from " + this.schemaObjectPrefix + "REFS where NODE_ID_HI = ? and NODE_ID_LO = ?";
            this.nodeReferenceDeleteSQL = "delete from " + this.schemaObjectPrefix + "REFS where NODE_ID_HI = ? and NODE_ID_LO = ?";
            this.bundleSelectAllIdsSQL = "select NODE_ID_HI, NODE_ID_LO from " + this.schemaObjectPrefix + "BUNDLE";
            this.bundleSelectAllIdsFromSQL = "select NODE_ID_HI, NODE_ID_LO from " + this.schemaObjectPrefix + "BUNDLE" + " WHERE (NODE_ID_HI >= ?) AND (? IS NOT NULL)" + " ORDER BY NODE_ID_HI, NODE_ID_LO";
        }
    }

    private class ListNodeIdIterator
    implements NodeIdIterator {
        private final ArrayList list;
        private int pos;

        ListNodeIdIterator(ArrayList list) {
            this.list = list;
        }

        public NodeId nextNodeId() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return new NodeId((UUID)this.list.get(this.pos++));
        }

        public boolean hasNext() {
            return this.pos < this.list.size();
        }

        public Object next() {
            return this.nextNodeId();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class DbBlobStore
    implements CloseableBLOBStore {
        protected String blobInsertSQL;
        protected String blobUpdateSQL;
        protected String blobSelectSQL;
        protected String blobSelectExistSQL;
        protected String blobDeleteSQL;

        public DbBlobStore() throws SQLException {
            this.blobInsertSQL = "insert into " + BundleDbPersistenceManager.this.schemaObjectPrefix + "BINVAL (BINVAL_DATA, BINVAL_ID) values (?, ?)";
            this.blobUpdateSQL = "update " + BundleDbPersistenceManager.this.schemaObjectPrefix + "BINVAL set BINVAL_DATA = ? where BINVAL_ID = ?";
            this.blobSelectSQL = "select BINVAL_DATA from " + BundleDbPersistenceManager.this.schemaObjectPrefix + "BINVAL where BINVAL_ID = ?";
            this.blobSelectExistSQL = "select 1 from " + BundleDbPersistenceManager.this.schemaObjectPrefix + "BINVAL where BINVAL_ID = ?";
            this.blobDeleteSQL = "delete from " + BundleDbPersistenceManager.this.schemaObjectPrefix + "BINVAL where BINVAL_ID = ?";
        }

        public String createId(PropertyId id, int index) {
            StringBuffer buf = new StringBuffer();
            buf.append(id.getParentId().toString());
            buf.append('.');
            buf.append(BundleDbPersistenceManager.this.getNsIndex().stringToIndex(id.getName().getNamespaceURI()));
            buf.append('.');
            buf.append(BundleDbPersistenceManager.this.getNameIndex().stringToIndex(id.getName().getLocalName()));
            buf.append('.');
            buf.append(index);
            return buf.toString();
        }

        public InputStream get(String blobId) throws Exception {
            PreparedStatement stmt = BundleDbPersistenceManager.this.connectionManager.executeStmt(this.blobSelectSQL, new Object[]{blobId});
            final ResultSet rs = stmt.getResultSet();
            if (!rs.next()) {
                BundleDbPersistenceManager.this.closeResultSet(rs);
                throw new Exception("no such BLOB: " + blobId);
            }
            InputStream in = rs.getBinaryStream(1);
            if (in == null) {
                BundleDbPersistenceManager.this.closeResultSet(rs);
                return new ByteArrayInputStream(new byte[0]);
            }
            return new FilterInputStream(in){

                public void close() throws IOException {
                    this.in.close();
                    BundleDbPersistenceManager.this.closeResultSet(rs);
                }
            };
        }

        public synchronized void put(String blobId, InputStream in, long size) throws Exception {
            PreparedStatement stmt = BundleDbPersistenceManager.this.connectionManager.executeStmt(this.blobSelectExistSQL, new Object[]{blobId});
            ResultSet rs = stmt.getResultSet();
            boolean exists = rs.next();
            BundleDbPersistenceManager.this.closeResultSet(rs);
            String sql = exists ? this.blobUpdateSQL : this.blobInsertSQL;
            Object[] params = new Object[]{new ConnectionRecoveryManager.StreamWrapper(in, size), blobId};
            BundleDbPersistenceManager.this.connectionManager.executeStmt(sql, params);
        }

        public synchronized boolean remove(String blobId) throws Exception {
            PreparedStatement stmt = BundleDbPersistenceManager.this.connectionManager.executeStmt(this.blobDeleteSQL, new Object[]{blobId});
            return stmt.getUpdateCount() == 1;
        }

        public void close() {
        }
    }

    protected class FSBlobStore
    extends FileSystemBLOBStore
    implements CloseableBLOBStore {
        private FileSystem fs;

        public FSBlobStore(FileSystem fs) {
            super(fs);
            this.fs = fs;
        }

        public String createId(PropertyId id, int index) {
            return BundleDbPersistenceManager.this.buildBlobFilePath(null, id, index).toString();
        }

        public void close() {
            try {
                this.fs.close();
                this.fs = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static interface CloseableBLOBStore
    extends BLOBStore {
        public void close();
    }
}

