/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.api.jsr283.security.Privilege;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AccessControlUtils;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.principal.AdminPrincipal;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAccessControlProvider
implements AccessControlProvider,
AccessControlUtils {
    private static Logger log = LoggerFactory.getLogger(AbstractAccessControlProvider.class);
    public static final String PARAM_OMIT_DEFAULT_PERMISSIONS = "omit-default-permission";
    protected SessionImpl session;
    protected ObservationManager observationMgr;
    protected NamePathResolver resolver;
    protected int privAll;
    protected int privRead;
    private boolean initialized;

    protected AbstractAccessControlProvider() {
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized or already closed.");
        }
    }

    protected CompiledPermissions getAdminPermissions() {
        return new CompiledPermissions(){

            public void close() {
            }

            public boolean grants(Path absPath, int permissions) {
                return true;
            }

            public int getPrivileges(Path absPath) {
                return AbstractAccessControlProvider.this.privAll;
            }

            public boolean canReadAll() {
                return true;
            }
        };
    }

    protected CompiledPermissions getReadOnlyPermissions() {
        return new CompiledPermissions(){

            public void close() {
            }

            public boolean grants(Path absPath, int permissions) throws RepositoryException {
                if (AbstractAccessControlProvider.this.isAcItem(absPath)) {
                    return false;
                }
                return permissions == 1;
            }

            public int getPrivileges(Path absPath) throws RepositoryException {
                if (AbstractAccessControlProvider.this.isAcItem(absPath)) {
                    return 0;
                }
                return AbstractAccessControlProvider.this.privRead;
            }

            public boolean canReadAll() {
                return false;
            }
        };
    }

    public boolean isAdminOrSystem(Set principals) {
        Iterator it = principals.iterator();
        while (it.hasNext()) {
            Principal p = (Principal)it.next();
            if (!(p instanceof AdminPrincipal) && !(p instanceof SystemPrincipal)) continue;
            return true;
        }
        return false;
    }

    public boolean isReadOnly(Set principals) {
        return false;
    }

    public void init(Session systemSession, Map configuration) throws RepositoryException {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        if (!(systemSession instanceof SessionImpl)) {
            throw new RepositoryException("SessionImpl (system session) expected.");
        }
        this.session = (SessionImpl)systemSession;
        this.observationMgr = systemSession.getWorkspace().getObservationManager();
        this.resolver = (SessionImpl)systemSession;
        this.privAll = PrivilegeRegistry.getBits(new Privilege[]{this.session.getAccessControlManager().privilegeFromName("{http://www.jcp.org/jcr/1.0}all")});
        this.privRead = PrivilegeRegistry.getBits(new Privilege[]{this.session.getAccessControlManager().privilegeFromName("{http://www.jcp.org/jcr/1.0}read")});
        this.initialized = true;
    }

    public void close() {
        this.checkInitialized();
        this.initialized = false;
    }
}

