/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.BatchedItemOperations;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.WorkspaceImpl;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.util.ReferenceChangeTracker;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.VersionHistoryInfo;
import org.apache.jackrabbit.core.version.VersionManager;
import org.apache.jackrabbit.core.xml.Importer;
import org.apache.jackrabbit.core.xml.NodeInfo;
import org.apache.jackrabbit.core.xml.PropInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceImporter
implements Importer {
    private static Logger log = LoggerFactory.getLogger(WorkspaceImporter.class);
    private final NodeState importTarget;
    private final WorkspaceImpl wsp;
    private final SessionImpl session;
    private final VersionManager versionManager;
    private final NodeTypeRegistry ntReg;
    private final HierarchyManager hierMgr;
    private final BatchedItemOperations itemOps;
    private final int uuidBehavior;
    private boolean aborted;
    private Stack parents;
    private final ReferenceChangeTracker refTracker;

    public WorkspaceImporter(Path parentPath, WorkspaceImpl wsp, NodeTypeRegistry ntReg, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        this.wsp = wsp;
        this.session = (SessionImpl)wsp.getSession();
        this.versionManager = this.session.getVersionManager();
        this.ntReg = ntReg;
        this.uuidBehavior = uuidBehavior;
        this.itemOps = new BatchedItemOperations(wsp.getItemStateManager(), ntReg, this.session.getLockManager(), this.session, wsp.getHierarchyManager());
        this.hierMgr = wsp.getHierarchyManager();
        this.itemOps.verifyCanWrite(parentPath);
        this.importTarget = this.itemOps.getNodeState(parentPath);
        this.aborted = false;
        this.refTracker = new ReferenceChangeTracker();
        this.parents = new Stack();
        this.parents.push(this.importTarget);
    }

    protected NodeState resolveUUIDConflict(NodeState parent, NodeState conflicting, NodeInfo nodeInfo) throws RepositoryException {
        NodeState node;
        if (this.uuidBehavior == 0) {
            this.itemOps.checkAddNode(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), 17);
            node = this.itemOps.createNodeState(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), nodeInfo.getMixinNames(), null);
            EffectiveNodeType ent = this.itemOps.getEffectiveNodeType(node);
            if (ent.includesNodeType(NameConstants.MIX_REFERENCEABLE)) {
                this.refTracker.mappedUUID(nodeInfo.getId().getUUID(), node.getNodeId().getUUID());
            }
        } else {
            if (this.uuidBehavior == 3) {
                if (conflicting.isShareable()) {
                    this.itemOps.clone(conflicting, parent, nodeInfo.getName());
                    return null;
                }
                String msg = "a node with uuid " + nodeInfo.getId() + " already exists!";
                log.debug(msg);
                throw new ItemExistsException(msg);
            }
            if (this.uuidBehavior == 1) {
                Path p0 = this.hierMgr.getPath(this.importTarget.getNodeId());
                Path p1 = this.hierMgr.getPath(conflicting.getNodeId());
                try {
                    if (p1.equals(p0) || p1.isAncestorOf(p0)) {
                        String msg = "cannot remove ancestor node";
                        log.debug(msg);
                        throw new ConstraintViolationException(msg);
                    }
                }
                catch (MalformedPathException mpe) {
                    String msg = "internal error: failed to determine degree of relationship";
                    log.error(msg, mpe);
                    throw new RepositoryException(msg, mpe);
                }
                this.itemOps.checkRemoveNode(conflicting, 407);
                this.itemOps.removeNodeState(conflicting);
                this.itemOps.checkAddNode(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), 17);
                node = this.itemOps.createNodeState(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), nodeInfo.getMixinNames(), nodeInfo.getId());
            } else if (this.uuidBehavior == 2) {
                NodeId parentId = conflicting.getParentId();
                if (parentId == null) {
                    String msg = "root node cannot be replaced";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
                try {
                    parent = this.itemOps.getNodeState(parentId);
                }
                catch (ItemNotFoundException infe) {
                    String msg = "internal error: failed to retrieve parent state";
                    log.error(msg, infe);
                    throw new RepositoryException(msg, infe);
                }
                this.itemOps.checkRemoveNode(conflicting, 407);
                ChildNodeEntry cneConflicting = parent.getChildNodeEntry(nodeInfo.getId());
                ArrayList cneList = new ArrayList(parent.getChildNodeEntries());
                this.itemOps.removeNodeState(conflicting);
                this.itemOps.checkAddNode(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), 407);
                node = this.itemOps.createNodeState(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), nodeInfo.getMixinNames(), nodeInfo.getId());
                if (cneConflicting.getName().equals(nodeInfo.getName())) {
                    parent.setChildNodeEntries(cneList);
                } else {
                    parent.removeAllChildNodeEntries();
                    Iterator iter = cneList.iterator();
                    while (iter.hasNext()) {
                        ChildNodeEntry cne = (ChildNodeEntry)iter.next();
                        if (cne.getId().equals(nodeInfo.getId())) {
                            parent.addChildNodeEntry(nodeInfo.getName(), nodeInfo.getId());
                            continue;
                        }
                        parent.addChildNodeEntry(cne.getName(), cne.getId());
                    }
                }
            } else {
                String msg = "unknown uuidBehavior: " + this.uuidBehavior;
                log.debug(msg);
                throw new RepositoryException(msg);
            }
        }
        return node;
    }

    protected void postProcessNode(NodeState node) throws RepositoryException {
        EffectiveNodeType ent = this.itemOps.getEffectiveNodeType(node);
        if (ent.includesNodeType(NameConstants.MIX_SIMPLE_VERSIONABLE)) {
            VersionHistoryInfo history = this.versionManager.getVersionHistory(this.session, node);
            InternalValue historyId = InternalValue.create(history.getVersionHistoryId().getUUID());
            InternalValue versionId = InternalValue.create(history.getRootVersionId().getUUID());
            this.conditionalAddProperty(node, NameConstants.JCR_ISCHECKEDOUT, 6, false, InternalValue.create(true));
            if (ent.includesNodeType(NameConstants.MIX_VERSIONABLE)) {
                this.conditionalAddProperty(node, NameConstants.JCR_VERSIONHISTORY, 9, false, historyId);
                this.conditionalAddProperty(node, NameConstants.JCR_BASEVERSION, 9, false, versionId);
                this.conditionalAddProperty(node, NameConstants.JCR_PREDECESSORS, 9, true, versionId);
            }
        }
    }

    private void conditionalAddProperty(NodeState node, Name name, int type, boolean multiple, InternalValue value) throws RepositoryException {
        if (!node.hasPropertyName(name)) {
            PropDef def = this.itemOps.findApplicablePropertyDefinition(name, type, multiple, node);
            PropertyState prop = this.itemOps.createPropertyState(node, name, type, def);
            prop.setValues(new InternalValue[]{value});
        }
    }

    public void start() throws RepositoryException {
        try {
            this.itemOps.edit();
        }
        catch (IllegalStateException ise) {
            this.aborted = true;
            String msg = "internal error: failed to start update operation";
            log.debug(msg);
            throw new RepositoryException(msg, ise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startNode(NodeInfo nodeInfo, List propInfos) throws RepositoryException {
        if (this.aborted) {
            return;
        }
        succeeded = false;
        this.wsp.sanityCheck();
        parent = (NodeState)this.parents.peek();
        node = null;
        id = nodeInfo.getId();
        nodeName = nodeInfo.getName();
        ntName = nodeInfo.getNodeTypeName();
        mixins = nodeInfo.getMixinNames();
        if (parent == null) {
            this.parents.push(null);
            succeeded = true;
            WorkspaceImporter.log.debug("skipping node " + nodeName);
            if (succeeded != false) return;
            this.aborted = true;
        }
        ** GOTO lbl-1000
        {
            block19: {
                block20: {
                    catch (Throwable var15_16) {
                        throw var15_16;
                    }
                    this.itemOps.cancel();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        if (!parent.hasChildNodeEntry(nodeName) || (def = this.ntReg.getNodeDef((existing = (NodeState)this.itemOps.getItemState(idExisting = (entry = parent.getChildNodeEntry(nodeName, 1)).getId())).getDefinitionId())).allowsSameNameSiblings()) ** GOTO lbl42
                        entExisting = this.itemOps.getEffectiveNodeType(existing);
                        if (!def.isProtected() || !entExisting.includesNodeType(ntName)) ** GOTO lbl-1000
                        this.parents.push(null);
                        succeeded = true;
                        WorkspaceImporter.log.debug("skipping protected node " + this.itemOps.safeGetJCRPath(existing.getNodeId()));
                        if (succeeded != false) return;
                        this.aborted = true;
                    }
                    this.itemOps.cancel();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        if (def.isAutoCreated() && entExisting.includesNodeType(ntName)) {
                            node = existing;
                        } else {
                            if (idExisting.equals(id) == false) throw new ItemExistsException(this.itemOps.safeGetJCRPath(existing.getNodeId()));
                            if (this.uuidBehavior != 1 && this.uuidBehavior != 2) {
                                throw new ItemExistsException(this.itemOps.safeGetJCRPath(existing.getNodeId()));
                            }
                        }
lbl42:
                        // 4 sources

                        if (node != null) ** GOTO lbl86
                        if (id != null) break block19;
                        def = this.itemOps.findApplicableNodeDefinition(nodeName, ntName, parent);
                        if (!def.isProtected()) break block20;
                        this.parents.push(null);
                        succeeded = true;
                        WorkspaceImporter.log.debug("skipping protected node " + nodeName);
                        if (succeeded != false) return;
                        this.aborted = true;
                    }
                    this.itemOps.cancel();
                    return;
                }
                this.itemOps.checkAddNode(parent, nodeName, ntName, 17);
                node = this.itemOps.createNodeState(parent, nodeName, ntName, mixins, null, def);
                ** GOTO lbl86
            }
            conflicting = this.itemOps.getNodeState(id);
            node = this.resolveUUIDConflict(parent, conflicting, nodeInfo);
            if (node == null) {
                this.parents.push(null);
                succeeded = true;
                WorkspaceImporter.log.debug("skipping existing node: " + nodeName);
                if (succeeded != false) return;
                this.aborted = true;
                this.itemOps.cancel();
                return;
            }
            ** GOTO lbl86
            {
                catch (ItemNotFoundException e) {}
                def = this.itemOps.findApplicableNodeDefinition(nodeName, ntName, parent);
                if (def.isProtected()) {
                    this.parents.push(null);
                    succeeded = true;
                    WorkspaceImporter.log.debug("skipping protected node " + nodeName);
                    if (succeeded != false) return;
                    this.aborted = true;
                    this.itemOps.cancel();
                    return;
                }
                ** try [egrp 6[TRYBLOCK] [6 : 650->768)] { 
lbl84:
                // 1 sources

                this.itemOps.checkAddNode(parent, nodeName, ntName, 17);
                node = this.itemOps.createNodeState(parent, nodeName, ntName, mixins, id, def);
lbl86:
                // 4 sources

                iter = propInfos.iterator();
                while (iter.hasNext()) {
                    pi = (PropInfo)iter.next();
                    pi.apply(node, this.itemOps, this.ntReg, this.refTracker);
                }
                this.itemOps.store(node);
                this.itemOps.store(parent);
                this.parents.push(node);
                return;
lbl96:
                // 1 sources

                finally {
                    if (!succeeded) {
                        this.aborted = true;
                        this.itemOps.cancel();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endNode(NodeInfo nodeInfo) throws RepositoryException {
        if (this.aborted) {
            return;
        }
        NodeState node = (NodeState)this.parents.pop();
        if (node == null) {
            return;
        }
        boolean succeeded = false;
        try {
            this.wsp.sanityCheck();
            this.postProcessNode(node);
            this.itemOps.validate(node);
            this.itemOps.store(node);
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                this.aborted = true;
                this.itemOps.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() throws RepositoryException {
        if (this.aborted) {
            return;
        }
        boolean succeeded = false;
        try {
            this.wsp.sanityCheck();
            Iterator iter = this.refTracker.getProcessedReferences();
            while (iter.hasNext()) {
                PropertyState prop = (PropertyState)iter.next();
                if (prop.getType() != 9) continue;
                boolean modified = false;
                InternalValue[] values = prop.getValues();
                InternalValue[] newVals = new InternalValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    InternalValue val = values[i];
                    UUID original = val.getUUID();
                    UUID adjusted = this.refTracker.getMappedUUID(original);
                    if (adjusted != null) {
                        newVals[i] = InternalValue.create(adjusted);
                        modified = true;
                        continue;
                    }
                    newVals[i] = val;
                }
                if (!modified) continue;
                prop.setValues(newVals);
                this.itemOps.store(prop);
            }
            this.refTracker.clear();
            this.itemOps.validate(this.importTarget);
            this.itemOps.store(this.importTarget);
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                this.aborted = true;
                this.itemOps.cancel();
            }
        }
        if (!this.aborted) {
            this.itemOps.update();
        }
    }
}

