/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.lucene.JackrabbitQuery;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryHits;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.QueryHits;
import org.apache.jackrabbit.core.query.lucene.QueryHitsAdapter;
import org.apache.jackrabbit.core.query.lucene.SortedLuceneQueryHits;
import org.apache.jackrabbit.core.query.lucene.constraint.EvaluationContext;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

public class JackrabbitIndexSearcher
extends IndexSearcher
implements EvaluationContext {
    private final SessionImpl session;
    private final IndexReader reader;
    private final ItemStateManager ism;

    public JackrabbitIndexSearcher(SessionImpl s, IndexReader r, ItemStateManager ism) {
        super(r);
        this.session = s;
        this.reader = r;
        this.ism = ism;
    }

    public MultiColumnQueryHits execute(Query query, Sort sort, long resultFetchHint, Name selectorName) throws IOException {
        return new QueryHitsAdapter(this.evaluate(query, sort, resultFetchHint), selectorName);
    }

    public QueryHits evaluate(Query query, Sort sort, long resultFetchHint) throws IOException {
        query = query.rewrite(this.reader);
        QueryHits hits = null;
        if (query instanceof JackrabbitQuery) {
            hits = ((JackrabbitQuery)((Object)query)).execute(this, this.session, sort);
        }
        if (hits == null) {
            hits = sort == null ? new LuceneQueryHits(this.reader, this, query) : new SortedLuceneQueryHits(this.reader, this, query, sort, resultFetchHint);
        }
        return hits;
    }

    public QueryHits evaluate(Query query) throws IOException {
        return this.evaluate(query, new Sort(), Integer.MAX_VALUE);
    }

    public SessionImpl getSession() {
        return this.session;
    }

    public ItemStateManager getItemStateManager() {
        return this.ism;
    }
}

