/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.JackrabbitIndexSearcher;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQuery;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.join.Join;
import org.apache.jackrabbit.spi.commons.query.qom.JoinConditionImpl;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortComparatorSource;

public class JoinQuery
implements MultiColumnQuery {
    private final MultiColumnQuery left;
    private final MultiColumnQuery right;
    private final int joinType;
    private final JoinConditionImpl joinCondition;
    private final SortComparatorSource scs;
    private final HierarchyManager hmgr;

    public JoinQuery(MultiColumnQuery left, MultiColumnQuery right, int joinType, JoinConditionImpl joinCondition, SortComparatorSource scs, HierarchyManager hmgr) {
        this.left = left;
        this.right = right;
        this.joinType = joinType;
        this.joinCondition = joinCondition;
        this.scs = scs;
        this.hmgr = hmgr;
    }

    public MultiColumnQueryHits execute(JackrabbitIndexSearcher searcher, Sort sort, long resultFetchHint) throws IOException {
        IndexReader reader = searcher.getIndexReader();
        HierarchyResolver resolver = (HierarchyResolver)((Object)reader);
        return Join.create(this.left.execute(searcher, sort, resultFetchHint), this.right.execute(searcher, sort, resultFetchHint), this.joinType, this.joinCondition, reader, resolver, this.scs, this.hmgr);
    }
}

