/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.join.AbstractCondition;
import org.apache.jackrabbit.core.query.lucene.join.ScoreNodeMap;
import org.apache.jackrabbit.spi.commons.query.qom.ChildNodeJoinConditionImpl;
import org.apache.lucene.index.IndexReader;

public class ChildNodeJoin
extends AbstractCondition {
    private final ScoreNodeMap parentIndex = new ScoreNodeMap();
    private final IndexReader reader;
    private final HierarchyResolver resolver;
    private int[] docNums = new int[1];
    private List tmpScoreNodes = new ArrayList();

    public ChildNodeJoin(MultiColumnQueryHits parent, IndexReader reader, HierarchyResolver resolver, ChildNodeJoinConditionImpl condition) throws IOException {
        super(parent);
        ScoreNode[] nodes;
        this.reader = reader;
        this.resolver = resolver;
        int idx = ChildNodeJoin.getIndex(parent, condition.getParentSelectorQName());
        while ((nodes = parent.nextScoreNodes()) != null) {
            Integer docNum = new Integer(nodes[idx].getDoc(reader));
            this.parentIndex.addScoreNodes(docNum, nodes);
        }
    }

    public ScoreNode[][] getMatchingScoreNodes(ScoreNode child) throws IOException {
        this.docNums = this.resolver.getParents(child.getDoc(this.reader), this.docNums);
        this.tmpScoreNodes.clear();
        for (int i = 0; i < this.docNums.length; ++i) {
            ScoreNode[][] sn = this.parentIndex.getScoreNodes(new Integer(this.docNums[i]));
            if (sn == null) continue;
            for (int j = 0; j < sn.length; ++j) {
                this.tmpScoreNodes.add(sn[j]);
            }
        }
        if (this.tmpScoreNodes.isEmpty()) {
            return null;
        }
        return (ScoreNode[][])this.tmpScoreNodes.toArray((T[])new ScoreNode[this.tmpScoreNodes.size()][]);
    }
}

