/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.IOException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpState;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.header.CodedUrlHeader;
import org.apache.jackrabbit.webdav.header.DepthHeader;
import org.apache.jackrabbit.webdav.header.IfHeader;
import org.apache.jackrabbit.webdav.header.TimeoutHeader;
import org.apache.jackrabbit.webdav.lock.LockDiscovery;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class LockMethod
extends DavMethodBase {
    private static Logger log = LoggerFactory.getLogger(LockMethod.class);
    private final boolean isRefresh;
    private LockDiscovery lockDiscovery;

    public LockMethod(String uri, Scope lockScope, Type lockType, String owner, long timeout, boolean isDeep) throws IOException {
        this(uri, new LockInfo(lockScope, lockType, owner, timeout, isDeep));
    }

    public LockMethod(String uri, LockInfo lockInfo) throws IOException {
        super(uri);
        if (lockInfo == null || lockInfo.isRefreshLock()) {
            throw new IllegalArgumentException("Cannot create a LOCK request without lock info. Use the constructor taking lock tokens in order to build a LOCK request for refresh.");
        }
        TimeoutHeader th = new TimeoutHeader(lockInfo.getTimeout());
        this.setRequestHeader(th);
        DepthHeader dh = new DepthHeader(lockInfo.isDeep());
        this.setRequestHeader(dh);
        this.setRequestBody(lockInfo);
        this.isRefresh = false;
    }

    public LockMethod(String uri, long timeout, String[] lockTokens) {
        super(uri);
        TimeoutHeader th = new TimeoutHeader(timeout);
        this.setRequestHeader(th);
        IfHeader ifh = new IfHeader(lockTokens);
        this.setRequestHeader(ifh);
        this.isRefresh = true;
    }

    public LockDiscovery getResponseAsLockDiscovery() throws IOException, DavException {
        this.checkUsed();
        if (this.lockDiscovery != null) {
            return this.lockDiscovery;
        }
        DavException dx = this.getResponseException();
        if (dx != null) {
            throw dx;
        }
        throw new DavException(this.getStatusCode(), this.getName() + " resulted with unexpected status: " + this.getStatusLine());
    }

    public String getLockToken() {
        this.checkUsed();
        Header ltHeader = this.getResponseHeader("Lock-Token");
        if (ltHeader != null) {
            CodedUrlHeader cuh = new CodedUrlHeader("Lock-Token", ltHeader.getValue());
            return cuh.getCodedUrl();
        }
        return null;
    }

    public String getName() {
        return "LOCK";
    }

    public boolean succeeded() {
        this.checkUsed();
        String lt = this.getLockToken();
        boolean containsRequiredHeader = this.isRefresh ? lt == null : lt != null;
        return this.getSuccess() && containsRequiredHeader;
    }

    protected boolean isSuccess(int statusCode) {
        return statusCode == 200;
    }

    protected void processResponseBody(HttpState httpState, HttpConnection httpConnection) {
        if (this.getSuccess()) {
            try {
                this.setSuccess(this.buildDiscoveryFromRoot(this.getRootElement()));
            }
            catch (IOException e) {
                log.error("Error while parsing multistatus response: " + e);
                this.setSuccess(false);
            }
        }
    }

    private boolean buildDiscoveryFromRoot(Element root) {
        if (DomUtil.matches(root, "prop", NAMESPACE) && DomUtil.hasChildElement(root, "lockdiscovery", NAMESPACE)) {
            Element lde = DomUtil.getChildElement(root, "lockdiscovery", NAMESPACE);
            if (DomUtil.hasChildElement(lde, "activelock", NAMESPACE)) {
                this.lockDiscovery = LockDiscovery.createFromXml(lde);
                return true;
            }
            log.debug("The DAV:lockdiscovery must contain a least a single DAV:activelock in response to a successful LOCK request.");
        } else {
            log.debug("Missing DAV:prop response body in LOCK method.");
        }
        return false;
    }
}

