/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.api.jsr283.RepositoryFactory;
import org.apache.jackrabbit.core.TransientRepository;

public class RepositoryFactoryImpl
implements RepositoryFactory {
    public static final String REPOSITORY_HOME = "org.apache.jackrabbit.repository.home";
    public static final String REPOSITORY_CONF = "org.apache.jackrabbit.repository.conf";
    private static final Map REPOSITORY_INSTANCES = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repository getRepository(Map parameters) throws RepositoryException {
        JackrabbitRepository repo;
        Map map = REPOSITORY_INSTANCES;
        synchronized (map) {
            if (parameters == null) {
                repo = this.getOrCreateRepository(null, null);
            } else if (parameters.containsKey(REPOSITORY_CONF) && parameters.containsKey(REPOSITORY_HOME)) {
                String conf = (String)parameters.get(REPOSITORY_CONF);
                String home = (String)parameters.get(REPOSITORY_HOME);
                repo = this.getOrCreateRepository(conf, home);
            } else {
                repo = null;
            }
        }
        return repo;
    }

    private JackrabbitRepository getOrCreateRepository(String conf, String home) throws RepositoryException {
        JackrabbitRepository repo = (JackrabbitRepository)REPOSITORY_INSTANCES.get(home);
        try {
            if (repo == null) {
                repo = home == null ? new TransientRepository() : new TransientRepository(conf, home);
                REPOSITORY_INSTANCES.put(home, repo);
            }
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        return repo;
    }
}

