/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import javax.jcr.ReferentialIntegrityException;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCache;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.ItemStateReferenceCache;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.NodeStateListener;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.state.StaleItemStateException;
import org.apache.jackrabbit.core.state.StateChangeDispatcher;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.spi.Name;

public class LocalItemStateManager
implements UpdatableItemStateManager,
NodeStateListener {
    private final ItemStateCache cache;
    protected final SharedItemStateManager sharedStateMgr;
    protected final EventStateCollectionFactory factory;
    private boolean editMode;
    private final ChangeLog changeLog = new ChangeLog();
    private final transient StateChangeDispatcher dispatcher = new StateChangeDispatcher();

    protected LocalItemStateManager(SharedItemStateManager sharedStateMgr, EventStateCollectionFactory factory, ItemStateCacheFactory cacheFactory) {
        this.cache = new ItemStateReferenceCache(cacheFactory);
        this.sharedStateMgr = sharedStateMgr;
        this.factory = factory;
    }

    public static LocalItemStateManager createInstance(SharedItemStateManager sharedStateMgr, EventStateCollectionFactory factory, ItemStateCacheFactory cacheFactory) {
        LocalItemStateManager mgr = new LocalItemStateManager(sharedStateMgr, factory, cacheFactory);
        sharedStateMgr.addListener(mgr);
        return mgr;
    }

    protected NodeState getNodeState(NodeId id) throws NoSuchItemStateException, ItemStateException {
        NodeState state = (NodeState)this.sharedStateMgr.getItemState(id);
        state = new NodeState(state, state.getStatus(), false);
        this.cache.cache(state);
        state.setContainer(this);
        return state;
    }

    protected PropertyState getPropertyState(PropertyId id) throws NoSuchItemStateException, ItemStateException {
        PropertyState state = (PropertyState)this.sharedStateMgr.getItemState(id);
        state = new PropertyState(state, state.getStatus(), false);
        this.cache.cache(state);
        state.setContainer(this);
        return state;
    }

    protected ChangeLog getChanges() {
        return this.changeLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ItemState state = this.changeLog.get(id);
        if (state != null) {
            return state;
        }
        LocalItemStateManager localItemStateManager = this;
        synchronized (localItemStateManager) {
            state = this.cache.retrieve(id);
            if (state == null) {
                state = id.denotesNode() ? this.getNodeState((NodeId)id) : this.getPropertyState((PropertyId)id);
            }
            return state;
        }
    }

    public boolean hasItemState(ItemId id) {
        try {
            ItemState state = this.changeLog.get(id);
            if (state != null) {
                return true;
            }
        }
        catch (NoSuchItemStateException e) {
            return false;
        }
        if (this.cache.isCached(id)) {
            return true;
        }
        return this.sharedStateMgr.hasItemState(id);
    }

    public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
        NodeReferences refs = this.changeLog.get(id);
        if (refs != null) {
            return refs;
        }
        return this.sharedStateMgr.getNodeReferences(id);
    }

    public boolean hasNodeReferences(NodeReferencesId id) {
        if (this.changeLog.get(id) != null) {
            return true;
        }
        return this.sharedStateMgr.hasNodeReferences(id);
    }

    public synchronized void edit() throws IllegalStateException {
        if (this.editMode) {
            throw new IllegalStateException("Already in edit mode");
        }
        this.changeLog.reset();
        this.editMode = true;
    }

    public boolean inEditMode() {
        return this.editMode;
    }

    public NodeState createNew(NodeId id, Name nodeTypeName, NodeId parentId) throws IllegalStateException {
        if (!this.editMode) {
            throw new IllegalStateException("Not in edit mode");
        }
        NodeState state = new NodeState(id, nodeTypeName, parentId, 4, false);
        this.changeLog.added(state);
        state.setContainer(this);
        return state;
    }

    public PropertyState createNew(Name propName, NodeId parentId) throws IllegalStateException {
        if (!this.editMode) {
            throw new IllegalStateException("Not in edit mode");
        }
        PropertyState state = new PropertyState(new PropertyId(parentId, propName), 4, false);
        this.changeLog.added(state);
        state.setContainer(this);
        return state;
    }

    public void store(ItemState state) throws IllegalStateException {
        if (!this.editMode) {
            throw new IllegalStateException("Not in edit mode");
        }
        this.changeLog.modified(state);
    }

    public void destroy(ItemState state) throws IllegalStateException {
        if (!this.editMode) {
            throw new IllegalStateException("Not in edit mode");
        }
        this.changeLog.deleted(state);
    }

    public void cancel() throws IllegalStateException {
        if (!this.editMode) {
            throw new IllegalStateException("Not in edit mode");
        }
        this.changeLog.undo(this.sharedStateMgr);
        this.editMode = false;
    }

    public void update() throws ReferentialIntegrityException, StaleItemStateException, ItemStateException, IllegalStateException {
        if (!this.editMode) {
            throw new IllegalStateException("Not in edit mode");
        }
        if (this.changeLog.hasUpdates()) {
            this.update(this.changeLog);
            this.changeLog.reset();
        }
        this.editMode = false;
    }

    protected void update(ChangeLog changeLog) throws ReferentialIntegrityException, StaleItemStateException, ItemStateException {
        this.sharedStateMgr.update(changeLog, this.factory);
        changeLog.persisted();
    }

    public void dispose() {
        this.sharedStateMgr.removeListener(this);
        ItemState[] states = this.cache.retrieveAll();
        for (int i = 0; i < states.length; ++i) {
            ItemState state = states[i];
            if (state == null) continue;
            this.dispatcher.notifyStateDiscarded(state);
            state.onDisposed();
        }
        this.cache.evictAll();
        this.cache.dispose();
    }

    public void addListener(ItemStateListener listener) {
        this.dispatcher.addListener(listener);
    }

    public void removeListener(ItemStateListener listener) {
        this.dispatcher.removeListener(listener);
    }

    public void stateCreated(ItemState created) {
        ItemState local = null;
        if (created.getContainer() != this) {
            try {
                local = this.changeLog.get(created.getId());
                if (local != null) {
                    local.pull();
                    local.setStatus(1);
                    this.cache.cache(local);
                }
            }
            catch (NoSuchItemStateException noSuchItemStateException) {}
        } else {
            local = created;
            if (!this.cache.isCached(created.getId())) {
                this.cache.cache(local);
            }
        }
        this.dispatcher.notifyStateCreated(created);
    }

    public void stateModified(ItemState modified) {
        ItemState local;
        if (modified.getContainer() != this) {
            local = this.cache.retrieve(modified.getId());
            if (local != null && local.isConnected()) {
                local.pull();
            }
        } else {
            local = modified;
        }
        if (local != null) {
            this.dispatcher.notifyStateModified(local);
        } else if (modified.isNode()) {
            this.dispatcher.notifyNodeModified((NodeState)modified);
        }
    }

    public void stateDestroyed(ItemState destroyed) {
        ItemState local = null;
        if (destroyed.getContainer() != this) {
            local = this.cache.retrieve(destroyed.getId());
            if (local != null && local.isConnected()) {
                local.setStatus(3);
            }
        } else {
            local = destroyed;
        }
        this.cache.evict(destroyed.getId());
        if (local != null) {
            this.dispatcher.notifyStateDestroyed(local);
        }
    }

    public void stateDiscarded(ItemState discarded) {
        ItemState local = null;
        if (discarded.getContainer() != this) {
            local = this.cache.retrieve(discarded.getId());
            if (local != null && local.isConnected()) {
                local.setStatus(0);
            }
        } else {
            local = discarded;
        }
        this.cache.evict(discarded.getId());
        if (local != null) {
            this.dispatcher.notifyStateDiscarded(local);
        }
    }

    public void nodeAdded(NodeState state, Name name, int index, NodeId id) {
        this.dispatcher.notifyNodeAdded(state, name, index, id);
    }

    public void nodesReplaced(NodeState state) {
        this.dispatcher.notifyNodesReplaced(state);
    }

    public void nodeModified(NodeState state) {
        this.dispatcher.notifyNodeModified(state);
    }

    public void nodeRemoved(NodeState state, Name name, int index, NodeId id) {
        this.dispatcher.notifyNodeRemoved(state, name, index, id);
    }
}

