/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.api.jsr283.version.Version;
import org.apache.jackrabbit.api.jsr283.version.VersionHistory;
import org.apache.jackrabbit.api.jsr283.version.VersionManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrVersionManagerImpl
implements VersionManager {
    private static final Logger log = LoggerFactory.getLogger(JcrVersionManagerImpl.class);
    private final SessionImpl session;

    public JcrVersionManagerImpl(SessionImpl session) {
        this.session = session;
    }

    public Version checkin(String absPath) throws RepositoryException {
        return (Version)this.session.getNode(absPath).checkin();
    }

    public void checkout(String absPath) throws RepositoryException {
        this.session.getNode(absPath).checkout();
    }

    public Version checkpoint(String absPath) throws RepositoryException {
        Node node = this.session.getNode(absPath);
        Version v = (Version)node.checkin();
        node.checkout();
        return v;
    }

    public boolean isCheckedOut(String absPath) throws RepositoryException {
        return this.session.getNode(absPath).isCheckedOut();
    }

    public VersionHistory getVersionHistory(String absPath) throws RepositoryException {
        return (VersionHistory)this.session.getNode(absPath).getVersionHistory();
    }

    public Version getBaseVersion(String absPath) throws RepositoryException {
        return (Version)this.session.getNode(absPath).getBaseVersion();
    }

    public void restore(Version[] versions, boolean removeExisting) throws RepositoryException {
        this.session.getWorkspace().restore(versions, removeExisting);
    }

    public void restore(String absPath, String versionName, boolean removeExisting) throws RepositoryException {
        this.session.getNode(absPath).restore(versionName, removeExisting);
    }

    public void restore(Version version, boolean removeExisting) throws RepositoryException {
        this.session.getWorkspace().restore(new Version[]{version}, removeExisting);
    }

    public void restore(String absPath, Version version, boolean removeExisting) throws RepositoryException {
        this.session.getNode(absPath).restore(version, removeExisting);
    }

    public void restoreByLabel(String absPath, String versionLabel, boolean removeExisting) throws RepositoryException {
        this.session.getNode(absPath).restoreByLabel(versionLabel, removeExisting);
    }

    public NodeIterator merge(String absPath, String srcWorkspace, boolean bestEffort) throws RepositoryException {
        return ((NodeImpl)this.session.getNode(absPath)).merge(srcWorkspace, bestEffort, false);
    }

    public NodeIterator merge(String absPath, String srcWorkspace, boolean bestEffort, boolean isShallow) throws RepositoryException {
        return ((NodeImpl)this.session.getNode(absPath)).merge(srcWorkspace, bestEffort, isShallow);
    }

    public void doneMerge(String absPath, Version version) throws RepositoryException {
        this.session.getNode(absPath).doneMerge(version);
    }

    public void cancelMerge(String absPath, Version version) throws RepositoryException {
        this.session.getNode(absPath).cancelMerge(version);
    }

    public Node createConfiguration(String absPath, Version baseline) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("comming soon...");
    }

    public Node setActivity(Node activity) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("comming soon...");
    }

    public Node getActivity() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("comming soon...");
    }

    public Node createActivity(String title) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("comming soon...");
    }

    public Node removeActivity(String title) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("comming soon...");
    }

    public NodeIterator merge(Node activityNode) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("comming soon...");
    }
}

