/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import java.util.GregorianCalendar;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.functions.Function;
import org.apache.poi.hssf.record.formula.functions.NumericFunction;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;

public final class DateFunc
extends NumericFunction.MultiArg {
    public static final Function instance = new DateFunc();

    private DateFunc() {
        super(3, 3);
    }

    protected double evaluate(double[] ds) throws EvaluationException {
        int year = DateFunc.getYear(ds[0]);
        int month = (int)ds[1] - 1;
        int day = (int)ds[2];
        if (year < 0 || month < 0 || day < 0) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        if (year == 1900 && month == 1 && day == 29) {
            return 60.0;
        }
        if (year == 1900 && (month == 0 && day >= 60 || month == 1 && day >= 30)) {
            --day;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.set(year, month, day, 0, 0, 0);
        c.set(14, 0);
        return HSSFDateUtil.getExcelDate(c.getTime(), false);
    }

    private static int getYear(double d) {
        int year = (int)d;
        if (year < 0) {
            return -1;
        }
        return year < 1900 ? 1900 + year : year;
    }
}

