/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.api.jsr283.query.Row;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.query.lucene.ExcerptProvider;
import org.apache.jackrabbit.core.query.lucene.HighlightingExcerptProvider;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.ScoreNodeIterator;
import org.apache.jackrabbit.core.query.lucene.SpellSuggestion;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.value.QValueFactoryImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFactoryQImpl;
import org.apache.jackrabbit.util.ISO9075;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RowIteratorImpl
implements RowIterator {
    private static final Logger log = LoggerFactory.getLogger(RowIteratorImpl.class);
    private static final QValueFactory QVALUE_FACTORY = QValueFactoryImpl.getInstance();
    private static final String EXCERPT_FUNC_LPAR = "excerpt(";
    private static final String SPELLCHECK_FUNC_LPAR = "spellcheck(";
    private static final Name REP_EXCERPT_LPAR = NameFactoryImpl.getInstance().create("internal", "excerpt(");
    private final ScoreNodeIterator scoreNodes;
    private final Name[] properties;
    private Set propertySet;
    private final List selectorNames = new ArrayList();
    private final ItemManager itemMgr;
    private final HierarchyManager hmgr;
    private final NamePathResolver resolver;
    private final ExcerptProvider excerptProvider;
    private final SpellSuggestion spellSuggestion;
    private final ValueFactoryQImpl valueFactory;

    RowIteratorImpl(ScoreNodeIterator scoreNodes, Name[] properties, Name[] selectorNames, ItemManager itemMgr, HierarchyManager hmgr, NamePathResolver resolver, ExcerptProvider exProvider, SpellSuggestion spellSuggestion) {
        this.scoreNodes = scoreNodes;
        this.properties = properties;
        this.selectorNames.addAll(Arrays.asList(selectorNames));
        this.itemMgr = itemMgr;
        this.hmgr = hmgr;
        this.resolver = resolver;
        this.excerptProvider = exProvider;
        this.spellSuggestion = spellSuggestion;
        this.valueFactory = new ValueFactoryQImpl(QVALUE_FACTORY, resolver);
    }

    public javax.jcr.query.Row nextRow() throws NoSuchElementException {
        return new RowImpl(this.scoreNodes.nextScoreNodes());
    }

    public void skip(long skipNum) throws NoSuchElementException {
        this.scoreNodes.skip(skipNum);
    }

    public long getSize() {
        return this.scoreNodes.getSize();
    }

    public long getPosition() {
        return this.scoreNodes.getPosition();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public boolean hasNext() {
        return this.scoreNodes.hasNext();
    }

    public Object next() throws NoSuchElementException {
        return this.nextRow();
    }

    class RowImpl
    implements Row {
        private final float score;
        private NodeImpl node;
        private final ScoreNode[] sn;
        private Value[] values;

        RowImpl(ScoreNode[] sn) {
            this.sn = sn;
            this.score = sn[0].getScore();
        }

        public Value[] getValues() throws RepositoryException {
            if (this.values == null) {
                Value[] tmp = new Value[RowIteratorImpl.this.properties.length];
                for (int i = 0; i < RowIteratorImpl.this.properties.length; ++i) {
                    if (this.getNodeImpl().hasProperty(RowIteratorImpl.this.properties[i])) {
                        PropertyImpl prop = this.getNodeImpl().getProperty(RowIteratorImpl.this.properties[i]);
                        if (!prop.getDefinition().isMultiple()) {
                            if (prop.getDefinition().getRequiredType() == 0) {
                                tmp[i] = RowIteratorImpl.this.valueFactory.createValue(prop.getString());
                                continue;
                            }
                            tmp[i] = prop.getValue();
                            continue;
                        }
                        tmp[i] = null;
                        continue;
                    }
                    tmp[i] = NameConstants.JCR_PATH.equals(RowIteratorImpl.this.properties[i]) ? RowIteratorImpl.this.valueFactory.createValue(this.getNodeImpl().getPath(), 8) : (NameConstants.JCR_SCORE.equals(RowIteratorImpl.this.properties[i]) ? RowIteratorImpl.this.valueFactory.createValue(Math.round(this.score * 1000.0f)) : (this.isExcerptFunction(RowIteratorImpl.this.properties[i]) ? this.getExcerpt() : (this.isSpellCheckFunction(RowIteratorImpl.this.properties[i]) ? this.getSpellCheckedStatement() : null)));
                }
                this.values = tmp;
            }
            Value[] ret = new Value[this.values.length];
            System.arraycopy(this.values, 0, ret, 0, this.values.length);
            return ret;
        }

        public Value getValue(String propertyName) throws ItemNotFoundException, RepositoryException {
            if (RowIteratorImpl.this.propertySet == null) {
                HashSet<Name> tmp = new HashSet<Name>();
                tmp.addAll(Arrays.asList(RowIteratorImpl.this.properties));
                RowIteratorImpl.this.propertySet = tmp;
            }
            try {
                Name prop = RowIteratorImpl.this.resolver.getQName(propertyName);
                if (!RowIteratorImpl.this.propertySet.contains(prop)) {
                    if (this.isExcerptFunction(propertyName)) {
                        return this.getExcerpt(propertyName);
                    }
                    throw new ItemNotFoundException(propertyName);
                }
                if (NameConstants.JCR_PATH.equals(prop)) {
                    QValue p = QVALUE_FACTORY.create(RowIteratorImpl.this.hmgr.getPath(this.sn[0].getNodeId()));
                    return RowIteratorImpl.this.valueFactory.createValue(p);
                }
                if (this.getNodeImpl().hasProperty(prop)) {
                    PropertyImpl p = this.getNodeImpl().getProperty(prop);
                    if (p.isMultiple()) {
                        return null;
                    }
                    if (p.getDefinition().getRequiredType() == 0) {
                        return RowIteratorImpl.this.valueFactory.createValue(p.getString());
                    }
                    return p.getValue();
                }
                if (NameConstants.JCR_SCORE.equals(prop)) {
                    return RowIteratorImpl.this.valueFactory.createValue(Math.round(this.score * 1000.0f));
                }
                if (this.isExcerptFunction(prop)) {
                    return this.getExcerpt();
                }
                if (this.isSpellCheckFunction(prop)) {
                    return this.getSpellCheckedStatement();
                }
                return null;
            }
            catch (NameException e) {
                if (this.isExcerptFunction(propertyName)) {
                    return this.getExcerpt(propertyName);
                }
                throw new RepositoryException(e.getMessage(), e);
            }
        }

        public Node getNode() throws RepositoryException {
            this.checkSingleSelector("Use getNode(String) instead.");
            return this.getNodeImpl();
        }

        public Node getNode(String selectorName) throws RepositoryException {
            ScoreNode s = this.sn[this.getSelectorIndex(selectorName)];
            if (s == null) {
                return null;
            }
            return (Node)((Object)RowIteratorImpl.this.itemMgr.getItem(s.getNodeId()));
        }

        public String getPath() throws RepositoryException {
            this.checkSingleSelector("Use getPath(String) instead.");
            return RowIteratorImpl.this.resolver.getJCRPath(RowIteratorImpl.this.hmgr.getPath(this.sn[0].getNodeId()));
        }

        public String getPath(String selectorName) throws RepositoryException {
            Node n = this.getNode(selectorName);
            if (n != null) {
                return n.getPath();
            }
            return null;
        }

        public double getScore() throws RepositoryException {
            this.checkSingleSelector("Use getScore(String) instead.");
            return this.score;
        }

        public double getScore(String selectorName) throws RepositoryException {
            ScoreNode s = this.sn[this.getSelectorIndex(selectorName)];
            if (s == null) {
                return Double.NaN;
            }
            return s.getScore();
        }

        private NodeImpl getNodeImpl() throws RepositoryException {
            if (this.node == null) {
                this.node = (NodeImpl)RowIteratorImpl.this.itemMgr.getItem(this.sn[0].getNodeId());
            }
            return this.node;
        }

        private void checkSingleSelector(String useInstead) throws RepositoryException {
            if (this.sn.length > 1) {
                String msg = "More than one selector. " + useInstead;
                throw new RepositoryException(msg);
            }
        }

        private int getSelectorIndex(String selectorName) throws RepositoryException {
            int idx = RowIteratorImpl.this.selectorNames.indexOf(RowIteratorImpl.this.resolver.getQName(selectorName));
            if (idx == -1) {
                throw new RepositoryException("Unknown selector name: " + selectorName);
            }
            return idx;
        }

        private boolean isExcerptFunction(Name name) {
            return name.getNamespaceURI().equals("internal") && name.getLocalName().startsWith(RowIteratorImpl.EXCERPT_FUNC_LPAR);
        }

        private boolean isExcerptFunction(String name) {
            try {
                return name.startsWith(RowIteratorImpl.this.resolver.getJCRName(REP_EXCERPT_LPAR));
            }
            catch (NamespaceException e) {
                return false;
            }
        }

        private Value getExcerpt() {
            return this.createExcerpt(this.sn[0].getNodeId());
        }

        private Value getExcerpt(String excerptCall) throws RepositoryException {
            int idx = excerptCall.indexOf(RowIteratorImpl.EXCERPT_FUNC_LPAR);
            int end = excerptCall.lastIndexOf(41);
            if (end == -1) {
                throw new RepositoryException("Missing right parenthesis");
            }
            String pathStr = excerptCall.substring(idx + RowIteratorImpl.EXCERPT_FUNC_LPAR.length(), end).trim();
            String decodedPath = ISO9075.decode(pathStr);
            try {
                NodeImpl n = (NodeImpl)this.getNodeImpl().getNode(decodedPath);
                return this.createExcerpt(n.getNodeId());
            }
            catch (PathNotFoundException e) {
                try {
                    Property p = this.getNode().getProperty(decodedPath);
                    return this.highlight(p.getValue().getString());
                }
                catch (PathNotFoundException e1) {
                    return null;
                }
            }
        }

        private Value createExcerpt(NodeId id) {
            if (RowIteratorImpl.this.excerptProvider == null) {
                return null;
            }
            try {
                long time = System.currentTimeMillis();
                String excerpt = RowIteratorImpl.this.excerptProvider.getExcerpt(id, 3, 150);
                time = System.currentTimeMillis() - time;
                log.debug("Created excerpt in {} ms.", new Long(time));
                if (excerpt != null) {
                    return RowIteratorImpl.this.valueFactory.createValue(excerpt);
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }

        private Value highlight(String text) {
            if (!(RowIteratorImpl.this.excerptProvider instanceof HighlightingExcerptProvider)) {
                return null;
            }
            HighlightingExcerptProvider hep = (HighlightingExcerptProvider)RowIteratorImpl.this.excerptProvider;
            try {
                long time = System.currentTimeMillis();
                text = hep.highlight(text);
                time = System.currentTimeMillis() - time;
                log.debug("Highlighted text in {} ms.", new Long(time));
                return RowIteratorImpl.this.valueFactory.createValue(text);
            }
            catch (IOException e) {
                return null;
            }
        }

        private boolean isSpellCheckFunction(Name name) {
            return name.getNamespaceURI().equals("internal") && name.getLocalName().startsWith(RowIteratorImpl.SPELLCHECK_FUNC_LPAR);
        }

        private Value getSpellCheckedStatement() {
            String v = null;
            if (RowIteratorImpl.this.spellSuggestion != null) {
                try {
                    v = RowIteratorImpl.this.spellSuggestion.getSuggestion();
                }
                catch (IOException e) {
                    log.warn("Spell checking failed", e);
                }
            }
            if (v != null) {
                return RowIteratorImpl.this.valueFactory.createValue(v);
            }
            return null;
        }
    }
}

