/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.constraint;

import java.io.IOException;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.constraint.DynamicOperand;
import org.apache.jackrabbit.core.query.lucene.constraint.EvaluationContext;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.spi.commons.query.qom.PropertyValueImpl;

public class PropertyValueOperand
extends DynamicOperand {
    private final PropertyValueImpl operand;

    public PropertyValueOperand(PropertyValueImpl operand) {
        this.operand = operand;
    }

    public final PropertyState getPropertyState(ScoreNode sn, EvaluationContext context) throws IOException {
        ItemStateManager ism = context.getItemStateManager();
        PropertyId propId = new PropertyId(sn.getNodeId(), this.operand.getPropertyQName());
        try {
            return (PropertyState)ism.getItemState(propId);
        }
        catch (NoSuchItemStateException e) {
            return null;
        }
        catch (ItemStateException e) {
            throw Util.createIOException(e);
        }
    }

    public final Property getProperty(ScoreNode sn, EvaluationContext context) throws IOException {
        SessionImpl session = context.getSession();
        try {
            NodeImpl n = session.getNodeById(sn.getNodeId());
            return n.getProperty(this.operand.getPropertyName());
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw Util.createIOException(e);
        }
    }

    public Value[] getValues(ScoreNode sn, EvaluationContext context) throws IOException {
        PropertyImpl prop = (PropertyImpl)this.getProperty(sn, context);
        if (prop == null) {
            return EMPTY;
        }
        try {
            if (prop.isMultiple()) {
                return prop.getValues();
            }
            return new Value[]{prop.getValue()};
        }
        catch (RepositoryException e) {
            throw Util.createIOException(e);
        }
    }
}

