/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.principal;

import java.security.Principal;
import java.util.Properties;
import org.apache.commons.collections.map.LRUMap;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;

public abstract class AbstractPrincipalProvider
implements PrincipalProvider {
    public static final String MAXSIZE_KEY = "cacheMaxSize";
    private boolean initialized;
    private LRUMap cache;

    protected AbstractPrincipalProvider() {
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized.");
        }
    }

    protected synchronized void clearCache() {
        this.cache.clear();
    }

    protected synchronized void addToCache(Principal principal) {
        this.cache.put(principal.getName(), principal);
    }

    protected abstract Principal providePrincipal(String var1);

    public synchronized Principal getPrincipal(String principalName) {
        this.checkInitialized();
        Principal principal = (Principal)this.cache.get(principalName);
        if (principal == null && (principal = this.providePrincipal(principalName)) != null) {
            this.addToCache(principal);
        }
        return principal;
    }

    public synchronized void init(Properties options) {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        int maxSize = Integer.parseInt(options.getProperty(MAXSIZE_KEY, "1000"));
        this.cache = new LRUMap(maxSize);
        this.initialized = true;
    }

    public synchronized void close() {
        this.checkInitialized();
        this.cache.clear();
        this.initialized = false;
    }
}

