/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.jackrabbit.core.CachingHierarchyManager;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.ZombieHierarchyManager;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.ItemStateMap;
import org.apache.jackrabbit.core.state.ItemStateStore;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.NodeStateListener;
import org.apache.jackrabbit.core.state.NodeStateMerger;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.StaleItemStateException;
import org.apache.jackrabbit.core.state.StateChangeDispatcher;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.spi.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionItemStateManager
implements UpdatableItemStateManager,
Dumpable,
NodeStateListener {
    private static Logger log = LoggerFactory.getLogger(SessionItemStateManager.class);
    private final UpdatableItemStateManager stateMgr;
    private CachingHierarchyManager hierMgr;
    private final ItemStateStore atticStore;
    private final ItemStateStore transientStore;
    private AtticItemStateManager attic;
    private final NodeTypeRegistry ntReg;
    private final transient StateChangeDispatcher dispatcher = new StateChangeDispatcher();

    protected SessionItemStateManager(NodeId rootNodeId, LocalItemStateManager stateMgr, NodeTypeRegistry ntReg) {
        this.transientStore = new ItemStateMap();
        this.atticStore = new ItemStateMap();
        this.stateMgr = stateMgr;
        this.hierMgr = new CachingHierarchyManager(rootNodeId, this);
        this.addListener(this.hierMgr);
        this.ntReg = ntReg;
    }

    public static SessionItemStateManager createInstance(NodeId rootNodeId, LocalItemStateManager stateMgr, NodeTypeRegistry ntReg) {
        SessionItemStateManager mgr = new SessionItemStateManager(rootNodeId, stateMgr, ntReg);
        stateMgr.addListener(mgr);
        return mgr;
    }

    public HierarchyManager getHierarchyMgr() {
        return this.hierMgr;
    }

    public HierarchyManager getAtticAwareHierarchyMgr() {
        return new ZombieHierarchyManager(this.hierMgr, this, this.getAttic());
    }

    public void dump(PrintStream ps) {
        ps.println("SessionItemStateManager (" + this + ")");
        ps.println();
        ps.print("[transient] ");
        if (this.transientStore instanceof Dumpable) {
            ((Dumpable)((Object)this.transientStore)).dump(ps);
        } else {
            ps.println(this.transientStore.toString());
        }
        ps.println();
        ps.print("[attic]     ");
        if (this.atticStore instanceof Dumpable) {
            ((Dumpable)((Object)this.atticStore)).dump(ps);
        } else {
            ps.println(this.atticStore.toString());
        }
        ps.println();
    }

    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        if (this.atticStore.contains(id)) {
            return this.getTransientItemState(id);
        }
        if (this.transientStore.contains(id)) {
            return this.getTransientItemState(id);
        }
        return this.stateMgr.getItemState(id);
    }

    public boolean hasItemState(ItemId id) {
        if (this.atticStore.contains(id)) {
            return this.transientStore.contains(id);
        }
        if (this.transientStore.contains(id)) {
            return true;
        }
        return this.stateMgr.hasItemState(id);
    }

    public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
        return this.stateMgr.getNodeReferences(id);
    }

    public boolean hasNodeReferences(NodeReferencesId id) {
        return this.stateMgr.hasNodeReferences(id);
    }

    public void edit() throws IllegalStateException {
        this.stateMgr.edit();
    }

    public boolean inEditMode() {
        return this.stateMgr.inEditMode();
    }

    public NodeState createNew(NodeId id, Name nodeTypeName, NodeId parentId) throws IllegalStateException {
        return this.stateMgr.createNew(id, nodeTypeName, parentId);
    }

    public NodeState createNew(NodeState transientState) throws IllegalStateException {
        NodeState persistentState = this.createNew(transientState.getNodeId(), transientState.getNodeTypeName(), transientState.getParentId());
        transientState.connect(persistentState);
        return persistentState;
    }

    public PropertyState createNew(Name propName, NodeId parentId) throws IllegalStateException {
        return this.stateMgr.createNew(propName, parentId);
    }

    public PropertyState createNew(PropertyState transientState) throws IllegalStateException {
        PropertyState persistentState = this.createNew(transientState.getName(), transientState.getParentId());
        transientState.connect(persistentState);
        return persistentState;
    }

    public void store(ItemState state) throws IllegalStateException {
        this.stateMgr.store(state);
    }

    public void destroy(ItemState state) throws IllegalStateException {
        this.stateMgr.destroy(state);
    }

    public void cancel() throws IllegalStateException {
        this.stateMgr.cancel();
    }

    public void update() throws ReferentialIntegrityException, StaleItemStateException, ItemStateException, IllegalStateException {
        this.stateMgr.update();
    }

    public void dispose() {
        this.removeListener(this.hierMgr);
        this.disposeAllTransientItemStates();
        this.stateMgr.dispose();
    }

    public ItemState getTransientItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ItemState state = this.transientStore.get(id);
        if (state != null) {
            return state;
        }
        throw new NoSuchItemStateException(id.toString());
    }

    public boolean hasTransientItemState(ItemId id) {
        return this.transientStore.contains(id);
    }

    public boolean hasTransientItemStateInAttic(ItemId id) {
        return this.atticStore.contains(id);
    }

    public boolean hasAnyTransientItemStates() {
        return !this.transientStore.isEmpty();
    }

    public Iterator getDescendantTransientItemStates(NodeId parentId) throws InvalidItemStateException, RepositoryException {
        if (this.transientStore.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        List[] la = new List[10];
        try {
            Iterator iter = this.transientStore.values().iterator();
            while (iter.hasNext()) {
                ArrayList<ItemState> list;
                int depth;
                ItemState state = (ItemState)iter.next();
                try {
                    depth = this.hierMgr.getShareRelativeDepth(parentId, state.getId());
                }
                catch (ItemNotFoundException infe) {
                    String msg = state.getId() + ": the item seems to have been removed externally.";
                    log.debug(msg);
                    throw new InvalidItemStateException(msg);
                }
                if (depth < 1) continue;
                if (depth > la.length) {
                    List[] old = la;
                    la = new List[depth + 10];
                    System.arraycopy(old, 0, la, 0, old.length);
                }
                if ((list = la[depth - 1]) == null) {
                    la[depth - 1] = list = new ArrayList<ItemState>();
                }
                list.add(state);
            }
        }
        catch (RepositoryException re) {
            log.warn("inconsistent hierarchy state", re);
        }
        IteratorChain resultIter = new IteratorChain();
        for (int i = la.length - 1; i >= 0; --i) {
            List list = la[i];
            if (list == null) continue;
            resultIter.addIterator(list.iterator());
        }
        if (resultIter.getIterators().isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return resultIter;
    }

    public Iterator getDescendantTransientItemStatesInAttic(NodeId parentId) {
        if (this.atticStore.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        ZombieHierarchyManager zombieHierMgr = new ZombieHierarchyManager(this.hierMgr, this, this.getAttic());
        List[] la = new List[10];
        try {
            Iterator iter = this.atticStore.values().iterator();
            while (iter.hasNext()) {
                ArrayList<ItemState> list;
                ItemState state = (ItemState)iter.next();
                int depth = zombieHierMgr.getShareRelativeDepth(parentId, state.getId());
                if (depth < 1) continue;
                if (depth > la.length) {
                    List[] old = la;
                    la = new List[depth + 10];
                    System.arraycopy(old, 0, la, 0, old.length);
                }
                if ((list = la[depth - 1]) == null) {
                    la[depth - 1] = list = new ArrayList<ItemState>();
                }
                list.add(state);
            }
        }
        catch (RepositoryException re) {
            log.warn("inconsistent hierarchy state", re);
        }
        IteratorChain resultIter = new IteratorChain();
        for (int i = la.length - 1; i >= 0; --i) {
            List list = la[i];
            if (list == null) continue;
            resultIter.addIterator(list.iterator());
        }
        if (resultIter.getIterators().isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return resultIter;
    }

    public boolean isItemStateInAttic(ItemId id) {
        return this.atticStore.contains(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState createTransientNodeState(NodeId id, Name nodeTypeName, NodeId parentId, int initialStatus) throws ItemStateException {
        ItemStateStore itemStateStore = this.transientStore;
        synchronized (itemStateStore) {
            if (this.transientStore.contains(id)) {
                String msg = "there's already a node state instance with id " + id;
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            NodeState state = new NodeState(id, nodeTypeName, parentId, initialStatus, true);
            this.transientStore.put(state);
            state.setContainer(this);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState createTransientNodeState(NodeState overlayedState, int initialStatus) throws ItemStateException {
        NodeId id = overlayedState.getNodeId();
        ItemStateStore itemStateStore = this.transientStore;
        synchronized (itemStateStore) {
            if (this.transientStore.contains(id)) {
                String msg = "there's already a node state instance with id " + id;
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            NodeState state = new NodeState(overlayedState, initialStatus, true);
            this.transientStore.put(state);
            state.setContainer(this);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyState createTransientPropertyState(NodeId parentId, Name propName, int initialStatus) throws ItemStateException {
        PropertyId id = new PropertyId(parentId, propName);
        ItemStateStore itemStateStore = this.transientStore;
        synchronized (itemStateStore) {
            if (this.transientStore.contains(id)) {
                String msg = "there's already a property state instance with id " + id;
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            PropertyState state = new PropertyState(id, initialStatus, true);
            this.transientStore.put(state);
            state.setContainer(this);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyState createTransientPropertyState(PropertyState overlayedState, int initialStatus) throws ItemStateException {
        PropertyId id = overlayedState.getPropertyId();
        ItemStateStore itemStateStore = this.transientStore;
        synchronized (itemStateStore) {
            if (this.transientStore.contains(id)) {
                String msg = "there's already a property state instance with id " + id;
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            PropertyState state = new PropertyState(overlayedState, initialStatus, true);
            this.transientStore.put(state);
            state.setContainer(this);
            return state;
        }
    }

    public void disconnectTransientItemState(ItemState state) {
        state.disconnect();
    }

    public void disposeTransientItemState(ItemState state) {
        state.discard();
        this.transientStore.remove(state.getId());
        state.onDisposed();
    }

    public void moveTransientItemStateToAttic(ItemState state) {
        this.transientStore.remove(state.getId());
        this.atticStore.put(state);
    }

    public void disposeTransientItemStateInAttic(ItemState state) {
        state.discard();
        this.atticStore.remove(state.getId());
        state.onDisposed();
    }

    public void disposeAllTransientItemStates() {
        ItemState state;
        ArrayList tmp = new ArrayList(this.transientStore.values());
        Iterator iter = tmp.iterator();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            this.disposeTransientItemState(state);
        }
        tmp = new ArrayList(this.atticStore.values());
        iter = tmp.iterator();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            this.disposeTransientItemStateInAttic(state);
        }
    }

    public void addListener(ItemStateListener listener) {
        this.dispatcher.addListener(listener);
    }

    public void removeListener(ItemStateListener listener) {
        this.dispatcher.removeListener(listener);
    }

    public ItemStateManager getAttic() {
        if (this.attic == null) {
            this.attic = new AtticItemStateManager();
        }
        return this.attic;
    }

    public void stateCreated(ItemState created) {
        ItemState transientState;
        ItemState visibleState = created;
        if (created.getContainer() != this && (transientState = this.transientStore.get(created.getId())) != null) {
            if (transientState.hasOverlayedState()) {
                transientState.pull();
                transientState.setStatus(1);
            } else {
                try {
                    ItemState local = this.stateMgr.getItemState(created.getId());
                    transientState.connect(local);
                    transientState.setModCount(local.getModCount());
                    transientState.setStatus(2);
                }
                catch (ItemStateException e) {
                    transientState.setStatus(5);
                }
            }
            visibleState = transientState;
        }
        this.dispatcher.notifyStateCreated(visibleState);
    }

    public void stateModified(ItemState modified) {
        ItemState visibleState = modified;
        if (modified.getContainer() != this) {
            ItemState transientState = this.transientStore.get(modified.getId());
            if (transientState != null) {
                NodeStateMerger.MergeContext context;
                if (transientState.isNode() && !transientState.isStale() && NodeStateMerger.merge((NodeState)transientState, context = new NodeStateMerger.MergeContext(){

                    public boolean isAdded(ItemId id) {
                        ItemState is = SessionItemStateManager.this.transientStore.get(id);
                        return is != null && is.getStatus() == 4;
                    }

                    public boolean isDeleted(ItemId id) {
                        return SessionItemStateManager.this.atticStore.contains(id);
                    }

                    public boolean isModified(ItemId id) {
                        ItemState is = SessionItemStateManager.this.transientStore.get(id);
                        return is != null && is.getStatus() == 2;
                    }

                    public boolean allowsSameNameSiblings(NodeId id) {
                        try {
                            NodeState ns = (NodeState)SessionItemStateManager.this.getItemState(id);
                            NodeState parent = (NodeState)SessionItemStateManager.this.getItemState(ns.getParentId());
                            Name name = parent.getChildNodeEntry(id).getName();
                            EffectiveNodeType ent = SessionItemStateManager.this.ntReg.getEffectiveNodeType(parent.getNodeTypeName(), parent.getMixinTypeNames());
                            NodeDef def = ent.getApplicableChildNodeDef(name, ns.getNodeTypeName(), SessionItemStateManager.this.ntReg);
                            return def != null ? def.allowsSameNameSiblings() : false;
                        }
                        catch (Exception e) {
                            log.warn("Unable to get node definition", e);
                            return false;
                        }
                    }
                })) {
                    return;
                }
                transientState.setStatus(5);
                visibleState = transientState;
            }
            if ((transientState = this.atticStore.get(modified.getId())) != null) {
                transientState.setStatus(5);
                visibleState = transientState;
            }
        }
        this.dispatcher.notifyStateModified(visibleState);
    }

    public void stateDestroyed(ItemState destroyed) {
        ItemState visibleState = destroyed;
        if (destroyed.getContainer() != this) {
            ItemState transientState = this.transientStore.get(destroyed.getId());
            if (transientState != null) {
                transientState.setStatus(6);
                visibleState = transientState;
            } else {
                transientState = this.atticStore.get(destroyed.getId());
                if (transientState != null) {
                    this.atticStore.remove(destroyed.getId());
                    transientState.onDisposed();
                }
            }
        }
        this.dispatcher.notifyStateDestroyed(visibleState);
    }

    public void stateDiscarded(ItemState discarded) {
        ItemState transientState;
        ItemState visibleState = discarded;
        if (discarded.getContainer() != this && (transientState = this.transientStore.get(discarded.getId())) != null) {
            transientState.setStatus(0);
            visibleState = transientState;
        }
        this.dispatcher.notifyStateDiscarded(visibleState);
    }

    public void nodeAdded(NodeState state, Name name, int index, NodeId id) {
        if (state.getContainer() == this || !this.transientStore.contains(state.getId())) {
            this.dispatcher.notifyNodeAdded(state, name, index, id);
        }
    }

    public void nodesReplaced(NodeState state) {
        if (state.getContainer() == this || !this.transientStore.contains(state.getId())) {
            this.dispatcher.notifyNodesReplaced(state);
        }
    }

    public void nodeModified(NodeState state) {
        if (state.getContainer() == this || !this.transientStore.contains(state.getId())) {
            this.dispatcher.notifyNodeModified(state);
        }
    }

    public void nodeRemoved(NodeState state, Name name, int index, NodeId id) {
        if (state.getContainer() == this || !this.transientStore.contains(state.getId())) {
            this.dispatcher.notifyNodeRemoved(state, name, index, id);
        }
    }

    private class AtticItemStateManager
    implements ItemStateManager {
        private AtticItemStateManager() {
        }

        public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
            ItemState state = SessionItemStateManager.this.atticStore.get(id);
            if (state != null) {
                return state;
            }
            throw new NoSuchItemStateException(id.toString());
        }

        public boolean hasItemState(ItemId id) {
            return SessionItemStateManager.this.atticStore.contains(id);
        }

        public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
            throw new ItemStateException("getNodeReferences() not implemented");
        }

        public boolean hasNodeReferences(NodeReferencesId id) {
            return false;
        }
    }
}

