/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.Calendar;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.api.jsr283.version.Version;
import org.apache.jackrabbit.core.AbstractNodeData;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.version.InternalFrozenNode;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.VersionHistoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionImpl
extends NodeImpl
implements Version {
    private static Logger log = LoggerFactory.getLogger(VersionImpl.class);

    public VersionImpl(ItemManager itemMgr, SessionImpl session, AbstractNodeData data) {
        super(itemMgr, session, data);
    }

    protected InternalVersion getInternalVersion() throws RepositoryException {
        InternalVersion version = this.session.getVersionManager().getVersion((NodeId)this.id);
        if (version == null) {
            throw new InvalidItemStateException(this.id + ": the item does not exist anymore");
        }
        return version;
    }

    public Calendar getCreated() throws RepositoryException {
        return this.getInternalVersion().getCreated();
    }

    public javax.jcr.version.Version[] getSuccessors() throws RepositoryException {
        InternalVersion[] suc = this.getInternalVersion().getSuccessors();
        javax.jcr.version.Version[] ret = new Version[suc.length];
        for (int i = 0; i < suc.length; ++i) {
            ret[i] = (Version)((Object)this.session.getNodeById(suc[i].getId()));
        }
        return ret;
    }

    public javax.jcr.version.Version[] getPredecessors() throws RepositoryException {
        InternalVersion[] pred = this.getInternalVersion().getPredecessors();
        javax.jcr.version.Version[] ret = new Version[pred.length];
        for (int i = 0; i < pred.length; ++i) {
            ret[i] = (Version)((Object)this.session.getNodeById(pred[i].getId()));
        }
        return ret;
    }

    public Version getLinearSuccessor() throws RepositoryException {
        InternalVersionHistory vh = ((VersionHistoryImpl)this.getContainingHistory()).getInternalVersionHistory();
        NodeId id = new NodeId(vh.getVersionableUUID());
        NodeImpl vn = this.session.getNodeById(id);
        InternalVersion base = ((VersionImpl)vn.getBaseVersion()).getInternalVersion();
        InternalVersion suc = this.getInternalVersion().getLinearSuccessor(base);
        return (Version)((Object)this.session.getNodeById(suc.getId()));
    }

    public javax.jcr.version.Version getLinearPredecessor() throws RepositoryException {
        InternalVersion pred = this.getInternalVersion().getLinearPredecessor();
        return (Version)((Object)this.session.getNodeById(pred.getId()));
    }

    public VersionHistory getContainingHistory() throws RepositoryException {
        return (org.apache.jackrabbit.api.jsr283.version.VersionHistory)this.getParent();
    }

    public InternalFrozenNode getInternalFrozenNode() throws RepositoryException {
        return this.getInternalVersion().getFrozenNode();
    }

    public Node getFrozenNode() throws RepositoryException {
        return this.session.getNodeById(this.getInternalVersion().getFrozenNodeId());
    }

    public boolean isSame(Item otherItem) {
        if (otherItem instanceof VersionImpl) {
            try {
                InternalVersion other = ((VersionImpl)otherItem).getInternalVersion();
                return other.getId().equals(this.getInternalVersion().getId());
            }
            catch (RepositoryException e) {
                log.warn("Unable to retrieve internal version objects: " + e.getMessage());
                log.debug("Stack dump:", e);
            }
        }
        return false;
    }

    public boolean isMoreRecent(VersionImpl v) throws RepositoryException {
        return this.getInternalVersion().isMoreRecent(v.getInternalVersion());
    }

    public boolean isRootVersion() throws RepositoryException {
        return this.getInternalVersion().isRootVersion();
    }

    public void update(String srcWorkspaceName) throws ConstraintViolationException {
        String msg = "update operation not allowed: " + this;
        log.debug(msg);
        throw new ConstraintViolationException(msg);
    }

    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws ConstraintViolationException {
        String msg = "merge operation not allowed: " + this;
        log.debug(msg);
        throw new ConstraintViolationException(msg);
    }

    public String toString() {
        return "version " + super.toString();
    }
}

