/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Stack;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.xml.BufferedStringValue;
import org.apache.jackrabbit.core.xml.Importer;
import org.apache.jackrabbit.core.xml.NodeInfo;
import org.apache.jackrabbit.core.xml.PropInfo;
import org.apache.jackrabbit.core.xml.StringValue;
import org.apache.jackrabbit.core.xml.TargetImportHandler;
import org.apache.jackrabbit.core.xml.TextValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NameParser;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.util.ISO9075;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class DocViewImportHandler
extends TargetImportHandler {
    private static Logger log = LoggerFactory.getLogger(DocViewImportHandler.class);
    private final Stack stack = new Stack();
    private BufferedStringValue textHandler = null;

    DocViewImportHandler(Importer importer) {
        super(importer);
    }

    private Name[] parseNames(String value) throws SAXException {
        String[] names = value.split("\\p{Space}+");
        Name[] qnames = new Name[names.length];
        for (int i = 0; i < names.length; ++i) {
            try {
                qnames[i] = this.resolver.getQName(names[i]);
                continue;
            }
            catch (NameException ne) {
                throw new SAXException("Invalid name: " + names[i], ne);
            }
            catch (NamespaceException e) {
                throw new SAXException("Invalid name: " + names[i], e);
            }
        }
        return qnames;
    }

    private void appendCharacters(char[] ch, int start, int length) throws SAXException {
        if (this.textHandler == null) {
            this.textHandler = new BufferedStringValue(this.resolver);
        }
        try {
            this.textHandler.append(ch, start, length);
        }
        catch (IOException ioe) {
            String msg = "internal error while processing internal buffer data";
            log.error(msg, ioe);
            throw new SAXException(msg, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCharacters() throws SAXException {
        block8: {
            try {
                if (this.textHandler == null || this.textHandler.length() <= 0L) break block8;
                Reader reader = this.textHandler.reader();
                try {
                    int ch;
                    while ((ch = reader.read()) != -1 && ch <= 32) {
                    }
                    if (ch == -1) {
                        log.debug("ignoring pure whitespace character data...");
                        this.textHandler.dispose();
                        this.textHandler = null;
                        return;
                    }
                }
                finally {
                    reader.close();
                }
                NodeInfo node = new NodeInfo(NameConstants.JCR_XMLTEXT, null, null, null);
                TextValue[] values = new TextValue[]{this.textHandler};
                ArrayList<PropInfo> props = new ArrayList<PropInfo>();
                PropInfo prop = new PropInfo(NameConstants.JCR_XMLCHARACTERS, 1, values);
                props.add(prop);
                this.importer.startNode(node, props);
                this.importer.endNode(node);
                this.textHandler.dispose();
                this.textHandler = null;
            }
            catch (IOException ioe) {
                String msg = "internal error while processing internal buffer data";
                log.error(msg, ioe);
                throw new SAXException(msg, ioe);
            }
            catch (RepositoryException re) {
                throw new SAXException(re);
            }
        }
    }

    private Name processName(Name name) {
        String decodedLocalName = ISO9075.decode(name.getLocalName());
        Name decoded = NameFactoryImpl.getInstance().create(name.getNamespaceURI(), decodedLocalName);
        if (!decoded.equals(name)) {
            try {
                NameParser.checkFormat(decoded.getLocalName());
                return decoded;
            }
            catch (IllegalNameException ine) {
                log.warn("encountered illegal encoded name '" + name.getLocalName() + "': " + ine.getMessage());
            }
        }
        return name;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.processCharacters();
        try {
            Name nodeName = NameFactoryImpl.getInstance().create(namespaceURI, localName);
            nodeName = this.processName(nodeName);
            NodeId id = null;
            Name nodeTypeName = null;
            Name[] mixinTypes = null;
            ArrayList<PropInfo> props = new ArrayList<PropInfo>(atts.getLength());
            for (int i = 0; i < atts.getLength(); ++i) {
                if (atts.getURI(i).equals("http://www.w3.org/2000/xmlns/")) continue;
                Name propName = NameFactoryImpl.getInstance().create(atts.getURI(i), atts.getLocalName(i));
                propName = this.processName(propName);
                String attrValue = atts.getValue(i);
                TextValue[] propValues = new TextValue[]{new StringValue(attrValue, this.resolver)};
                if (propName.equals(NameConstants.JCR_PRIMARYTYPE)) {
                    if (attrValue.length() <= 0) continue;
                    try {
                        nodeTypeName = this.resolver.getQName(attrValue);
                        continue;
                    }
                    catch (NameException ne) {
                        throw new SAXException("illegal jcr:primaryType value: " + attrValue, ne);
                    }
                }
                if (propName.equals(NameConstants.JCR_MIXINTYPES)) {
                    mixinTypes = this.parseNames(attrValue);
                    continue;
                }
                if (propName.equals(NameConstants.JCR_UUID)) {
                    if (attrValue.length() <= 0) continue;
                    id = NodeId.valueOf(attrValue);
                    continue;
                }
                props.add(new PropInfo(propName, 0, propValues));
            }
            NodeInfo node = new NodeInfo(nodeName, nodeTypeName, mixinTypes, id);
            this.importer.startNode(node, props);
            this.stack.push(node);
        }
        catch (RepositoryException re) {
            throw new SAXException(re);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.appendCharacters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.appendCharacters(ch, start, length);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.processCharacters();
        NodeInfo node = (NodeInfo)this.stack.peek();
        try {
            this.importer.endNode(node);
        }
        catch (RepositoryException re) {
            throw new SAXException(re);
        }
        this.stack.pop();
    }
}

