/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IAnnotation;
import org.eclipse.jdt.core.util.IAnnotationComponent;
import org.eclipse.jdt.core.util.IAnnotationComponentValue;
import org.eclipse.jdt.core.util.IAnnotationDefaultAttribute;
import org.eclipse.jdt.core.util.IAttributeNamesConstants;
import org.eclipse.jdt.core.util.IClassFileAttribute;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.ICodeAttribute;
import org.eclipse.jdt.core.util.IConstantPool;
import org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.eclipse.jdt.core.util.IConstantValueAttribute;
import org.eclipse.jdt.core.util.IEnclosingMethodAttribute;
import org.eclipse.jdt.core.util.IExceptionAttribute;
import org.eclipse.jdt.core.util.IExceptionTableEntry;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jdt.core.util.IInnerClassesAttribute;
import org.eclipse.jdt.core.util.IInnerClassesAttributeEntry;
import org.eclipse.jdt.core.util.ILineNumberAttribute;
import org.eclipse.jdt.core.util.ILocalVariableAttribute;
import org.eclipse.jdt.core.util.ILocalVariableTableEntry;
import org.eclipse.jdt.core.util.ILocalVariableTypeTableAttribute;
import org.eclipse.jdt.core.util.ILocalVariableTypeTableEntry;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.core.util.IParameterAnnotation;
import org.eclipse.jdt.core.util.IRuntimeInvisibleAnnotationsAttribute;
import org.eclipse.jdt.core.util.IRuntimeInvisibleParameterAnnotationsAttribute;
import org.eclipse.jdt.core.util.IRuntimeVisibleAnnotationsAttribute;
import org.eclipse.jdt.core.util.IRuntimeVisibleParameterAnnotationsAttribute;
import org.eclipse.jdt.core.util.ISignatureAttribute;
import org.eclipse.jdt.core.util.ISourceAttribute;
import org.eclipse.jdt.internal.core.util.ClassFileReader;
import org.eclipse.jdt.internal.core.util.DefaultBytecodeVisitor;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;

public class Disassembler
extends ClassFileBytesDisassembler {
    private static final String EMPTY_CLASS_NAME = "\"\"";
    private static final char[] ANY_EXCEPTION = Messages.classfileformat_anyexceptionhandler.toCharArray();
    private static final String EMPTY_OUTPUT = "";
    private static final String VERSION_UNKNOWN = "unknown";

    private boolean appendModifier(StringBuffer buffer, int accessFlags, int modifierConstant, String modifier, boolean firstModifier) {
        if ((accessFlags & modifierConstant) != 0) {
            if (!firstModifier) {
                buffer.append(Messages.disassembler_space);
            }
            if (firstModifier) {
                firstModifier = false;
            }
            buffer.append(modifier);
        }
        return firstModifier;
    }

    private void decodeModifiersForField(StringBuffer buffer, int accessFlags) {
        boolean firstModifier = true;
        firstModifier = this.appendModifier(buffer, accessFlags, 1, "public", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 4, "protected", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 2, "private", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 8, "static", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 16, "final", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 128, "transient", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 64, "volatile", firstModifier);
        if (!(firstModifier = this.appendModifier(buffer, accessFlags, 16384, "enum", firstModifier))) {
            buffer.append(Messages.disassembler_space);
        }
    }

    private final void decodeModifiersForInnerClasses(StringBuffer buffer, int accessFlags) {
        boolean firstModifier = true;
        firstModifier = this.appendModifier(buffer, accessFlags, 1, "public", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 4, "protected", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 2, "private", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 1024, "abstract", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 8, "static", firstModifier);
        if (!(firstModifier = this.appendModifier(buffer, accessFlags, 16, "final", firstModifier))) {
            buffer.append(Messages.disassembler_space);
        }
    }

    private final void decodeModifiersForMethod(StringBuffer buffer, int accessFlags) {
        boolean firstModifier = true;
        firstModifier = this.appendModifier(buffer, accessFlags, 1, "public", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 4, "protected", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 2, "private", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 1024, "abstract", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 8, "static", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 16, "final", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 32, "synchronized", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 256, "native", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 2048, "strictfp", firstModifier);
        if (!(firstModifier = this.appendModifier(buffer, accessFlags, 64, "bridge", firstModifier))) {
            buffer.append(Messages.disassembler_space);
        }
    }

    private final void decodeModifiersForType(StringBuffer buffer, int accessFlags) {
        boolean firstModifier = true;
        firstModifier = this.appendModifier(buffer, accessFlags, 1, "public", firstModifier);
        firstModifier = this.appendModifier(buffer, accessFlags, 1024, "abstract", firstModifier);
        if (!(firstModifier = this.appendModifier(buffer, accessFlags, 16, "final", firstModifier))) {
            buffer.append(Messages.disassembler_space);
        }
    }

    private String decodeStringValue(char[] chars) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int max = chars.length;
        while (i < max) {
            char c = chars[i];
            switch (c) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\"': {
                    buffer.append("\\\"");
                    break;
                }
                case '\'': {
                    buffer.append("\\'");
                    break;
                }
                case '\\': {
                    buffer.append("\\\\");
                    break;
                }
                case '\u0000': {
                    buffer.append("\\0");
                    break;
                }
                case '\u0001': {
                    buffer.append("\\1");
                    break;
                }
                case '\u0002': {
                    buffer.append("\\2");
                    break;
                }
                case '\u0003': {
                    buffer.append("\\3");
                    break;
                }
                case '\u0004': {
                    buffer.append("\\4");
                    break;
                }
                case '\u0005': {
                    buffer.append("\\5");
                    break;
                }
                case '\u0006': {
                    buffer.append("\\6");
                    break;
                }
                case '\u0007': {
                    buffer.append("\\7");
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private String decodeStringValue(String s) {
        return this.decodeStringValue(s.toCharArray());
    }

    public String disassemble(byte[] classFileBytes, String lineSeparator) throws ClassFormatException {
        return this.disassemble(new ClassFileReader(classFileBytes, 65535), lineSeparator, 2);
    }

    public String disassemble(byte[] classFileBytes, String lineSeparator, int mode) throws ClassFormatException {
        return this.disassemble(new ClassFileReader(classFileBytes, 65535), lineSeparator, mode);
    }

    private void disassemble(IAnnotation annotation, StringBuffer buffer, String lineSeparator, int tabNumber) {
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        int typeIndex = annotation.getTypeIndex();
        char[] typeName = CharOperation.replaceOnCopy(annotation.getTypeName(), '/', '.');
        buffer.append(Messages.bind(Messages.disassembler_annotationentrystart, new String[]{Integer.toString(typeIndex), new String(Signature.toCharArray(typeName))}));
        IAnnotationComponent[] components = annotation.getComponents();
        int i = 0;
        int max = components.length;
        while (i < max) {
            this.disassemble(components[i], buffer, lineSeparator, tabNumber + 1);
            ++i;
        }
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Messages.disassembler_annotationentryend);
    }

    private void disassemble(IAnnotationComponent annotationComponent, StringBuffer buffer, String lineSeparator, int tabNumber) {
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Messages.bind(Messages.disassembler_annotationcomponent, new String[]{Integer.toString(annotationComponent.getComponentNameIndex()), new String(annotationComponent.getComponentName())}));
        this.disassemble(annotationComponent.getComponentValue(), buffer, lineSeparator, tabNumber + 1);
    }

    private void disassemble(IAnnotationComponentValue annotationComponentValue, StringBuffer buffer, String lineSeparator, int tabNumber) {
        switch (annotationComponentValue.getTag()) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                IConstantPoolEntry constantPoolEntry = annotationComponentValue.getConstantValue();
                String value = null;
                switch (constantPoolEntry.getKind()) {
                    case 5: {
                        value = String.valueOf(constantPoolEntry.getLongValue()) + "L";
                        break;
                    }
                    case 4: {
                        value = String.valueOf(constantPoolEntry.getFloatValue()) + "f";
                        break;
                    }
                    case 6: {
                        value = Double.toString(constantPoolEntry.getDoubleValue());
                        break;
                    }
                    case 3: {
                        switch (annotationComponentValue.getTag()) {
                            case 67: {
                                value = "'" + (char)constantPoolEntry.getIntegerValue() + "'";
                                break;
                            }
                            case 90: {
                                value = constantPoolEntry.getIntegerValue() == 1 ? "true" : "false";
                                break;
                            }
                            case 66: {
                                value = "(byte) " + constantPoolEntry.getIntegerValue();
                                break;
                            }
                            case 83: {
                                value = "(short) " + constantPoolEntry.getIntegerValue();
                                break;
                            }
                            case 73: {
                                value = "(int) " + constantPoolEntry.getIntegerValue();
                            }
                        }
                        break;
                    }
                    case 1: {
                        value = "\"" + this.decodeStringValue(constantPoolEntry.getUtf8Value()) + "\"";
                    }
                }
                buffer.append(Messages.bind(Messages.disassembler_annotationdefaultvalue, value));
                break;
            }
            case 101: {
                int enumConstantTypeNameIndex = annotationComponentValue.getEnumConstantTypeNameIndex();
                char[] typeName = CharOperation.replaceOnCopy(annotationComponentValue.getEnumConstantTypeName(), '/', '.');
                int enumConstantNameIndex = annotationComponentValue.getEnumConstantNameIndex();
                char[] constantName = annotationComponentValue.getEnumConstantName();
                buffer.append(Messages.bind(Messages.disassembler_annotationenumvalue, new String[]{Integer.toString(enumConstantTypeNameIndex), Integer.toString(enumConstantNameIndex), new String(Signature.toCharArray(typeName)), new String(constantName)}));
                break;
            }
            case 99: {
                int classIndex = annotationComponentValue.getClassInfoIndex();
                IConstantPoolEntry constantPoolEntry = annotationComponentValue.getClassInfo();
                char[] className = CharOperation.replaceOnCopy(constantPoolEntry.getUtf8Value(), '/', '.');
                buffer.append(Messages.bind(Messages.disassembler_annotationclassvalue, new String[]{Integer.toString(classIndex), new String(Signature.toCharArray(className))}));
                break;
            }
            case 64: {
                buffer.append(Messages.disassembler_annotationannotationvalue);
                IAnnotation annotation = annotationComponentValue.getAnnotationValue();
                this.disassemble(annotation, buffer, lineSeparator, tabNumber + 1);
                break;
            }
            case 91: {
                buffer.append(Messages.disassembler_annotationarrayvaluestart);
                IAnnotationComponentValue[] annotationComponentValues = annotationComponentValue.getAnnotationComponentValues();
                int i = 0;
                int max = annotationComponentValues.length;
                while (i < max) {
                    this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
                    this.disassemble(annotationComponentValues[i], buffer, lineSeparator, tabNumber + 1);
                    ++i;
                }
                this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
                buffer.append(Messages.disassembler_annotationarrayvalueend);
            }
        }
    }

    private void disassemble(IAnnotationDefaultAttribute annotationDefaultAttribute, StringBuffer buffer, String lineSeparator, int tabNumber) {
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Messages.disassembler_annotationdefaultheader);
        IAnnotationComponentValue componentValue = annotationDefaultAttribute.getMemberValue();
        this.writeNewLine(buffer, lineSeparator, tabNumber + 2);
        this.disassemble(componentValue, buffer, lineSeparator, tabNumber + 1);
    }

    private void disassemble(IClassFileAttribute classFileAttribute, StringBuffer buffer, String lineSeparator, int tabNumber) {
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Messages.bind(Messages.disassembler_genericattributeheader, new String[]{new String(classFileAttribute.getAttributeName()), Long.toString(classFileAttribute.getAttributeLength())}));
    }

    private void disassemble(IClassFileReader classFileReader, IMethodInfo methodInfo, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        int length;
        char[] methodName;
        this.writeNewLine(buffer, lineSeparator, tabNumber);
        ICodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        char[] methodDescriptor = methodInfo.getDescriptor();
        IClassFileAttribute classFileAttribute = Util.getAttribute(methodInfo, IAttributeNamesConstants.SIGNATURE);
        ISignatureAttribute signatureAttribute = (ISignatureAttribute)classFileAttribute;
        IClassFileAttribute runtimeVisibleAnnotationsAttribute = Util.getAttribute(methodInfo, IAttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS);
        IClassFileAttribute runtimeInvisibleAnnotationsAttribute = Util.getAttribute(methodInfo, IAttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS);
        IClassFileAttribute runtimeVisibleParameterAnnotationsAttribute = Util.getAttribute(methodInfo, IAttributeNamesConstants.RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS);
        IClassFileAttribute runtimeInvisibleParameterAnnotationsAttribute = Util.getAttribute(methodInfo, IAttributeNamesConstants.RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS);
        IClassFileAttribute annotationDefaultAttribute = Util.getAttribute(methodInfo, IAttributeNamesConstants.ANNOTATION_DEFAULT);
        if (this.checkMode(mode, 5)) {
            buffer.append(Messages.bind(Messages.classfileformat_methoddescriptor, new String[]{Integer.toString(methodInfo.getDescriptorIndex()), new String(methodDescriptor)}));
            if (methodInfo.isDeprecated()) {
                buffer.append(Messages.disassembler_deprecated);
            }
            this.writeNewLine(buffer, lineSeparator, tabNumber);
            if (signatureAttribute != null) {
                buffer.append(Messages.bind(Messages.disassembler_signatureattributeheader, new String(signatureAttribute.getSignature())));
                this.writeNewLine(buffer, lineSeparator, tabNumber);
            }
            if (codeAttribute != null) {
                buffer.append(Messages.bind(Messages.classfileformat_stacksAndLocals, new String[]{Integer.toString(codeAttribute.getMaxStack()), Integer.toString(codeAttribute.getMaxLocals())}));
                this.writeNewLine(buffer, lineSeparator, tabNumber);
            }
        }
        if (this.checkMode(mode, 1)) {
            if (runtimeInvisibleAnnotationsAttribute != null) {
                this.disassembleAsModifier((IRuntimeInvisibleAnnotationsAttribute)runtimeInvisibleAnnotationsAttribute, buffer, lineSeparator, tabNumber + 1);
                this.writeNewLine(buffer, lineSeparator, tabNumber);
            }
            if (runtimeVisibleAnnotationsAttribute != null) {
                this.disassembleAsModifier((IRuntimeVisibleAnnotationsAttribute)runtimeVisibleAnnotationsAttribute, buffer, lineSeparator, tabNumber + 1);
                this.writeNewLine(buffer, lineSeparator, tabNumber);
            }
        }
        int accessFlags = methodInfo.getAccessFlags();
        this.decodeModifiersForMethod(buffer, accessFlags);
        if (methodInfo.isSynthetic()) {
            buffer.append("synthetic");
            buffer.append(Messages.disassembler_space);
        }
        CharOperation.replace(methodDescriptor, '/', '.');
        if (methodInfo.isConstructor()) {
            methodName = classFileReader.getClassName();
            buffer.append(Signature.toCharArray(methodDescriptor, methodName, this.getParameterNames(methodDescriptor, codeAttribute, accessFlags), false, false, (accessFlags & 0x80) != 0));
        } else if (methodInfo.isClinit()) {
            buffer.append(Messages.bind(Messages.classfileformat_clinitname));
        } else {
            methodName = methodInfo.getName();
            buffer.append(Signature.toCharArray(methodDescriptor, methodName, this.getParameterNames(methodDescriptor, codeAttribute, accessFlags), false, true, (accessFlags & 0x80) != 0));
        }
        IExceptionAttribute exceptionAttribute = methodInfo.getExceptionAttribute();
        if (exceptionAttribute != null) {
            buffer.append(" throws ");
            char[][] exceptionNames = exceptionAttribute.getExceptionNames();
            length = exceptionNames.length;
            int i = 0;
            while (i < length - 1) {
                char[] exceptionName = exceptionNames[i];
                CharOperation.replace(exceptionName, '/', '.');
                buffer.append(this.returnClassName(exceptionName, '.', mode)).append(Messages.disassembler_comma).append(Messages.disassembler_space);
                ++i;
            }
            char[] exceptionName = exceptionNames[length - 1];
            CharOperation.replace(exceptionName, '/', '.');
            buffer.append(this.returnClassName(exceptionName, '.', mode));
        }
        if (this.checkMode(mode, 1) && annotationDefaultAttribute != null) {
            buffer.append(" default ");
            this.disassembleAsModifier((IAnnotationDefaultAttribute)annotationDefaultAttribute, buffer, lineSeparator, tabNumber);
        }
        buffer.append(Messages.disassembler_endofmethodheader);
        if (this.checkMode(mode, 5) && codeAttribute != null) {
            this.disassemble(codeAttribute, buffer, lineSeparator, tabNumber, mode);
        }
        if (this.checkMode(mode, 4)) {
            IClassFileAttribute[] attributes = methodInfo.getAttributes();
            length = attributes.length;
            if (length != 0) {
                int i = 0;
                while (i < length) {
                    IClassFileAttribute attribute = attributes[i];
                    if (attribute != codeAttribute && attribute != exceptionAttribute && attribute != signatureAttribute && attribute != annotationDefaultAttribute && attribute != runtimeInvisibleAnnotationsAttribute && attribute != runtimeVisibleAnnotationsAttribute && attribute != runtimeInvisibleParameterAnnotationsAttribute && attribute != runtimeVisibleParameterAnnotationsAttribute && !CharOperation.equals(attribute.getAttributeName(), IAttributeNamesConstants.DEPRECATED) && !CharOperation.equals(attribute.getAttributeName(), IAttributeNamesConstants.SYNTHETIC)) {
                        this.disassemble(attribute, buffer, lineSeparator, tabNumber);
                        this.writeNewLine(buffer, lineSeparator, tabNumber);
                    }
                    ++i;
                }
            }
            if (annotationDefaultAttribute != null) {
                this.disassemble((IAnnotationDefaultAttribute)annotationDefaultAttribute, buffer, lineSeparator, tabNumber);
            }
            if (runtimeVisibleAnnotationsAttribute != null) {
                this.disassemble((IRuntimeVisibleAnnotationsAttribute)runtimeVisibleAnnotationsAttribute, buffer, lineSeparator, tabNumber);
            }
            if (runtimeInvisibleAnnotationsAttribute != null) {
                this.disassemble((IRuntimeInvisibleAnnotationsAttribute)runtimeInvisibleAnnotationsAttribute, buffer, lineSeparator, tabNumber);
            }
            if (runtimeVisibleParameterAnnotationsAttribute != null) {
                this.disassemble((IRuntimeVisibleParameterAnnotationsAttribute)runtimeVisibleParameterAnnotationsAttribute, buffer, lineSeparator, tabNumber);
            }
            if (runtimeInvisibleParameterAnnotationsAttribute != null) {
                this.disassemble((IRuntimeInvisibleParameterAnnotationsAttribute)runtimeInvisibleParameterAnnotationsAttribute, buffer, lineSeparator, tabNumber);
            }
        }
    }

    public String disassemble(IClassFileReader classFileReader, String lineSeparator) {
        return this.disassemble(classFileReader, lineSeparator, 2);
    }

    public String disassemble(IClassFileReader classFileReader, String lineSeparator, int mode) {
        char[][] superclassInterfaces;
        int length;
        char[] className;
        if (classFileReader == null) {
            return EMPTY_OUTPUT;
        }
        StringBuffer buffer = new StringBuffer();
        ISourceAttribute sourceAttribute = classFileReader.getSourceFileAttribute();
        IClassFileAttribute classFileAttribute = Util.getAttribute(classFileReader, IAttributeNamesConstants.SIGNATURE);
        ISignatureAttribute signatureAttribute = (ISignatureAttribute)classFileAttribute;
        int accessFlags = classFileReader.getAccessFlags();
        if (this.checkMode(mode, 5)) {
            int minorVersion = classFileReader.getMinorVersion();
            int majorVersion = classFileReader.getMajorVersion();
            buffer.append(Messages.disassembler_begincommentline);
            if (sourceAttribute != null) {
                buffer.append(Messages.disassembler_sourceattributeheader);
                buffer.append(sourceAttribute.getSourceFileName());
            }
            String versionNumber = VERSION_UNKNOWN;
            if (minorVersion == 3 && majorVersion == 45) {
                versionNumber = "1.1";
            } else if (minorVersion == 0 && majorVersion == 46) {
                versionNumber = "1.2";
            } else if (minorVersion == 0 && majorVersion == 47) {
                versionNumber = "1.3";
            } else if (minorVersion == 0 && majorVersion == 48) {
                versionNumber = "1.4";
            } else if (minorVersion == 0 && majorVersion == 49) {
                versionNumber = "1.5";
            }
            buffer.append(Messages.bind(Messages.classfileformat_versiondetails, new String[]{versionNumber, Integer.toString(majorVersion), Integer.toString(minorVersion), String.valueOf((accessFlags & 0x20) != 0 ? Messages.classfileformat_superflagisset : Messages.classfileformat_superflagisnotset) + (this.isDeprecated(classFileReader) ? ", deprecated" : EMPTY_OUTPUT)}));
            this.writeNewLine(buffer, lineSeparator, 0);
            if (signatureAttribute != null) {
                buffer.append(Messages.bind(Messages.disassembler_signatureattributeheader, new String(signatureAttribute.getSignature())));
                this.writeNewLine(buffer, lineSeparator, 0);
            }
        }
        if ((className = classFileReader.getClassName()) == null) {
            return buffer.toString();
        }
        IInnerClassesAttribute innerClassesAttribute = classFileReader.getInnerClassesAttribute();
        IClassFileAttribute runtimeVisibleAnnotationsAttribute = Util.getAttribute(classFileReader, IAttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS);
        IClassFileAttribute runtimeInvisibleAnnotationsAttribute = Util.getAttribute(classFileReader, IAttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS);
        if (this.checkMode(mode, 1)) {
            if (runtimeInvisibleAnnotationsAttribute != null) {
                this.disassembleAsModifier((IRuntimeInvisibleAnnotationsAttribute)runtimeInvisibleAnnotationsAttribute, buffer, lineSeparator, 1);
                this.writeNewLine(buffer, lineSeparator, 0);
            }
            if (runtimeVisibleAnnotationsAttribute != null) {
                this.disassembleAsModifier((IRuntimeVisibleAnnotationsAttribute)runtimeVisibleAnnotationsAttribute, buffer, lineSeparator, 1);
                this.writeNewLine(buffer, lineSeparator, 0);
            }
        }
        boolean decoded = false;
        if (innerClassesAttribute != null) {
            IInnerClassesAttributeEntry[] entries = innerClassesAttribute.getInnerClassAttributesEntries();
            int i = 0;
            int max = entries.length;
            while (i < max) {
                IInnerClassesAttributeEntry entry = entries[i];
                char[] innerClassName = entry.getInnerClassName();
                if (innerClassName != null && CharOperation.equals(classFileReader.getClassName(), innerClassName)) {
                    this.decodeModifiersForInnerClasses(buffer, entry.getAccessFlags());
                    decoded = true;
                }
                ++i;
            }
        }
        if (!decoded) {
            this.decodeModifiersForType(buffer, accessFlags);
            if (this.isSynthetic(classFileReader)) {
                buffer.append("synthetic");
                buffer.append(Messages.disassembler_space);
            }
        }
        if ((accessFlags & 0x4000) != 0) {
            buffer.append("enum ");
        } else if (classFileReader.isClass()) {
            buffer.append("class ");
        } else {
            if ((accessFlags & 0x2000) != 0) {
                buffer.append("@");
            }
            buffer.append("interface ");
        }
        CharOperation.replace(className, '/', '.');
        buffer.append(className);
        char[] superclassName = classFileReader.getSuperclassName();
        if (superclassName != null) {
            buffer.append(" extends ");
            CharOperation.replace(superclassName, '/', '.');
            buffer.append(this.returnClassName(superclassName, '.', mode));
        }
        if ((length = (superclassInterfaces = classFileReader.getInterfaceNames()).length) != 0) {
            buffer.append(" implements ");
            int i = 0;
            while (i < length - 1) {
                char[] superinterface = superclassInterfaces[i];
                CharOperation.replace(superinterface, '/', '.');
                buffer.append(this.returnClassName(superinterface, '.', mode)).append(Messages.disassembler_comma).append(Messages.disassembler_space);
                ++i;
            }
            char[] superinterface = superclassInterfaces[length - 1];
            CharOperation.replace(superinterface, '/', '.');
            buffer.append(this.returnClassName(superinterface, '.', mode));
        }
        buffer.append(Messages.bind(Messages.disassembler_opentypedeclaration));
        if (this.checkMode(mode, 4)) {
            this.disassemble(classFileReader.getConstantPool(), buffer, lineSeparator, 1);
        }
        this.disassembleTypeMembers(classFileReader, buffer, lineSeparator, 1, mode);
        if (this.checkMode(mode, 5)) {
            IClassFileAttribute[] attributes = classFileReader.getAttributes();
            length = attributes.length;
            IEnclosingMethodAttribute enclosingMethodAttribute = this.getEnclosingMethodAttribute(classFileReader);
            int remainingAttributesLength = length;
            if (innerClassesAttribute != null) {
                --remainingAttributesLength;
            }
            if (enclosingMethodAttribute != null) {
                --remainingAttributesLength;
            }
            if (sourceAttribute != null) {
                --remainingAttributesLength;
            }
            if (signatureAttribute != null) {
                --remainingAttributesLength;
            }
            if (innerClassesAttribute != null || enclosingMethodAttribute != null || remainingAttributesLength != 0) {
                this.writeNewLine(buffer, lineSeparator, 0);
            }
            if (innerClassesAttribute != null) {
                this.disassemble(innerClassesAttribute, buffer, lineSeparator, 1);
            }
            if (enclosingMethodAttribute != null) {
                this.disassemble(enclosingMethodAttribute, buffer, lineSeparator, 0);
            }
            if (this.checkMode(mode, 4)) {
                if (runtimeVisibleAnnotationsAttribute != null) {
                    this.disassemble((IRuntimeVisibleAnnotationsAttribute)runtimeVisibleAnnotationsAttribute, buffer, lineSeparator, 0);
                }
                if (runtimeInvisibleAnnotationsAttribute != null) {
                    this.disassemble((IRuntimeInvisibleAnnotationsAttribute)runtimeInvisibleAnnotationsAttribute, buffer, lineSeparator, 0);
                }
                if (length != 0) {
                    int i = 0;
                    while (i < length) {
                        IClassFileAttribute attribute = attributes[i];
                        if (attribute != innerClassesAttribute && attribute != sourceAttribute && attribute != signatureAttribute && attribute != enclosingMethodAttribute && attribute != runtimeInvisibleAnnotationsAttribute && attribute != runtimeVisibleAnnotationsAttribute && !CharOperation.equals(attribute.getAttributeName(), IAttributeNamesConstants.DEPRECATED) && !CharOperation.equals(attribute.getAttributeName(), IAttributeNamesConstants.SYNTHETIC)) {
                            this.disassemble(attribute, buffer, lineSeparator, 0);
                        }
                        ++i;
                    }
                }
            }
        }
        this.writeNewLine(buffer, lineSeparator, 0);
        buffer.append(Messages.disassembler_closetypedeclaration);
        return buffer.toString();
    }

    private void disassemble(ICodeAttribute codeAttribute, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        ILocalVariableTypeTableAttribute localVariableTypeAttribute;
        int localVariableTypeTableLength;
        ILocalVariableAttribute localVariableAttribute;
        int localVariableAttributeLength;
        ILineNumberAttribute lineNumberAttribute;
        int lineAttributeLength;
        this.writeNewLine(buffer, lineSeparator, tabNumber - 1);
        DefaultBytecodeVisitor visitor = new DefaultBytecodeVisitor(codeAttribute, buffer, lineSeparator, tabNumber, mode);
        try {
            codeAttribute.traverse(visitor);
        }
        catch (ClassFormatException classFormatException) {
            this.dumpTab(tabNumber + 2, buffer);
            buffer.append(Messages.classformat_classformatexception);
            this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        }
        int exceptionTableLength = codeAttribute.getExceptionTableLength();
        if (exceptionTableLength != 0) {
            char[] catchType;
            int tabNumberForExceptionAttribute = tabNumber + 2;
            this.dumpTab(tabNumberForExceptionAttribute, buffer);
            IExceptionTableEntry[] exceptionTableEntries = codeAttribute.getExceptionTable();
            buffer.append(Messages.disassembler_exceptiontableheader);
            this.writeNewLine(buffer, lineSeparator, tabNumberForExceptionAttribute + 1);
            int i = 0;
            while (i < exceptionTableLength - 1) {
                char[] catchType2;
                IExceptionTableEntry exceptionTableEntry = exceptionTableEntries[i];
                if (exceptionTableEntry.getCatchTypeIndex() != 0) {
                    catchType2 = exceptionTableEntry.getCatchType();
                    CharOperation.replace(catchType2, '/', '.');
                } else {
                    catchType2 = ANY_EXCEPTION;
                }
                buffer.append(Messages.bind(Messages.classfileformat_exceptiontableentry, new String[]{Integer.toString(exceptionTableEntry.getStartPC()), Integer.toString(exceptionTableEntry.getEndPC()), Integer.toString(exceptionTableEntry.getHandlerPC()), new String(catchType2)}));
                this.writeNewLine(buffer, lineSeparator, tabNumberForExceptionAttribute + 1);
                ++i;
            }
            IExceptionTableEntry exceptionTableEntry = exceptionTableEntries[exceptionTableLength - 1];
            if (exceptionTableEntry.getCatchTypeIndex() != 0) {
                catchType = exceptionTableEntry.getCatchType();
                CharOperation.replace(catchType, '/', '.');
            } else {
                catchType = ANY_EXCEPTION;
            }
            buffer.append(Messages.bind(Messages.classfileformat_exceptiontableentry, new String[]{Integer.toString(exceptionTableEntry.getStartPC()), Integer.toString(exceptionTableEntry.getEndPC()), Integer.toString(exceptionTableEntry.getHandlerPC()), new String(catchType)}));
            this.writeNewLine(buffer, lineSeparator, 0);
        }
        int n = lineAttributeLength = (lineNumberAttribute = codeAttribute.getLineNumberAttribute()) == null ? 0 : lineNumberAttribute.getLineNumberTableLength();
        if (lineAttributeLength != 0) {
            int tabNumberForLineAttribute = tabNumber + 2;
            this.dumpTab(tabNumberForLineAttribute, buffer);
            buffer.append(Messages.disassembler_linenumberattributeheader);
            this.writeNewLine(buffer, lineSeparator, tabNumberForLineAttribute + 1);
            int[][] lineattributesEntries = lineNumberAttribute.getLineNumberTable();
            int i = 0;
            while (i < lineAttributeLength - 1) {
                buffer.append(Messages.bind(Messages.classfileformat_linenumbertableentry, new String[]{Integer.toString(lineattributesEntries[i][0]), Integer.toString(lineattributesEntries[i][1])}));
                this.writeNewLine(buffer, lineSeparator, tabNumberForLineAttribute + 1);
                ++i;
            }
            buffer.append(Messages.bind(Messages.classfileformat_linenumbertableentry, new String[]{Integer.toString(lineattributesEntries[lineAttributeLength - 1][0]), Integer.toString(lineattributesEntries[lineAttributeLength - 1][1])}));
        }
        int n2 = localVariableAttributeLength = (localVariableAttribute = codeAttribute.getLocalVariableAttribute()) == null ? 0 : localVariableAttribute.getLocalVariableTableLength();
        if (localVariableAttributeLength != 0) {
            int tabNumberForLocalVariableAttribute = tabNumber + 2;
            this.writeNewLine(buffer, lineSeparator, tabNumberForLocalVariableAttribute);
            buffer.append(Messages.disassembler_localvariabletableattributeheader);
            this.writeNewLine(buffer, lineSeparator, tabNumberForLocalVariableAttribute + 1);
            ILocalVariableTableEntry[] localVariableTableEntries = localVariableAttribute.getLocalVariableTable();
            int i = 0;
            while (i < localVariableAttributeLength - 1) {
                ILocalVariableTableEntry localVariableTableEntry = localVariableTableEntries[i];
                int index = localVariableTableEntry.getIndex();
                int startPC = localVariableTableEntry.getStartPC();
                int length = localVariableTableEntry.getLength();
                char[] typeName = Signature.toCharArray(localVariableTableEntry.getDescriptor());
                CharOperation.replace(typeName, '/', '.');
                buffer.append(Messages.bind(Messages.classfileformat_localvariabletableentry, new String[]{Integer.toString(startPC), Integer.toString(startPC + length), new String(localVariableTableEntry.getName()), Integer.toString(index), new String(this.returnClassName(typeName, '.', mode))}));
                this.writeNewLine(buffer, lineSeparator, tabNumberForLocalVariableAttribute + 1);
                ++i;
            }
            ILocalVariableTableEntry localVariableTableEntry = localVariableTableEntries[localVariableAttributeLength - 1];
            int index = localVariableTableEntry.getIndex();
            int startPC = localVariableTableEntry.getStartPC();
            int length = localVariableTableEntry.getLength();
            char[] typeName = Signature.toCharArray(localVariableTableEntry.getDescriptor());
            CharOperation.replace(typeName, '/', '.');
            buffer.append(Messages.bind(Messages.classfileformat_localvariabletableentry, new String[]{Integer.toString(startPC), Integer.toString(startPC + length), new String(localVariableTableEntry.getName()), Integer.toString(index), new String(this.returnClassName(typeName, '.', mode))}));
        }
        int n3 = localVariableTypeTableLength = (localVariableTypeAttribute = this.getLocalVariableTypeAttribute(codeAttribute)) == null ? 0 : localVariableTypeAttribute.getLocalVariableTypeTableLength();
        if (localVariableTypeTableLength != 0) {
            int tabNumberForLocalVariableAttribute = tabNumber + 2;
            this.writeNewLine(buffer, lineSeparator, tabNumberForLocalVariableAttribute);
            buffer.append(Messages.disassembler_localvariabletypetableattributeheader);
            this.writeNewLine(buffer, lineSeparator, tabNumberForLocalVariableAttribute + 1);
            ILocalVariableTypeTableEntry[] localVariableTypeTableEntries = localVariableTypeAttribute.getLocalVariableTypeTable();
            int i = 0;
            while (i < localVariableTypeTableLength - 1) {
                ILocalVariableTypeTableEntry localVariableTypeTableEntry = localVariableTypeTableEntries[i];
                int index = localVariableTypeTableEntry.getIndex();
                int startPC = localVariableTypeTableEntry.getStartPC();
                int length = localVariableTypeTableEntry.getLength();
                char[] typeName = Signature.toCharArray(localVariableTypeTableEntry.getSignature());
                CharOperation.replace(typeName, '/', '.');
                buffer.append(Messages.bind(Messages.classfileformat_localvariabletableentry, new String[]{Integer.toString(startPC), Integer.toString(startPC + length), new String(localVariableTypeTableEntry.getName()), Integer.toString(index), new String(this.returnClassName(typeName, '.', mode))}));
                this.writeNewLine(buffer, lineSeparator, tabNumberForLocalVariableAttribute + 1);
                ++i;
            }
            ILocalVariableTypeTableEntry localVariableTypeTableEntry = localVariableTypeTableEntries[localVariableTypeTableLength - 1];
            int index = localVariableTypeTableEntry.getIndex();
            int startPC = localVariableTypeTableEntry.getStartPC();
            int length = localVariableTypeTableEntry.getLength();
            char[] typeName = Signature.toCharArray(localVariableTypeTableEntry.getSignature());
            CharOperation.replace(typeName, '/', '.');
            buffer.append(Messages.bind(Messages.classfileformat_localvariabletableentry, new String[]{Integer.toString(startPC), Integer.toString(startPC + length), new String(localVariableTypeTableEntry.getName()), Integer.toString(index), new String(this.returnClassName(typeName, '.', mode))}));
        }
    }

    private void disassemble(IConstantPool constantPool, StringBuffer buffer, String lineSeparator, int tabNumber) {
        this.writeNewLine(buffer, lineSeparator, tabNumber);
        int length = constantPool.getConstantPoolCount();
        buffer.append(Messages.disassembler_constantpoolheader);
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        int i = 1;
        while (i < length) {
            IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(i);
            switch (constantPool.getEntryKind(i)) {
                case 7: {
                    buffer.append(Messages.bind(Messages.disassembler_constantpool_class, new String[]{Integer.toString(i), Integer.toString(constantPoolEntry.getClassInfoNameIndex()), new String(constantPoolEntry.getClassInfoName())}));
                    break;
                }
                case 6: {
                    buffer.append(Messages.bind(Messages.disassembler_constantpool_double, new String[]{Integer.toString(i), Double.toString(constantPoolEntry.getDoubleValue())}));
                    break;
                }
                case 9: {
                    buffer.append(Messages.bind(Messages.disassembler_constantpool_fieldref, new String[]{Integer.toString(i), Integer.toString(constantPoolEntry.getClassIndex()), Integer.toString(constantPoolEntry.getNameAndTypeIndex()), new String(constantPoolEntry.getClassName()), new String(constantPoolEntry.getFieldName()), new String(constantPoolEntry.getFieldDescriptor())}));
                    break;
                }
                case 4: {
                    buffer.append(Messages.bind(Messages.disassembler_constantpool_float, new String[]{Integer.toString(i), Float.toString(constantPoolEntry.getFloatValue())}));
                    break;
                }
                case 3: {
                    buffer.append(Messages.bind(Messages.disassembler_constantpool_integer, new String[]{Integer.toString(i), Integer.toString(constantPoolEntry.getIntegerValue())}));
                    break;
                }
                case 11: {
                    buffer.append(Messages.bind(Messages.disassembler_constantpool_interfacemethodref, new String[]{Integer.toString(i), Integer.toString(constantPoolEntry.getClassIndex()), Integer.toString(constantPoolEntry.getNameAndTypeIndex()), new String(constantPoolEntry.getClassName()), new String(constantPoolEntry.getMethodName()), new String(constantPoolEntry.getMethodDescriptor())}));
                    break;
                }
                case 5: {
                    buffer.append(Messages.bind(Messages.disassembler_constantpool_long, new String[]{Integer.toString(i), Long.toString(constantPoolEntry.getLongValue())}));
                    break;
                }
                case 10: {
                    buffer.append(Messages.bind(Messages.disassembler_constantpool_methodref, new String[]{Integer.toString(i), Integer.toString(constantPoolEntry.getClassIndex()), Integer.toString(constantPoolEntry.getNameAndTypeIndex()), new String(constantPoolEntry.getClassName()), new String(constantPoolEntry.getMethodName()), new String(constantPoolEntry.getMethodDescriptor())}));
                    break;
                }
                case 12: {
                    int nameIndex = constantPoolEntry.getNameAndTypeInfoNameIndex();
                    int typeIndex = constantPoolEntry.getNameAndTypeInfoDescriptorIndex();
                    IConstantPoolEntry entry = constantPool.decodeEntry(nameIndex);
                    char[] nameValue = entry.getUtf8Value();
                    entry = constantPool.decodeEntry(typeIndex);
                    char[] typeValue = entry.getUtf8Value();
                    buffer.append(Messages.bind(Messages.disassembler_constantpool_name_and_type, new String[]{Integer.toString(i), Integer.toString(nameIndex), Integer.toString(typeIndex), String.valueOf(nameValue), String.valueOf(typeValue)}));
                    break;
                }
                case 8: {
                    buffer.append(Messages.bind(Messages.disassembler_constantpool_string, new String[]{Integer.toString(i), Integer.toString(constantPoolEntry.getStringIndex()), constantPoolEntry.getStringValue()}));
                    break;
                }
                case 1: {
                    buffer.append(Messages.bind(Messages.disassembler_constantpool_utf8, new String[]{Integer.toString(i), new String(constantPoolEntry.getUtf8Value())}));
                }
            }
            if (i < length - 1) {
                this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
            }
            ++i;
        }
    }

    private void disassemble(IEnclosingMethodAttribute enclosingMethodAttribute, StringBuffer buffer, String lineSeparator, int tabNumber) {
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Messages.disassembler_enclosingmethodheader);
        buffer.append(Messages.disassembler_constantpoolindex).append(enclosingMethodAttribute.getEnclosingClassIndex()).append(" ").append(Messages.disassembler_constantpoolindex).append(enclosingMethodAttribute.getMethodNameAndTypeIndex()).append(" ").append(enclosingMethodAttribute.getEnclosingClass());
        if (enclosingMethodAttribute.getMethodNameAndTypeIndex() != 0) {
            buffer.append(".").append(enclosingMethodAttribute.getMethodName()).append(enclosingMethodAttribute.getMethodDescriptor());
        }
    }

    private void disassemble(IFieldInfo fieldInfo, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        this.writeNewLine(buffer, lineSeparator, tabNumber);
        char[] fieldDescriptor = fieldInfo.getDescriptor();
        IClassFileAttribute classFileAttribute = Util.getAttribute(fieldInfo, IAttributeNamesConstants.SIGNATURE);
        ISignatureAttribute signatureAttribute = (ISignatureAttribute)classFileAttribute;
        if (this.checkMode(mode, 5)) {
            buffer.append(Messages.bind(Messages.classfileformat_fieldddescriptor, new String[]{Integer.toString(fieldInfo.getDescriptorIndex()), new String(fieldDescriptor)}));
            if (fieldInfo.isDeprecated()) {
                buffer.append(Messages.disassembler_deprecated);
            }
            this.writeNewLine(buffer, lineSeparator, tabNumber);
            if (signatureAttribute != null) {
                buffer.append(Messages.bind(Messages.disassembler_signatureattributeheader, new String(signatureAttribute.getSignature())));
                this.writeNewLine(buffer, lineSeparator, tabNumber);
            }
        }
        IClassFileAttribute runtimeVisibleAnnotationsAttribute = Util.getAttribute(fieldInfo, IAttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS);
        IClassFileAttribute runtimeInvisibleAnnotationsAttribute = Util.getAttribute(fieldInfo, IAttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS);
        if (this.checkMode(mode, 1)) {
            if (runtimeInvisibleAnnotationsAttribute != null) {
                this.disassembleAsModifier((IRuntimeInvisibleAnnotationsAttribute)runtimeInvisibleAnnotationsAttribute, buffer, lineSeparator, tabNumber + 1);
                this.writeNewLine(buffer, lineSeparator, tabNumber);
            }
            if (runtimeVisibleAnnotationsAttribute != null) {
                this.disassembleAsModifier((IRuntimeVisibleAnnotationsAttribute)runtimeVisibleAnnotationsAttribute, buffer, lineSeparator, tabNumber + 1);
                this.writeNewLine(buffer, lineSeparator, tabNumber);
            }
        }
        this.decodeModifiersForField(buffer, fieldInfo.getAccessFlags());
        if (fieldInfo.isSynthetic()) {
            buffer.append("synthetic");
            buffer.append(Messages.disassembler_space);
        }
        buffer.append(this.getSignatureForField(fieldDescriptor));
        buffer.append(' ');
        buffer.append(new String(fieldInfo.getName()));
        IConstantValueAttribute constantValueAttribute = fieldInfo.getConstantValueAttribute();
        if (constantValueAttribute != null) {
            buffer.append(Messages.disassembler_fieldhasconstant);
            IConstantPoolEntry constantPoolEntry = constantValueAttribute.getConstantValue();
            switch (constantPoolEntry.getKind()) {
                case 5: {
                    buffer.append(String.valueOf(constantPoolEntry.getLongValue()) + "L");
                    break;
                }
                case 4: {
                    buffer.append(String.valueOf(constantPoolEntry.getFloatValue()) + "f");
                    break;
                }
                case 6: {
                    buffer.append(constantPoolEntry.getDoubleValue());
                    break;
                }
                case 3: {
                    switch (fieldDescriptor[0]) {
                        case 'C': {
                            buffer.append("'" + (char)constantPoolEntry.getIntegerValue() + "'");
                            break;
                        }
                        case 'Z': {
                            buffer.append(constantPoolEntry.getIntegerValue() == 1 ? "true" : "false");
                            break;
                        }
                        case 'B': {
                            buffer.append(constantPoolEntry.getIntegerValue());
                            break;
                        }
                        case 'S': {
                            buffer.append(constantPoolEntry.getIntegerValue());
                            break;
                        }
                        case 'I': {
                            buffer.append(constantPoolEntry.getIntegerValue());
                        }
                    }
                    break;
                }
                case 8: {
                    buffer.append("\"" + this.decodeStringValue(constantPoolEntry.getStringValue()) + "\"");
                }
            }
        }
        buffer.append(Messages.disassembler_endoffieldheader);
        if (this.checkMode(mode, 4)) {
            IClassFileAttribute[] attributes = fieldInfo.getAttributes();
            int length = attributes.length;
            if (length != 0) {
                int i = 0;
                while (i < length) {
                    IClassFileAttribute attribute = attributes[i];
                    if (attribute != constantValueAttribute && attribute != signatureAttribute && attribute != runtimeInvisibleAnnotationsAttribute && attribute != runtimeVisibleAnnotationsAttribute && !CharOperation.equals(attribute.getAttributeName(), IAttributeNamesConstants.DEPRECATED) && !CharOperation.equals(attribute.getAttributeName(), IAttributeNamesConstants.SYNTHETIC)) {
                        this.disassemble(attribute, buffer, lineSeparator, tabNumber);
                    }
                    ++i;
                }
            }
            if (runtimeVisibleAnnotationsAttribute != null) {
                this.disassemble((IRuntimeVisibleAnnotationsAttribute)runtimeVisibleAnnotationsAttribute, buffer, lineSeparator, tabNumber);
            }
            if (runtimeInvisibleAnnotationsAttribute != null) {
                this.disassemble((IRuntimeInvisibleAnnotationsAttribute)runtimeInvisibleAnnotationsAttribute, buffer, lineSeparator, tabNumber);
            }
        }
    }

    private void disassemble(IInnerClassesAttribute innerClassesAttribute, StringBuffer buffer, String lineSeparator, int tabNumber) {
        int accessFlags;
        int innerNameIndex;
        int outerClassNameIndex;
        int innerClassNameIndex;
        IInnerClassesAttributeEntry innerClassesAttributeEntry;
        this.writeNewLine(buffer, lineSeparator, tabNumber);
        buffer.append(Messages.disassembler_innerattributesheader);
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        IInnerClassesAttributeEntry[] innerClassesAttributeEntries = innerClassesAttribute.getInnerClassAttributesEntries();
        int length = innerClassesAttributeEntries.length;
        int i = 0;
        while (i < length - 1) {
            innerClassesAttributeEntry = innerClassesAttributeEntries[i];
            innerClassNameIndex = innerClassesAttributeEntry.getInnerClassNameIndex();
            outerClassNameIndex = innerClassesAttributeEntry.getOuterClassNameIndex();
            innerNameIndex = innerClassesAttributeEntry.getInnerNameIndex();
            accessFlags = innerClassesAttributeEntry.getAccessFlags();
            buffer.append(Messages.disassembler_openinnerclassentry).append(Messages.disassembler_inner_class_info_name).append(Messages.disassembler_constantpoolindex).append(innerClassNameIndex);
            if (innerClassNameIndex != 0) {
                buffer.append(Messages.disassembler_space).append(innerClassesAttributeEntry.getInnerClassName());
            }
            buffer.append(Messages.disassembler_comma).append(Messages.disassembler_space).append(Messages.disassembler_outer_class_info_name).append(Messages.disassembler_constantpoolindex).append(outerClassNameIndex);
            if (outerClassNameIndex != 0) {
                buffer.append(Messages.disassembler_space).append(innerClassesAttributeEntry.getOuterClassName());
            }
            this.writeNewLine(buffer, lineSeparator, tabNumber);
            this.dumpTab(tabNumber, buffer);
            buffer.append(Messages.disassembler_space);
            buffer.append(Messages.disassembler_inner_name).append(Messages.disassembler_constantpoolindex).append(innerNameIndex);
            if (innerNameIndex != 0) {
                buffer.append(Messages.disassembler_space).append(innerClassesAttributeEntry.getInnerName());
            }
            buffer.append(Messages.disassembler_comma).append(Messages.disassembler_space).append(Messages.disassembler_inner_accessflags).append(accessFlags).append(Messages.disassembler_space);
            this.decodeModifiersForInnerClasses(buffer, accessFlags);
            buffer.append(Messages.disassembler_closeinnerclassentry).append(Messages.disassembler_comma);
            this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
            ++i;
        }
        innerClassesAttributeEntry = innerClassesAttributeEntries[length - 1];
        innerClassNameIndex = innerClassesAttributeEntry.getInnerClassNameIndex();
        outerClassNameIndex = innerClassesAttributeEntry.getOuterClassNameIndex();
        innerNameIndex = innerClassesAttributeEntry.getInnerNameIndex();
        accessFlags = innerClassesAttributeEntry.getAccessFlags();
        buffer.append(Messages.disassembler_openinnerclassentry).append(Messages.disassembler_inner_class_info_name).append(Messages.disassembler_constantpoolindex).append(innerClassNameIndex);
        if (innerClassNameIndex != 0) {
            buffer.append(Messages.disassembler_space).append(innerClassesAttributeEntry.getInnerClassName());
        }
        buffer.append(Messages.disassembler_comma).append(Messages.disassembler_space).append(Messages.disassembler_outer_class_info_name).append(Messages.disassembler_constantpoolindex).append(outerClassNameIndex);
        if (outerClassNameIndex != 0) {
            buffer.append(Messages.disassembler_space).append(innerClassesAttributeEntry.getOuterClassName());
        }
        this.writeNewLine(buffer, lineSeparator, tabNumber);
        this.dumpTab(tabNumber, buffer);
        buffer.append(Messages.disassembler_space);
        buffer.append(Messages.disassembler_inner_name).append(Messages.disassembler_constantpoolindex).append(innerNameIndex);
        if (innerNameIndex != 0) {
            buffer.append(Messages.disassembler_space).append(innerClassesAttributeEntry.getInnerName());
        }
        buffer.append(Messages.disassembler_comma).append(Messages.disassembler_space).append(Messages.disassembler_inner_accessflags).append(accessFlags).append(Messages.disassembler_space);
        this.decodeModifiersForInnerClasses(buffer, accessFlags);
        buffer.append(Messages.disassembler_closeinnerclassentry);
    }

    private void disassemble(int index, IParameterAnnotation parameterAnnotation, StringBuffer buffer, String lineSeparator, int tabNumber) {
        IAnnotation[] annotations = parameterAnnotation.getAnnotations();
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Messages.bind(Messages.disassembler_parameterannotationentrystart, new String[]{Integer.toString(index), Integer.toString(annotations.length)}));
        int i = 0;
        int max = annotations.length;
        while (i < max) {
            this.disassemble(annotations[i], buffer, lineSeparator, tabNumber + 1);
            ++i;
        }
    }

    private void disassemble(IRuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute, StringBuffer buffer, String lineSeparator, int tabNumber) {
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Messages.disassembler_runtimeinvisibleannotationsattributeheader);
        IAnnotation[] annotations = runtimeInvisibleAnnotationsAttribute.getAnnotations();
        int i = 0;
        int max = annotations.length;
        while (i < max) {
            this.disassemble(annotations[i], buffer, lineSeparator, tabNumber + 1);
            ++i;
        }
    }

    private void disassemble(IRuntimeInvisibleParameterAnnotationsAttribute runtimeInvisibleParameterAnnotationsAttribute, StringBuffer buffer, String lineSeparator, int tabNumber) {
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Messages.disassembler_runtimeinvisibleparameterannotationsattributeheader);
        IParameterAnnotation[] parameterAnnotations = runtimeInvisibleParameterAnnotationsAttribute.getParameterAnnotations();
        int i = 0;
        int max = parameterAnnotations.length;
        while (i < max) {
            this.disassemble(i, parameterAnnotations[i], buffer, lineSeparator, tabNumber + 1);
            ++i;
        }
    }

    private void disassemble(IRuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute, StringBuffer buffer, String lineSeparator, int tabNumber) {
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Messages.disassembler_runtimevisibleannotationsattributeheader);
        IAnnotation[] annotations = runtimeVisibleAnnotationsAttribute.getAnnotations();
        int i = 0;
        int max = annotations.length;
        while (i < max) {
            this.disassemble(annotations[i], buffer, lineSeparator, tabNumber + 1);
            ++i;
        }
    }

    private void disassemble(IRuntimeVisibleParameterAnnotationsAttribute runtimeVisibleParameterAnnotationsAttribute, StringBuffer buffer, String lineSeparator, int tabNumber) {
        this.writeNewLine(buffer, lineSeparator, tabNumber + 1);
        buffer.append(Messages.disassembler_runtimevisibleparameterannotationsattributeheader);
        IParameterAnnotation[] parameterAnnotations = runtimeVisibleParameterAnnotationsAttribute.getParameterAnnotations();
        int i = 0;
        int max = parameterAnnotations.length;
        while (i < max) {
            this.disassemble(i, parameterAnnotations[i], buffer, lineSeparator, tabNumber + 1);
            ++i;
        }
    }

    private void disassembleAsModifier(IAnnotation annotation, StringBuffer buffer, String lineSeparator, int tabNumber) {
        char[] typeName = CharOperation.replaceOnCopy(annotation.getTypeName(), '/', '.');
        buffer.append('@').append(Signature.toCharArray(typeName)).append('(');
        IAnnotationComponent[] components = annotation.getComponents();
        int i = 0;
        int max = components.length;
        while (i < max) {
            if (i > 0) {
                buffer.append(',');
                this.writeNewLine(buffer, lineSeparator, tabNumber);
            }
            this.disassembleAsModifier(components[i], buffer, lineSeparator, tabNumber + 1);
            ++i;
        }
        buffer.append(')');
    }

    private void disassembleAsModifier(IAnnotationComponent annotationComponent, StringBuffer buffer, String lineSeparator, int tabNumber) {
        buffer.append(annotationComponent.getComponentName()).append('=');
        this.disassembleAsModifier(annotationComponent.getComponentValue(), buffer, lineSeparator, tabNumber + 1);
    }

    private void disassembleAsModifier(IAnnotationComponentValue annotationComponentValue, StringBuffer buffer, String lineSeparator, int tabNumber) {
        switch (annotationComponentValue.getTag()) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                IConstantPoolEntry constantPoolEntry = annotationComponentValue.getConstantValue();
                String value = null;
                switch (constantPoolEntry.getKind()) {
                    case 5: {
                        value = String.valueOf(constantPoolEntry.getLongValue()) + "L";
                        break;
                    }
                    case 4: {
                        value = String.valueOf(constantPoolEntry.getFloatValue()) + "f";
                        break;
                    }
                    case 6: {
                        value = Double.toString(constantPoolEntry.getDoubleValue());
                        break;
                    }
                    case 3: {
                        switch (annotationComponentValue.getTag()) {
                            case 67: {
                                value = "'" + (char)constantPoolEntry.getIntegerValue() + "'";
                                break;
                            }
                            case 90: {
                                value = constantPoolEntry.getIntegerValue() == 1 ? "true" : "false";
                                break;
                            }
                            case 66: {
                                value = "(byte) " + constantPoolEntry.getIntegerValue();
                                break;
                            }
                            case 83: {
                                value = "(short) " + constantPoolEntry.getIntegerValue();
                                break;
                            }
                            case 73: {
                                value = "(int) " + constantPoolEntry.getIntegerValue();
                            }
                        }
                        break;
                    }
                    case 1: {
                        value = "\"" + this.decodeStringValue(constantPoolEntry.getUtf8Value()) + "\"";
                    }
                }
                buffer.append(value);
                break;
            }
            case 101: {
                char[] typeName = CharOperation.replaceOnCopy(annotationComponentValue.getEnumConstantTypeName(), '/', '.');
                char[] constantName = annotationComponentValue.getEnumConstantName();
                buffer.append(Signature.toCharArray(typeName)).append('.').append(constantName);
                break;
            }
            case 99: {
                IConstantPoolEntry constantPoolEntry = annotationComponentValue.getClassInfo();
                char[] className = CharOperation.replaceOnCopy(constantPoolEntry.getUtf8Value(), '/', '.');
                buffer.append(Signature.toCharArray(className));
                break;
            }
            case 64: {
                IAnnotation annotation = annotationComponentValue.getAnnotationValue();
                this.disassembleAsModifier(annotation, buffer, lineSeparator, tabNumber + 1);
                break;
            }
            case 91: {
                IAnnotationComponentValue[] annotationComponentValues = annotationComponentValue.getAnnotationComponentValues();
                buffer.append('{');
                int i = 0;
                int max = annotationComponentValues.length;
                while (i < max) {
                    if (i > 0) {
                        buffer.append(',');
                    }
                    this.disassembleAsModifier(annotationComponentValues[i], buffer, lineSeparator, tabNumber + 1);
                    ++i;
                }
                buffer.append('}');
            }
        }
    }

    private void disassembleAsModifier(IAnnotationDefaultAttribute annotationDefaultAttribute, StringBuffer buffer, String lineSeparator, int tabNumber) {
        IAnnotationComponentValue componentValue = annotationDefaultAttribute.getMemberValue();
        this.disassembleAsModifier(componentValue, buffer, lineSeparator, tabNumber + 1);
    }

    private void disassembleAsModifier(IRuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute, StringBuffer buffer, String lineSeparator, int tabNumber) {
        IAnnotation[] annotations = runtimeInvisibleAnnotationsAttribute.getAnnotations();
        int i = 0;
        int max = annotations.length;
        while (i < max) {
            this.disassembleAsModifier(annotations[i], buffer, lineSeparator, tabNumber + 1);
            ++i;
        }
    }

    private void disassembleAsModifier(IRuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute, StringBuffer buffer, String lineSeparator, int tabNumber) {
        IAnnotation[] annotations = runtimeVisibleAnnotationsAttribute.getAnnotations();
        int i = 0;
        int max = annotations.length;
        while (i < max) {
            this.disassembleAsModifier(annotations[i], buffer, lineSeparator, tabNumber + 1);
            ++i;
        }
    }

    private void disassembleTypeMembers(IClassFileReader classFileReader, StringBuffer buffer, String lineSeparator, int tabNumber, int mode) {
        IFieldInfo[] fields = classFileReader.getFieldInfos();
        int i = 0;
        int max = fields.length;
        while (i < max) {
            this.writeNewLine(buffer, lineSeparator, tabNumber);
            this.disassemble(fields[i], buffer, lineSeparator, tabNumber, mode);
            ++i;
        }
        IMethodInfo[] methods = classFileReader.getMethodInfos();
        int i2 = 0;
        int max2 = methods.length;
        while (i2 < max2) {
            this.writeNewLine(buffer, lineSeparator, tabNumber);
            this.disassemble(classFileReader, methods[i2], buffer, lineSeparator, tabNumber, mode);
            ++i2;
        }
    }

    private final void dumpTab(int tabNumber, StringBuffer buffer) {
        int i = 0;
        while (i < tabNumber) {
            buffer.append(Messages.disassembler_indentation);
            ++i;
        }
    }

    public String getDescription() {
        return Messages.disassembler_description;
    }

    private IEnclosingMethodAttribute getEnclosingMethodAttribute(IClassFileReader classFileReader) {
        IClassFileAttribute[] attributes = classFileReader.getAttributes();
        int i = 0;
        int max = attributes.length;
        while (i < max) {
            if (CharOperation.equals(attributes[i].getAttributeName(), IAttributeNamesConstants.ENCLOSING_METHOD)) {
                return (IEnclosingMethodAttribute)attributes[i];
            }
            ++i;
        }
        return null;
    }

    private ILocalVariableTableEntry getEntryFor(int localIndex, ILocalVariableTableEntry[] entries) {
        int i = 0;
        int max = entries.length;
        while (i < max) {
            ILocalVariableTableEntry entry = entries[i];
            if (localIndex == entry.getIndex()) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    private ILocalVariableTypeTableAttribute getLocalVariableTypeAttribute(ICodeAttribute codeAttribute) {
        IClassFileAttribute[] attributes = codeAttribute.getAttributes();
        int i = 0;
        int max = attributes.length;
        while (i < max) {
            if (CharOperation.equals(attributes[i].getAttributeName(), IAttributeNamesConstants.LOCAL_VARIABLE_TYPE_TABLE)) {
                return (ILocalVariableTypeTableAttribute)attributes[i];
            }
            ++i;
        }
        return null;
    }

    private char[][] getParameterNames(char[] methodDescriptor, ICodeAttribute codeAttribute, int accessFlags) {
        int paramCount = Signature.getParameterCount(methodDescriptor);
        char[][] parameterNames = new char[paramCount][];
        if (codeAttribute != null) {
            ILocalVariableAttribute localVariableAttribute = codeAttribute.getLocalVariableAttribute();
            if (localVariableAttribute != null) {
                ILocalVariableTableEntry[] entries = localVariableAttribute.getLocalVariableTable();
                int startingIndex = (accessFlags & 8) != 0 ? 0 : 1;
                int i = 0;
                while (i < paramCount) {
                    ILocalVariableTableEntry searchedEntry = this.getEntryFor(startingIndex + i, entries);
                    parameterNames[i] = searchedEntry != null ? searchedEntry.getName() : Messages.disassembler_parametername.toCharArray();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < paramCount) {
                    parameterNames[i] = Messages.disassembler_parametername.toCharArray();
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < paramCount) {
                parameterNames[i] = Messages.disassembler_parametername.toCharArray();
                ++i;
            }
        }
        return parameterNames;
    }

    private char[] getSignatureForField(char[] fieldDescriptor) {
        char[] newFieldDescriptor = CharOperation.replaceOnCopy(fieldDescriptor, '/', '.');
        newFieldDescriptor = CharOperation.replaceOnCopy(newFieldDescriptor, '$', '~');
        char[] fieldDescriptorSignature = Signature.toCharArray(newFieldDescriptor);
        CharOperation.replace(fieldDescriptorSignature, '~', '$');
        return fieldDescriptorSignature;
    }

    private boolean isDeprecated(IClassFileReader classFileReader) {
        IClassFileAttribute[] attributes = classFileReader.getAttributes();
        int i = 0;
        int max = attributes.length;
        while (i < max) {
            if (CharOperation.equals(attributes[i].getAttributeName(), IAttributeNamesConstants.DEPRECATED)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isSynthetic(IClassFileReader classFileReader) {
        int flags = classFileReader.getAccessFlags();
        if ((flags & 0x1000) != 0) {
            return true;
        }
        IClassFileAttribute[] attributes = classFileReader.getAttributes();
        int i = 0;
        int max = attributes.length;
        while (i < max) {
            if (CharOperation.equals(attributes[i].getAttributeName(), IAttributeNamesConstants.SYNTHETIC)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkMode(int mode, int flag) {
        return (mode & flag) != 0;
    }

    private boolean isCompact(int mode) {
        return (mode & 8) != 0;
    }

    private String returnClassName(char[] classInfoName, char separator, int mode) {
        if (classInfoName.length == 0) {
            return EMPTY_CLASS_NAME;
        }
        if (this.isCompact(mode)) {
            int lastIndexOfSlash = CharOperation.lastIndexOf(separator, classInfoName);
            if (lastIndexOfSlash != -1) {
                return new String(classInfoName, lastIndexOfSlash + 1, classInfoName.length - lastIndexOfSlash - 1);
            }
            return new String(classInfoName);
        }
        return new String(classInfoName);
    }

    private void writeNewLine(StringBuffer buffer, String lineSeparator, int tabNumber) {
        buffer.append(lineSeparator);
        this.dumpTab(tabNumber, buffer);
    }
}

