/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.performance;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.jackrabbit.mk.MicroKernelFactory;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mk.core.MicroKernelImpl;
import org.apache.jackrabbit.mk.index.IndexWrapper;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.core.ContentRepositoryImpl;
import org.apache.jackrabbit.oak.jcr.RepositoryImpl;
import org.apache.jackrabbit.oak.performance.AbstractTest;
import org.apache.jackrabbit.oak.performance.ConcurrentReadTest;
import org.apache.jackrabbit.oak.performance.ConcurrentReadWriteTest;
import org.apache.jackrabbit.oak.performance.CreateManyChildNodesTest;
import org.apache.jackrabbit.oak.performance.DescendantSearchTest;
import org.apache.jackrabbit.oak.performance.LoginLogoutTest;
import org.apache.jackrabbit.oak.performance.LoginTest;
import org.apache.jackrabbit.oak.performance.ReadPropertyTest;
import org.apache.jackrabbit.oak.performance.SQL2DescendantSearchTest;
import org.apache.jackrabbit.oak.performance.SQL2SearchTest;
import org.apache.jackrabbit.oak.performance.SetPropertyTest;
import org.apache.jackrabbit.oak.performance.SimpleSearchTest;
import org.apache.jackrabbit.oak.performance.SmallFileReadTest;
import org.apache.jackrabbit.oak.performance.SmallFileWriteTest;
import org.apache.jackrabbit.oak.performance.TransientManyChildNodesTest;
import org.apache.jackrabbit.oak.performance.UpdateManyChildNodesTest;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CompositeValidatorProvider;
import org.apache.jackrabbit.oak.spi.commit.ValidatingHook;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;

public abstract class AbstractPerformanceTest {
    private final int warmup = Integer.getInteger("oak.performanceTest.warmup", 0);
    private final int runtime = Integer.getInteger("oak.performanceTest.runtime", 100);
    private final Credentials credentials = new SimpleCredentials("admin", "admin".toCharArray());
    private final Pattern microKernelPattern = Pattern.compile(System.getProperty("mk", ".*"));
    private final Pattern testPattern = Pattern.compile(System.getProperty("only", ".*"));

    protected void testPerformance(String name, String microKernel) throws Exception {
        this.runTest(new LoginTest(), name, microKernel);
        this.runTest(new LoginLogoutTest(), name, microKernel);
        this.runTest(new ReadPropertyTest(), name, microKernel);
        this.runTest(new SetPropertyTest(), name, microKernel);
        this.runTest(new SmallFileReadTest(), name, microKernel);
        this.runTest(new SmallFileWriteTest(), name, microKernel);
        this.runTest(new ConcurrentReadTest(), name, microKernel);
        this.runTest(new ConcurrentReadWriteTest(), name, microKernel);
        this.runTest(new SimpleSearchTest(), name, microKernel);
        this.runTest(new SQL2SearchTest(), name, microKernel);
        this.runTest(new DescendantSearchTest(), name, microKernel);
        this.runTest(new SQL2DescendantSearchTest(), name, microKernel);
        this.runTest(new CreateManyChildNodesTest(), name, microKernel);
        this.runTest(new UpdateManyChildNodesTest(), name, microKernel);
        this.runTest(new TransientManyChildNodesTest(), name, microKernel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(AbstractTest test, String name, String microKernel) {
        if (this.microKernelPattern.matcher(microKernel).matches() && this.testPattern.matcher(test.toString()).matches()) {
            MicroKernel mk = null;
            try {
                mk = this.createMicroKernel(microKernel);
                RepositoryImpl repository = this.createRepository(mk);
                DescriptiveStatistics statistics = this.runTest(test, (Repository)repository);
                if (statistics.getN() > 0L) {
                    AbstractPerformanceTest.writeReport(test.toString(), name, microKernel, statistics);
                }
            }
            catch (RepositoryException re) {
                re.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (mk != null) {
                    MicroKernelFactory.disposeInstance((MicroKernel)mk);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DescriptiveStatistics runTest(AbstractTest test, Repository repository) throws Exception {
        DescriptiveStatistics statistics = new DescriptiveStatistics();
        test.setUp(repository, this.credentials);
        try {
            if (this.warmup > 0) {
                long warmupEnd = System.currentTimeMillis() + (long)this.warmup;
                while (System.currentTimeMillis() < warmupEnd) {
                    test.execute();
                }
            }
            long runtimeEnd = System.currentTimeMillis() + (long)this.runtime;
            while (System.currentTimeMillis() < runtimeEnd) {
                statistics.addValue((double)test.execute());
            }
        }
        finally {
            test.tearDown();
        }
        return statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeReport(String test, String name, String microKernel, DescriptiveStatistics statistics) throws IOException {
        File report = new File("target", test + "-" + microKernel + ".txt");
        boolean needsPrefix = !report.exists();
        PrintWriter writer = new PrintWriter((Writer)new FileWriterWithEncoding(report, "UTF-8", true));
        try {
            if (needsPrefix) {
                writer.format("# %-34.34s     min     10%%     50%%     90%%     max%n", test);
            }
            writer.format("%-36.36s  %6.0f  %6.0f  %6.0f  %6.0f  %6.0f%n", name, statistics.getMin(), statistics.getPercentile(10.0), statistics.getPercentile(50.0), statistics.getPercentile(90.0), statistics.getMax());
        }
        finally {
            writer.close();
        }
    }

    protected MicroKernel createMicroKernel(String microKernel) {
        return new MicroKernelImpl("target/mk-tck-" + System.currentTimeMillis());
    }

    protected RepositoryImpl createRepository(MicroKernel mk) {
        mk = new IndexWrapper(mk);
        ValidatingHook ve = new ValidatingHook((ValidatorProvider)new CompositeValidatorProvider(Collections.emptyList()));
        ContentRepositoryImpl contentRepository = new ContentRepositoryImpl(mk, null, (CommitHook)ve);
        return new RepositoryImpl((ContentRepository)contentRepository, null);
    }
}

