/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.blobs;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import java.io.IOException;
import org.apache.jackrabbit.mk.blobs.AbstractBlobStore;

public class MongoBlobStore
extends AbstractBlobStore {
    private static final String DB = "ds";
    private static final String DATASTORE_COLLECTION = "dataStore";
    private static final String DIGEST_FIELD = "digest";
    private static final String DATA_FIELD = "data";
    private Mongo con = new Mongo();
    private DB db = this.con.getDB("ds");
    private DBCollection dataStore;

    public MongoBlobStore() throws IOException {
        this.db.setWriteConcern(WriteConcern.SAFE);
        this.dataStore = this.db.getCollection(DATASTORE_COLLECTION);
        this.dataStore.ensureIndex((DBObject)new BasicDBObject(DIGEST_FIELD, (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    @Override
    protected byte[] readBlockFromBackend(AbstractBlobStore.BlockId id) {
        BasicDBObject key = new BasicDBObject(DIGEST_FIELD, (Object)id.digest);
        DBObject dataObject = this.dataStore.findOne((DBObject)key);
        return (byte[])dataObject.get(DATA_FIELD);
    }

    @Override
    protected void storeBlock(byte[] digest, int level, byte[] data) {
        BasicDBObject dataObject = new BasicDBObject(DIGEST_FIELD, (Object)digest);
        dataObject.append(DATA_FIELD, (Object)data);
        try {
            this.dataStore.insert(new DBObject[]{dataObject});
        }
        catch (MongoException.DuplicateKey ignore) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        this.con.close();
    }

    @Override
    public void startMark() throws Exception {
        this.markInUse();
    }

    @Override
    protected boolean isMarkEnabled() {
        return false;
    }

    @Override
    protected void mark(AbstractBlobStore.BlockId id) throws Exception {
    }

    @Override
    public int sweep() throws Exception {
        return 0;
    }
}

