/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.mk.core.Repository;
import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mk.json.JsopTokenizer;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.CommitBuilder;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.NodeState;
import org.apache.jackrabbit.mk.model.PropertyState;
import org.apache.jackrabbit.mk.model.StoredCommit;
import org.apache.jackrabbit.mk.model.TraversingNodeDiffHandler;
import org.apache.jackrabbit.mk.store.NotFoundException;
import org.apache.jackrabbit.mk.store.RevisionStore;
import org.apache.jackrabbit.mk.util.CommitGate;
import org.apache.jackrabbit.mk.util.PathUtils;
import org.apache.jackrabbit.mk.util.SimpleLRUCache;

public class MicroKernelImpl
implements MicroKernel {
    protected Repository rep;
    private final CommitGate gate = new CommitGate();
    private final Map<Id, String> diffCache = Collections.synchronizedMap(SimpleLRUCache.newInstance(100));

    public MicroKernelImpl(String homeDir) throws MicroKernelException {
        this.init(homeDir);
    }

    public MicroKernelImpl() {
        this(new Repository());
    }

    public MicroKernelImpl(Repository rep) {
        this.rep = rep;
    }

    protected void init(String homeDir) throws MicroKernelException {
        try {
            this.rep = new Repository(homeDir);
            this.rep.init();
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public void dispose() {
        this.gate.commit("end");
        if (this.rep != null) {
            try {
                this.rep.shutDown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.rep = null;
        }
        this.diffCache.clear();
    }

    @Override
    public String getHeadRevision() throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        return this.getHeadRevisionId().toString();
    }

    private Id getHeadRevisionId() throws MicroKernelException {
        try {
            return this.rep.getHeadRevision();
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public String getRevisions(long since, int maxEntries) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        maxEntries = maxEntries < 0 ? Integer.MAX_VALUE : maxEntries;
        ArrayList<StoredCommit> history = new ArrayList<StoredCommit>();
        try {
            StoredCommit commit = this.rep.getHeadCommit();
            while (commit != null && history.size() < maxEntries && commit.getCommitTS() >= since) {
                history.add(commit);
                Id commitId = commit.getParentId();
                if (commitId != null) {
                    commit = this.rep.getCommit(commitId);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
        JsopBuilder buff = new JsopBuilder().array();
        for (int i = history.size() - 1; i >= 0; --i) {
            StoredCommit commit = (StoredCommit)history.get(i);
            buff.object().key("id").value(commit.getId().toString()).key("ts").value(commit.getCommitTS()).endObject();
        }
        return buff.endArray().toString();
    }

    @Override
    public String waitForCommit(String oldHeadRevision, long maxWaitMillis) throws MicroKernelException, InterruptedException {
        return this.gate.waitForCommit(oldHeadRevision, maxWaitMillis);
    }

    @Override
    public String getJournal(String fromRevision, String toRevision, String filter) throws MicroKernelException {
        StoredCommit commit;
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id fromRevisionId = Id.fromString(fromRevision);
        Id toRevisionId = toRevision == null ? this.getHeadRevisionId() : Id.fromString(toRevision);
        ArrayList<StoredCommit> commits = new ArrayList<StoredCommit>();
        try {
            StoredCommit fromCommit;
            StoredCommit toCommit = this.rep.getCommit(toRevisionId);
            if (toRevisionId.equals(fromRevisionId)) {
                fromCommit = toCommit;
            } else {
                fromCommit = this.rep.getCommit(fromRevisionId);
                if (fromCommit.getCommitTS() > toCommit.getCommitTS()) {
                    return "[]";
                }
            }
            commit = toCommit;
            while (commit != null) {
                Id commitId;
                commits.add(commit);
                if (!commit.getId().equals(fromRevisionId) && (commitId = commit.getParentId()) != null) {
                    commit = this.rep.getCommit(commitId);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
        JsopBuilder commitBuff = new JsopBuilder().array();
        for (int i = commits.size() - 1; i >= 0; --i) {
            commit = (StoredCommit)commits.get(i);
            if (commit.getParentId() == null) continue;
            commitBuff.object().key("id").value(commit.getId().toString()).key("ts").value(commit.getCommitTS()).key("msg").value(commit.getMsg());
            String diff = this.diffCache.get(commit.getId());
            if (diff == null) {
                diff = this.diff(commit.getParentId(), commit.getId(), filter);
                this.diffCache.put(commit.getId(), diff);
            }
            commitBuff.key("changes").value(diff).endObject();
        }
        return commitBuff.endArray().toString();
    }

    @Override
    public String diff(String fromRevision, String toRevision, String filter) throws MicroKernelException {
        Id toRevisionId = toRevision == null ? this.getHeadRevisionId() : Id.fromString(toRevision);
        return this.diff(Id.fromString(fromRevision), toRevisionId, filter);
    }

    private String diff(Id fromRevisionId, Id toRevisionId, String filter) throws MicroKernelException {
        String path = "/";
        try {
            NodeState node2;
            NodeState node1;
            final JsopBuilder buff = new JsopBuilder();
            final RevisionStore rp = this.rep.getRevisionStore();
            final HashMap addedNodes = new HashMap();
            final HashMap removedNodes = new HashMap();
            try {
                node1 = this.rep.getNodeState(fromRevisionId, path);
            }
            catch (NotFoundException e) {
                node1 = null;
            }
            try {
                node2 = this.rep.getNodeState(toRevisionId, path);
            }
            catch (NotFoundException e) {
                node2 = null;
            }
            if (node1 == null) {
                if (node2 != null) {
                    buff.tag('+').key(path).object();
                    this.toJson(buff, node2, Integer.MAX_VALUE, 0, -1, false);
                    return buff.endObject().newline().toString();
                }
                throw new MicroKernelException("path doesn't exist in the specified revisions: " + path);
            }
            if (node2 == null) {
                buff.tag('-');
                buff.value(path);
                return buff.newline().toString();
            }
            TraversingNodeDiffHandler diffHandler = new TraversingNodeDiffHandler(){

                @Override
                public void propertyAdded(PropertyState after) {
                    buff.tag('+').key(PathUtils.concat(this.getCurrentPath(), after.getName())).encodedValue(after.getEncodedValue()).newline();
                }

                @Override
                public void propertyChanged(PropertyState before, PropertyState after) {
                    buff.tag('^').key(PathUtils.concat(this.getCurrentPath(), after.getName())).encodedValue(after.getEncodedValue()).newline();
                }

                @Override
                public void propertyDeleted(PropertyState before) {
                    buff.tag('^').key(PathUtils.concat(this.getCurrentPath(), before.getName())).value(null).newline();
                }

                @Override
                public void childNodeAdded(String name, NodeState after) {
                    addedNodes.put(rp.getId(after), PathUtils.concat(this.getCurrentPath(), name));
                    buff.tag('+').key(PathUtils.concat(this.getCurrentPath(), name)).object();
                    MicroKernelImpl.this.toJson(buff, after, Integer.MAX_VALUE, 0, -1, false);
                    buff.endObject().newline();
                }

                @Override
                public void childNodeDeleted(String name, NodeState before) {
                    removedNodes.put(rp.getId(before), PathUtils.concat(this.getCurrentPath(), name));
                    buff.tag('-');
                    buff.value(PathUtils.concat(this.getCurrentPath(), name));
                    buff.newline();
                }
            };
            diffHandler.start(node1, node2, path);
            addedNodes.keySet().retainAll(removedNodes.keySet());
            if (!addedNodes.isEmpty()) {
                removedNodes.keySet().retainAll(addedNodes.keySet());
                buff.resetWriter();
                diffHandler = new TraversingNodeDiffHandler(){

                    @Override
                    public void propertyAdded(PropertyState after) {
                        buff.tag('+').key(PathUtils.concat(this.getCurrentPath(), after.getName())).encodedValue(after.getEncodedValue()).newline();
                    }

                    @Override
                    public void propertyChanged(PropertyState before, PropertyState after) {
                        buff.tag('^').key(PathUtils.concat(this.getCurrentPath(), after.getName())).encodedValue(after.getEncodedValue()).newline();
                    }

                    @Override
                    public void propertyDeleted(PropertyState before) {
                        buff.tag('^').key(PathUtils.concat(this.getCurrentPath(), before.getName())).value(null).newline();
                    }

                    @Override
                    public void childNodeAdded(String name, NodeState after) {
                        if (addedNodes.containsKey(rp.getId(after))) {
                            return;
                        }
                        buff.tag('+').key(PathUtils.concat(this.getCurrentPath(), name)).object();
                        MicroKernelImpl.this.toJson(buff, after, Integer.MAX_VALUE, 0, -1, false);
                        buff.endObject().newline();
                    }

                    @Override
                    public void childNodeDeleted(String name, NodeState before) {
                        if (addedNodes.containsKey(rp.getId(before))) {
                            return;
                        }
                        buff.tag('-');
                        buff.value(PathUtils.concat(this.getCurrentPath(), name));
                        buff.newline();
                    }
                };
                diffHandler.start(node1, node2, path);
                for (Map.Entry entry : addedNodes.entrySet()) {
                    buff.tag('>').key((String)removedNodes.get(entry.getKey())).value((String)entry.getValue()).newline();
                }
            }
            return buff.toString();
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public boolean nodeExists(String path, String revision) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id revisionId = revision == null ? this.getHeadRevisionId() : Id.fromString(revision);
        return this.rep.nodeExists(revisionId, path);
    }

    @Override
    public long getChildNodeCount(String path, String revision) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id revisionId = revision == null ? this.getHeadRevisionId() : Id.fromString(revision);
        try {
            return this.rep.getNodeState(revisionId, path).getChildNodeCount();
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public String getNodes(String path, String revision) throws MicroKernelException {
        return this.getNodes(path, revision, 1, 0L, -1, null);
    }

    @Override
    public String getNodes(String path, String revision, int depth, long offset, int count, String filter) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id revisionId = revision == null ? this.getHeadRevisionId() : Id.fromString(revision);
        try {
            JsopBuilder buf = new JsopBuilder().object();
            this.toJson(buf, this.rep.getNodeState(revisionId, path), depth, (int)offset, count, true);
            return buf.endObject().toString();
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public String commit(String path, String jsonDiff, String revision, String message) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        if (path.length() > 0 && !PathUtils.isAbsolute(path)) {
            throw new IllegalArgumentException("absolute path expected: " + path);
        }
        Id revisionId = revision == null ? this.getHeadRevisionId() : Id.fromString(revision);
        try {
            int r;
            JsopTokenizer t = new JsopTokenizer(jsonDiff);
            CommitBuilder cb = this.rep.getCommitBuilder(revisionId, message);
            block9: while ((r = t.read()) != 0) {
                switch (r) {
                    case 43: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        t.read(58);
                        if (t.matches(123)) {
                            String nodePath = PathUtils.concat(path, subPath);
                            if (!PathUtils.isAbsolute(nodePath)) {
                                throw new Exception("absolute path expected: " + nodePath + ", pos: " + pos);
                            }
                            String parentPath = PathUtils.getParentPath(nodePath);
                            String nodeName = PathUtils.getName(nodePath);
                            LinkedList<AddNodeOperation> list = new LinkedList<AddNodeOperation>();
                            MicroKernelImpl.addNode(list, parentPath, nodeName, t);
                            for (AddNodeOperation op : list) {
                                cb.addNode(op.path, op.name, op.props);
                            }
                            continue block9;
                        }
                        String value = t.matches(5) ? null : t.readRawValue().trim();
                        String targetPath = PathUtils.concat(path, subPath);
                        if (!PathUtils.isAbsolute(targetPath)) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        String parentPath = PathUtils.getParentPath(targetPath);
                        String propName = PathUtils.getName(targetPath);
                        cb.setProperty(parentPath, propName, value);
                        break;
                    }
                    case 45: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        String targetPath = PathUtils.concat(path, subPath);
                        if (!PathUtils.isAbsolute(targetPath)) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        cb.removeNode(targetPath);
                        break;
                    }
                    case 94: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        t.read(58);
                        String value = t.matches(5) ? null : t.readRawValue().trim();
                        String targetPath = PathUtils.concat(path, subPath);
                        if (!PathUtils.isAbsolute(targetPath)) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        String parentPath = PathUtils.getParentPath(targetPath);
                        String propName = PathUtils.getName(targetPath);
                        cb.setProperty(parentPath, propName, value);
                        break;
                    }
                    case 62: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        String srcPath = PathUtils.concat(path, subPath);
                        if (!PathUtils.isAbsolute(srcPath)) {
                            throw new Exception("absolute path expected: " + srcPath + ", pos: " + pos);
                        }
                        t.read(58);
                        pos = t.getLastPos();
                        String targetPath = t.readString();
                        if (!PathUtils.isAbsolute(targetPath) && !PathUtils.isAbsolute(targetPath = PathUtils.concat(path, targetPath))) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        cb.moveNode(srcPath, targetPath);
                        break;
                    }
                    case 42: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        String srcPath = PathUtils.concat(path, subPath);
                        if (!PathUtils.isAbsolute(srcPath)) {
                            throw new Exception("absolute path expected: " + srcPath + ", pos: " + pos);
                        }
                        t.read(58);
                        pos = t.getLastPos();
                        String targetPath = t.readString();
                        if (!PathUtils.isAbsolute(targetPath) && !PathUtils.isAbsolute(targetPath = PathUtils.concat(path, targetPath))) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        cb.copyNode(srcPath, targetPath);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("token type: " + t.getTokenType()));
                    }
                }
            }
            Id newHead = cb.doCommit();
            if (!newHead.equals(revisionId)) {
                this.gate.commit(newHead.toString());
            }
            return newHead.toString();
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public long getLength(String blobId) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        try {
            return this.rep.getBlobStore().getBlobLength(blobId);
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public int read(String blobId, long pos, byte[] buff, int off, int length) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        try {
            return this.rep.getBlobStore().readBlob(blobId, pos, buff, off, length);
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public String write(InputStream in) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        try {
            return this.rep.getBlobStore().writeBlob(in);
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    void toJson(JsopBuilder builder, NodeState node, int depth, int offset, int count, boolean inclVirtualProps) {
        for (PropertyState propertyState : node.getProperties()) {
            builder.key(propertyState.getName()).encodedValue(propertyState.getEncodedValue());
        }
        long childCount = node.getChildNodeCount();
        if (inclVirtualProps) {
            builder.key(":childNodeCount").value(childCount);
        }
        if (childCount > 0L && depth >= 0) {
            for (ChildNodeEntry childNodeEntry : node.getChildNodeEntries(offset, count)) {
                builder.key(childNodeEntry.getName()).object();
                if (depth > 0) {
                    this.toJson(builder, childNodeEntry.getNode(), depth - 1, 0, -1, inclVirtualProps);
                }
                builder.endObject();
            }
        }
    }

    static void addNode(LinkedList<AddNodeOperation> list, String path, String name, JsopTokenizer t) throws Exception {
        AddNodeOperation op = new AddNodeOperation();
        op.path = path;
        op.name = name;
        list.add(op);
        if (!t.matches(125)) {
            do {
                String key = t.readString();
                t.read(58);
                if (t.matches(123)) {
                    MicroKernelImpl.addNode(list, PathUtils.concat(path, name), key, t);
                    continue;
                }
                op.props.put(key, t.readRawValue().trim());
            } while (t.matches(44));
            t.read(125);
        }
    }

    static class AddNodeOperation {
        String path;
        String name;
        Map<String, String> props = new HashMap<String, String>();

        AddNodeOperation() {
        }
    }
}

