/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jackrabbit.mk.model.ChildNode;
import org.apache.jackrabbit.mk.model.ChildNodeEntries;
import org.apache.jackrabbit.mk.model.ChildNodeEntriesMap;
import org.apache.jackrabbit.mk.model.ChildNodeEntriesTree;
import org.apache.jackrabbit.mk.model.Node;
import org.apache.jackrabbit.mk.store.Binding;
import org.apache.jackrabbit.mk.store.RevisionProvider;

public abstract class AbstractNode
implements Node {
    protected RevisionProvider provider;
    protected HashMap<String, String> properties;
    protected ChildNodeEntries childEntries;

    protected AbstractNode(RevisionProvider provider) {
        this.provider = provider;
        this.properties = new HashMap();
        this.childEntries = new ChildNodeEntriesMap();
    }

    protected AbstractNode(Node other, RevisionProvider provider) {
        this.provider = provider;
        if (other instanceof AbstractNode) {
            AbstractNode srcNode = (AbstractNode)other;
            this.properties = (HashMap)srcNode.properties.clone();
            this.childEntries = (ChildNodeEntries)srcNode.childEntries.clone();
        } else {
            this.properties = new HashMap<String, String>(other.getProperties());
            this.childEntries = other.getChildNodeCount() <= 10000 ? new ChildNodeEntriesMap() : new ChildNodeEntriesTree(provider);
            Iterator<ChildNode> it = other.getChildNodeEntries(0, -1);
            while (it.hasNext()) {
                ChildNode cne = it.next();
                this.childEntries.add(cne);
            }
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public ChildNode getChildNodeEntry(String name) {
        return this.childEntries.get(name);
    }

    @Override
    public Iterator<String> getChildNodeNames(int offset, int count) {
        return this.childEntries.getNames(offset, count);
    }

    @Override
    public int getChildNodeCount() {
        return this.childEntries.getCount();
    }

    @Override
    public Iterator<ChildNode> getChildNodeEntries(int offset, int count) {
        return this.childEntries.getEntries(offset, count);
    }

    @Override
    public void serialize(Binding binding) throws Exception {
        final Iterator<Map.Entry<String, String>> iter = this.properties.entrySet().iterator();
        binding.writeMap(":props", this.properties.size(), new Binding.StringEntryIterator(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Binding.StringEntry next() {
                Map.Entry entry = (Map.Entry)iter.next();
                return new Binding.StringEntry((String)entry.getKey(), (String)entry.getValue());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
        binding.write(":inlined", this.childEntries.inlined() ? 1 : 0);
        this.childEntries.serialize(binding);
    }
}

