/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.Arrays;
import org.apache.jackrabbit.mk.util.StringUtils;

public class Id
implements Comparable<Id> {
    private final byte[] raw;

    public Id(byte[] raw) {
        this.raw = raw;
    }

    public static Id fromString(String s) {
        return new Id(StringUtils.convertHexToBytes(s));
    }

    public int hashCode() {
        return Arrays.hashCode(this.raw);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Id) {
            Id other = (Id)obj;
            return Arrays.equals(this.raw, other.raw);
        }
        return false;
    }

    public String toString() {
        return StringUtils.convertBytesToHex(this.raw);
    }

    @Override
    public int compareTo(Id o) {
        byte[] other = o.getBytes();
        int len = Math.min(this.raw.length, other.length);
        for (int i = 0; i < len; ++i) {
            if (this.raw[i] == other[i]) continue;
            return this.raw[i] - other[i];
        }
        return this.raw.length - other.length;
    }

    public byte[] getBytes() {
        return this.raw;
    }
}

