/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.Iterator;
import org.apache.jackrabbit.mk.model.AbstractNode;
import org.apache.jackrabbit.mk.model.ChildNode;
import org.apache.jackrabbit.mk.model.ChildNodeEntriesTree;
import org.apache.jackrabbit.mk.model.Node;
import org.apache.jackrabbit.mk.store.PersistHook;
import org.apache.jackrabbit.mk.store.RevisionProvider;
import org.apache.jackrabbit.mk.store.RevisionStore;

public class MutableNode
extends AbstractNode
implements PersistHook {
    private final transient String path;

    public MutableNode(RevisionProvider provider, String path) {
        super(provider);
        this.path = path;
    }

    public MutableNode(Node other, RevisionProvider provider, String path) {
        super(other, provider);
        this.path = path;
    }

    public ChildNode add(ChildNode newEntry) {
        ChildNode existing = this.childEntries.add(newEntry);
        if (this.childEntries.getCount() > 10000 && this.childEntries.inlined()) {
            ChildNodeEntriesTree entries = new ChildNodeEntriesTree(this.provider);
            Iterator<ChildNode> iter = this.childEntries.getEntries(0, -1);
            while (iter.hasNext()) {
                entries.add(iter.next());
            }
            this.childEntries = entries;
        }
        return existing;
    }

    public ChildNode remove(String name) {
        return this.childEntries.remove(name);
    }

    public ChildNode rename(String oldName, String newName) {
        return this.childEntries.rename(oldName, newName);
    }

    @Override
    public void prePersist(RevisionStore store) throws Exception {
        if (!this.childEntries.inlined()) {
            ((ChildNodeEntriesTree)this.childEntries).persistDirtyBuckets(store);
        }
    }

    @Override
    public void postPersist(RevisionStore store) throws Exception {
    }

    public String toString() {
        return this.path;
    }
}

