/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.HashSet;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.NodeState;
import org.apache.jackrabbit.mk.model.PropertyState;

public class NodeStateDiff {
    public void propertyAdded(PropertyState after) {
    }

    public void propertyChanged(PropertyState before, PropertyState after) {
    }

    public void propertyDeleted(PropertyState before) {
    }

    public void childNodeAdded(String name, NodeState after) {
    }

    public void childNodeChanged(String name, NodeState before, NodeState after) {
    }

    public void childNodeDeleted(String name, NodeState before) {
    }

    public void compare(NodeState before, NodeState after) {
        this.compareProperties(before, after);
        this.compareChildNodes(before, after);
    }

    private void compareProperties(NodeState before, NodeState after) {
        HashSet<String> beforeProperties = new HashSet<String>();
        for (PropertyState propertyState : before.getProperties()) {
            String name = propertyState.getName();
            PropertyState afterProperty = after.getProperty(name);
            if (afterProperty == null) {
                this.propertyDeleted(propertyState);
                continue;
            }
            beforeProperties.add(name);
            if (propertyState.equals(afterProperty)) continue;
            this.propertyChanged(propertyState, afterProperty);
        }
        for (PropertyState propertyState : after.getProperties()) {
            if (beforeProperties.contains(propertyState.getName())) continue;
            this.propertyAdded(propertyState);
        }
    }

    private void compareChildNodes(NodeState before, NodeState after) {
        String name;
        HashSet<String> beforeChildNodes = new HashSet<String>();
        for (ChildNodeEntry childNodeEntry : before.getChildNodeEntries(0L, -1)) {
            name = childNodeEntry.getName();
            NodeState beforeChild = childNodeEntry.getNode();
            NodeState afterChild = after.getChildNode(name);
            if (afterChild == null) {
                this.childNodeDeleted(name, beforeChild);
                continue;
            }
            beforeChildNodes.add(name);
            if (beforeChild.equals(afterChild)) continue;
            this.childNodeChanged(name, beforeChild, afterChild);
        }
        for (ChildNodeEntry childNodeEntry : after.getChildNodeEntries(0L, -1)) {
            name = childNodeEntry.getName();
            if (beforeChildNodes.contains(name)) continue;
            this.childNodeAdded(name, childNodeEntry.getNode());
        }
    }
}

