/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.util;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.jackrabbit.mk.util.IOUtils;

public class ChunkedInputStream
extends FilterInputStream {
    public static final int MAX_CHUNK_SIZE = 32768;
    private static final byte[] CRLF = "\r\n".getBytes();
    private final byte[] prefix = new byte[4];
    private final byte[] data = new byte[32768];
    private final byte[] suffix = new byte[2];
    private int offset;
    private int length;
    private boolean lastChunk;

    public ChunkedInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        if (!this.lastChunk) {
            if (this.offset == this.length) {
                this.readChunk();
            }
            if (this.offset < this.length) {
                return this.data[this.offset++] & 0xFF;
            }
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = 0;
        while (read < len && !this.lastChunk) {
            if (this.offset == this.length) {
                this.readChunk();
            }
            int available = Math.min(len - read, this.length - this.offset);
            System.arraycopy(this.data, this.offset, b, off + read, available);
            read += available;
            this.offset += available;
        }
        return read == 0 && this.lastChunk ? -1 : read;
    }

    private void readChunk() throws IOException {
        this.length = 0;
        this.offset = 0;
        ChunkedInputStream.readFully(this.in, this.prefix);
        this.length = ChunkedInputStream.parseInt(this.prefix);
        if (this.length < 0 || this.length > 32768) {
            String msg = "Chunk size smaller than 0 or bigger than 32768";
            throw new IOException(msg);
        }
        ChunkedInputStream.readFully(this.in, this.suffix);
        if (!Arrays.equals(this.suffix, CRLF)) {
            String msg = "Missing carriage return/line feed combination.";
            throw new IOException(msg);
        }
        ChunkedInputStream.readFully(this.in, this.data, 0, this.length);
        ChunkedInputStream.readFully(this.in, this.suffix);
        if (!Arrays.equals(this.suffix, CRLF)) {
            String msg = "Missing carriage return/line feed combination.";
            throw new IOException(msg);
        }
        if (this.length == 0) {
            this.lastChunk = true;
        }
    }

    private static void readFully(InputStream in, byte[] b) throws IOException {
        ChunkedInputStream.readFully(in, b, 0, b.length);
    }

    private static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        int count = IOUtils.readFully(in, b, off, len);
        if (count < len) {
            String msg = String.format("Expected %d bytes, actually received: %d", len, count);
            throw new EOFException(msg);
        }
    }

    private static int parseInt(byte[] b) throws IOException {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            byte c = b[i];
            result <<= 4;
            if (c >= 48 && c <= 57) {
                result += c - 48;
                continue;
            }
            if (c >= 65 && c <= 70) {
                result += c - 65 + 10;
                continue;
            }
            if (c >= 97 && c <= 102) {
                result += c - 97 + 10;
                continue;
            }
            String msg = "Not a hexadecimal character: " + c;
            throw new IOException(msg);
        }
        return result;
    }

    public void recycle(InputStream in) {
        this.in = in;
        this.length = 0;
        this.offset = 0;
        this.lastChunk = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.in != null) {
            try {
                while (!this.lastChunk) {
                    this.readChunk();
                }
            }
            finally {
                this.in = null;
            }
        }
    }
}

