/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.Node;
import org.apache.jackrabbit.mk.model.TraversingNodeDiffHandler;
import org.apache.jackrabbit.mk.store.RevisionProvider;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class DiffBuilder {
    private final Node before;
    private final Node after;
    private final String path;
    private final int depth;
    private final String pathFilter;
    private final RevisionProvider rp;

    public DiffBuilder(Node before, Node after, String path, int depth, RevisionProvider rp, String pathFilter) {
        this.before = before;
        this.after = after;
        this.path = path;
        this.depth = depth;
        this.rp = rp;
        this.pathFilter = pathFilter == null || "".equals(pathFilter) ? "/" : pathFilter;
    }

    public String build() throws Exception {
        final JsopBuilder buff = new JsopBuilder();
        final HashMap addedNodes = new HashMap();
        final HashMap removedNodes = new HashMap();
        if (!PathUtils.isAncestor((String)this.path, (String)this.pathFilter) && !this.path.startsWith(this.pathFilter)) {
            return "";
        }
        if (this.before == null) {
            if (this.after != null) {
                buff.tag('+').key(this.path).object();
                this.toJson(buff, this.after, this.depth);
                return buff.endObject().newline().toString();
            }
            return "";
        }
        if (this.after == null) {
            buff.tag('-');
            buff.value(this.path);
            return buff.newline().toString();
        }
        TraversingNodeDiffHandler diffHandler = new TraversingNodeDiffHandler(this.rp){
            int levels;
            {
                super(x0);
                this.levels = DiffBuilder.this.depth < 0 ? Integer.MAX_VALUE : DiffBuilder.this.depth;
            }

            @Override
            public void propAdded(String propName, String value) {
                String p = PathUtils.concat((String)this.getCurrentPath(), (String)propName);
                if (p.startsWith(DiffBuilder.this.pathFilter)) {
                    buff.tag('^').key(p).encodedValue(value).newline();
                }
            }

            @Override
            public void propChanged(String propName, String oldValue, String newValue) {
                String p = PathUtils.concat((String)this.getCurrentPath(), (String)propName);
                if (p.startsWith(DiffBuilder.this.pathFilter)) {
                    buff.tag('^').key(p).encodedValue(newValue).newline();
                }
            }

            @Override
            public void propDeleted(String propName, String value) {
                String p = PathUtils.concat((String)this.getCurrentPath(), (String)propName);
                if (p.startsWith(DiffBuilder.this.pathFilter)) {
                    buff.tag('^').key(p).value(null).newline();
                }
            }

            @Override
            public void childNodeAdded(ChildNodeEntry added) {
                String p = PathUtils.concat((String)this.getCurrentPath(), (String)added.getName());
                if (p.startsWith(DiffBuilder.this.pathFilter)) {
                    ArrayList removedPaths = (ArrayList)removedNodes.get(added.getId());
                    if (removedPaths != null) {
                        String removedPath = (String)removedPaths.remove(0);
                        if (removedPaths.isEmpty()) {
                            removedNodes.remove(added.getId());
                        }
                        buff.tag('>').key(removedPath).value(p).newline();
                    } else {
                        ArrayList<String> addedPaths = (ArrayList<String>)addedNodes.get(added.getId());
                        if (addedPaths == null) {
                            addedPaths = new ArrayList<String>();
                            addedNodes.put(added.getId(), addedPaths);
                        }
                        addedPaths.add(p);
                    }
                }
            }

            @Override
            public void childNodeDeleted(ChildNodeEntry deleted) {
                String p = PathUtils.concat((String)this.getCurrentPath(), (String)deleted.getName());
                if (p.startsWith(DiffBuilder.this.pathFilter)) {
                    ArrayList addedPaths = (ArrayList)addedNodes.get(deleted.getId());
                    if (addedPaths != null) {
                        String addedPath = (String)addedPaths.remove(0);
                        if (addedPaths.isEmpty()) {
                            addedNodes.remove(deleted.getId());
                        }
                        buff.tag('>').key(p).value(addedPath).newline();
                    } else {
                        ArrayList<String> removedPaths = (ArrayList<String>)removedNodes.get(deleted.getId());
                        if (removedPaths == null) {
                            removedPaths = new ArrayList<String>();
                            removedNodes.put(deleted.getId(), removedPaths);
                        }
                        removedPaths.add(p);
                    }
                }
            }

            @Override
            public void childNodeChanged(ChildNodeEntry changed, Id newId) {
                String p = PathUtils.concat((String)this.getCurrentPath(), (String)changed.getName());
                if (PathUtils.isAncestor((String)p, (String)DiffBuilder.this.pathFilter) || p.startsWith(DiffBuilder.this.pathFilter)) {
                    --this.levels;
                    if (this.levels >= 0) {
                        super.childNodeChanged(changed, newId);
                    } else {
                        buff.tag('^');
                        buff.key(p);
                        buff.object().endObject();
                        buff.newline();
                    }
                    ++this.levels;
                }
            }
        };
        diffHandler.start(this.before, this.after, this.path);
        for (Map.Entry entry : addedNodes.entrySet()) {
            for (String p : (ArrayList)entry.getValue()) {
                buff.tag('+').key(p).object();
                this.toJson(buff, this.rp.getNode((Id)entry.getKey()), this.depth);
                buff.endObject().newline();
            }
        }
        for (Map.Entry entry : removedNodes.entrySet()) {
            for (String p : (ArrayList)entry.getValue()) {
                buff.tag('-');
                buff.value(p);
                buff.newline();
            }
        }
        return buff.toString();
    }

    private void toJson(JsopBuilder builder, Node node, int depth) throws Exception {
        for (Map.Entry<String, String> entry : node.getProperties().entrySet()) {
            builder.key(entry.getKey()).encodedValue(entry.getValue());
        }
        if (depth != 0) {
            Iterator<ChildNodeEntry> it = node.getChildNodeEntries(0, -1);
            while (it.hasNext()) {
                ChildNodeEntry childNodeEntry = it.next();
                builder.key(childNodeEntry.getName()).object();
                this.toJson(builder, this.rp.getNode(childNodeEntry.getId()), depth < 0 ? depth : depth - 1);
                builder.endObject();
            }
        }
    }
}

