/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.jackrabbit.mk.model.AbstractNode;
import org.apache.jackrabbit.mk.model.ChildNodeEntriesMap;
import org.apache.jackrabbit.mk.model.ChildNodeEntriesTree;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.Node;
import org.apache.jackrabbit.mk.store.Binding;
import org.apache.jackrabbit.mk.store.RevisionProvider;
import org.apache.jackrabbit.mk.util.UnmodifiableIterator;

public class StoredNode
extends AbstractNode {
    private final Id id;

    public StoredNode(Id id, RevisionProvider provider) {
        super(provider);
        this.id = id;
    }

    public StoredNode(Id id, Node node, RevisionProvider provider) {
        super(node, provider);
        this.id = id;
    }

    public Id getId() {
        return this.id;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public Iterator<ChildNodeEntry> getChildNodeEntries(int offset, int count) {
        return new UnmodifiableIterator<ChildNodeEntry>(super.getChildNodeEntries(offset, count));
    }

    @Override
    public Iterator<String> getChildNodeNames(int offset, int count) {
        return new UnmodifiableIterator<String>(super.getChildNodeNames(offset, count));
    }

    public void deserialize(Binding binding) throws Exception {
        Binding.StringEntryIterator iter = binding.readStringMap(":props");
        while (iter.hasNext()) {
            Binding.StringEntry entry = (Binding.StringEntry)iter.next();
            this.properties.put(entry.getKey(), entry.getValue());
        }
        boolean inlined = binding.readIntValue(":inlined") != 0;
        this.childEntries = inlined ? ChildNodeEntriesMap.deserialize(binding) : ChildNodeEntriesTree.deserialize(this.provider, binding);
    }
}

