/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractRangeIterator<T>
implements Iterator<T> {
    protected final Iterator<?> it;
    protected int maxCount;

    public AbstractRangeIterator(Iterator<?> it, int offset, int count) {
        while (offset-- > 0 && it.hasNext()) {
            it.next();
        }
        this.maxCount = count < 0 ? Integer.MAX_VALUE : count;
        this.it = it;
    }

    @Override
    public boolean hasNext() {
        return this.maxCount > 0 && this.it.hasNext();
    }

    @Override
    public T next() {
        if (this.maxCount-- > 0) {
            return this.doNext();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract T doNext();
}

