/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.blobs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.jackrabbit.mk.blobs.BlobStore;
import org.apache.jackrabbit.mk.util.Cache;
import org.apache.jackrabbit.mk.util.ExceptionFactory;
import org.apache.jackrabbit.mk.util.IOUtils;
import org.apache.jackrabbit.mk.util.StringUtils;

public abstract class AbstractBlobStore
implements Closeable,
BlobStore,
Cache.Backend<BlockId, Data> {
    protected static final String HASH_ALGORITHM = "SHA-1";
    protected static final int TYPE_DATA = 0;
    protected static final int TYPE_HASH = 1;
    protected static final int TYPE_HASH_COMPRESSED = 2;
    protected Map<String, WeakReference<String>> inUse = Collections.synchronizedMap(new WeakHashMap());
    private int blockSizeMin = 256;
    private int blockSize = 0x200000;
    private Cache<BlockId, Data> cache = Cache.newInstance(this, 0x800000);

    public void setBlockSizeMin(int x) {
        this.blockSizeMin = x;
    }

    public long getBlockSizeMin() {
        return this.blockSizeMin;
    }

    public void setBlockSize(int x) {
        this.blockSize = x;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addBlob(String tempFilePath) {
        String string;
        File file;
        block6: {
            file = new File(tempFilePath);
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                string = this.writeBlob(in);
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    file.delete();
                    throw throwable;
                }
                catch (Exception e) {
                    throw ExceptionFactory.convert(e);
                }
            }
            ((InputStream)in).close();
        }
        file.delete();
        return string;
    }

    @Override
    public String writeBlob(InputStream in) {
        try {
            ByteArrayOutputStream idStream = new ByteArrayOutputStream();
            this.convertBlobToId(in, idStream, 0, 0L);
            byte[] id = idStream.toByteArray();
            String blobId = StringUtils.convertBytesToHex(id);
            this.usesBlobId(blobId);
            return blobId;
        }
        catch (Exception e) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ExceptionFactory.convert(e);
        }
    }

    protected void usesBlobId(String blobId) {
        this.inUse.put(blobId, new WeakReference<String>(blobId));
    }

    public void clearInUse() {
        this.inUse.clear();
    }

    public void clearCache() {
        this.cache.clear();
    }

    private void convertBlobToId(InputStream in, ByteArrayOutputStream idStream, int level, long totalLength) throws Exception {
        byte[] block = new byte[this.blockSize];
        int count = 0;
        while (true) {
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITHM);
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            DigestOutputStream dout = new DigestOutputStream(buff, messageDigest);
            int blockLen = IOUtils.readFully(in, block, 0, block.length);
            ++count;
            if (blockLen == 0) break;
            if (blockLen < this.blockSizeMin) {
                idStream.write(0);
                IOUtils.writeVarInt(idStream, blockLen);
                idStream.write(block, 0, blockLen);
                totalLength += (long)blockLen;
            } else {
                dout.write(block, 0, blockLen);
                byte[] digest = messageDigest.digest();
                idStream.write(1);
                IOUtils.writeVarInt(idStream, level);
                if (level > 0) {
                    IOUtils.writeVarLong(idStream, totalLength);
                }
                IOUtils.writeVarLong(idStream, blockLen);
                totalLength += (long)blockLen;
                IOUtils.writeVarInt(idStream, digest.length);
                idStream.write(digest);
                byte[] data = buff.toByteArray();
                this.storeBlock(digest, level, data);
            }
            if (idStream.size() <= this.blockSize / 2) continue;
            byte[] idBlock = idStream.toByteArray();
            idStream.reset();
            this.convertBlobToId(new ByteArrayInputStream(idBlock), idStream, level + 1, totalLength);
            count = 1;
        }
        if (count > 0 && idStream.size() > this.blockSizeMin) {
            byte[] idBlock = idStream.toByteArray();
            idStream.reset();
            this.convertBlobToId(new ByteArrayInputStream(idBlock), idStream, level + 1, totalLength);
        }
        in.close();
    }

    protected abstract void storeBlock(byte[] var1, int var2, byte[] var3) throws Exception;

    public abstract void startMark() throws Exception;

    public abstract int sweep() throws Exception;

    protected abstract boolean isMarkEnabled();

    protected abstract void mark(BlockId var1) throws Exception;

    protected void markInUse() throws Exception {
        for (String id : new ArrayList<String>(this.inUse.keySet())) {
            this.mark(id);
        }
    }

    @Override
    public int readBlob(String blobId, long pos, byte[] buff, int off, int length) {
        try {
            int type;
            block10: {
                byte[] digest;
                if (this.isMarkEnabled()) {
                    this.mark(blobId);
                }
                byte[] id = StringUtils.convertHexToBytes(blobId);
                ByteArrayInputStream idStream = new ByteArrayInputStream(id);
                while (true) {
                    if ((type = idStream.read()) == -1) {
                        return -1;
                    }
                    if (type == 0) {
                        int len = IOUtils.readVarInt(idStream);
                        if (pos < (long)len) {
                            IOUtils.skipFully(idStream, (int)pos);
                            len = (int)((long)len - pos);
                            if (length < len) {
                                len = length;
                            }
                            IOUtils.readFully(idStream, buff, off, len);
                            return len;
                        }
                        IOUtils.skipFully(idStream, len);
                        pos -= (long)len;
                        continue;
                    }
                    if (type != 1) break block10;
                    int level = IOUtils.readVarInt(idStream);
                    long totalLength = IOUtils.readVarLong(idStream);
                    if (level > 0) {
                        IOUtils.readVarLong(idStream);
                    }
                    digest = new byte[IOUtils.readVarInt(idStream)];
                    IOUtils.readFully(idStream, digest, 0, digest.length);
                    if (pos >= totalLength) {
                        pos -= totalLength;
                        continue;
                    }
                    if (level <= 0) break;
                    byte[] block = this.readBlock(digest, 0L);
                    idStream = new ByteArrayInputStream(block);
                }
                long readPos = pos - pos % (long)this.blockSize;
                byte[] block = this.readBlock(digest, readPos);
                ByteArrayInputStream in = new ByteArrayInputStream(block);
                IOUtils.skipFully(in, pos - readPos);
                return IOUtils.readFully(in, buff, off, length);
            }
            throw new IOException("Unknown blobs id type " + type + " for blob " + blobId);
        }
        catch (Exception e) {
            throw ExceptionFactory.convert(e);
        }
    }

    private byte[] readBlock(byte[] digest, long pos) throws Exception {
        BlockId id = new BlockId(digest, pos);
        return this.cache.get((BlockId)id).data;
    }

    @Override
    public Data load(BlockId id) {
        try {
            return new Data(this.readBlockFromBackend(id));
        }
        catch (Exception e) {
            throw ExceptionFactory.convert(e);
        }
    }

    protected abstract byte[] readBlockFromBackend(BlockId var1) throws Exception;

    @Override
    public long getBlobLength(String blobId) {
        try {
            int type;
            if (this.isMarkEnabled()) {
                this.mark(blobId);
            }
            byte[] id = StringUtils.convertHexToBytes(blobId);
            ByteArrayInputStream idStream = new ByteArrayInputStream(id);
            long totalLength = 0L;
            while ((type = idStream.read()) != -1) {
                if (type == 0) {
                    int len = IOUtils.readVarInt(idStream);
                    IOUtils.skipFully(idStream, len);
                    totalLength += (long)len;
                    continue;
                }
                if (type == 1) {
                    int level = IOUtils.readVarInt(idStream);
                    totalLength += IOUtils.readVarLong(idStream);
                    if (level > 0) {
                        IOUtils.readVarLong(idStream);
                    }
                    int digestLength = IOUtils.readVarInt(idStream);
                    IOUtils.skipFully(idStream, digestLength);
                    continue;
                }
                throw new IOException("Datastore id type " + type + " for blob " + blobId);
            }
            return totalLength;
        }
        catch (IOException e) {
            throw ExceptionFactory.convert(e);
        }
    }

    protected void mark(String blobId) throws IOException {
        try {
            byte[] id = StringUtils.convertHexToBytes(blobId);
            ByteArrayInputStream idStream = new ByteArrayInputStream(id);
            this.mark(idStream);
        }
        catch (Exception e) {
            throw new IOException("Mark failed for blob " + blobId, e);
        }
    }

    private void mark(ByteArrayInputStream idStream) throws Exception {
        int type;
        while (true) {
            if ((type = idStream.read()) == -1) {
                return;
            }
            if (type == 0) {
                int len = IOUtils.readVarInt(idStream);
                IOUtils.skipFully(idStream, len);
                continue;
            }
            if (type != 1) break;
            int level = IOUtils.readVarInt(idStream);
            IOUtils.readVarLong(idStream);
            if (level > 0) {
                IOUtils.readVarLong(idStream);
            }
            byte[] digest = new byte[IOUtils.readVarInt(idStream)];
            IOUtils.readFully(idStream, digest, 0, digest.length);
            if (level > 0) {
                byte[] block = this.readBlock(digest, 0L);
                idStream = new ByteArrayInputStream(block);
                this.mark(idStream);
                continue;
            }
            BlockId id = new BlockId(digest, 0L);
            this.mark(id);
        }
        throw new IOException("Unknown blobs id type " + type);
    }

    @Override
    public void close() {
    }

    public static class Data
    implements Cache.Value {
        final byte[] data;

        Data(byte[] data) {
            this.data = data;
        }

        public String toString() {
            String s = StringUtils.convertBytesToHex(this.data);
            return s.length() > 100 ? s.substring(0, 100) + ".. (len=" + this.data.length + ")" : s;
        }

        @Override
        public int getMemory() {
            return this.data.length;
        }
    }

    public static class BlockId {
        final byte[] digest;
        final long pos;

        BlockId(byte[] digest, long pos) {
            this.digest = digest;
            this.pos = pos;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            BlockId o = (BlockId)other;
            return Arrays.equals(this.digest, o.digest) && this.pos == o.pos;
        }

        public int hashCode() {
            return Arrays.hashCode(this.digest) ^ (int)(this.pos >> 32) ^ (int)this.pos;
        }

        public String toString() {
            return StringUtils.convertBytesToHex(this.digest) + "@" + this.pos;
        }
    }
}

