/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.client;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.jackrabbit.mk.client.HttpExecutor;
import org.apache.jackrabbit.mk.util.IOUtils;

class Request
implements Closeable {
    private final SocketFactory socketFactory;
    private final InetSocketAddress socketAddress;
    private final String command;
    private final Map<String, String> params = new LinkedHashMap<String, String>();
    private InputStream in;

    public Request(SocketFactory socketFactory, InetSocketAddress socketAddress, String command) {
        this.socketFactory = socketFactory;
        this.socketAddress = socketAddress;
        this.command = command;
    }

    public Request addParameter(String name, String value) {
        if (value != null) {
            this.params.put(name, value);
        }
        return this;
    }

    public Request addParameter(String name, int value) {
        this.params.put(name, String.valueOf(value));
        return this;
    }

    public Request addParameter(String name, long value) {
        this.params.put(name, String.valueOf(value));
        return this;
    }

    public Request addFileParameter(String name, InputStream in) {
        this.in = in;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] execute() throws IOException {
        HttpExecutor executor = new HttpExecutor(this.socketFactory, this.socketAddress);
        try {
            byte[] byArray;
            InputStream stream = executor.execute(this.command, this.params, this.in);
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                IOUtils.copy(stream, buffer);
                byArray = buffer.toByteArray();
            }
            catch (Throwable throwable) {
                stream.close();
                throw throwable;
            }
            stream.close();
            return byArray;
        }
        finally {
            executor.close();
        }
    }

    public String getString() throws IOException {
        return new String(this.execute(), "8859_1");
    }

    public boolean getBoolean() throws IOException {
        return Boolean.parseBoolean(this.getString());
    }

    public long getLong() throws IOException {
        return Long.parseLong(this.getString());
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        byte[] bytes = this.execute();
        len = Math.min(bytes.length, len);
        if (len == 0) {
            return -1;
        }
        System.arraycopy(bytes, 0, b, off, len);
        return len;
    }

    @Override
    public void close() {
    }
}

