/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.core;

import java.io.InputStream;
import java.util.ArrayList;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.mk.core.Repository;
import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mk.json.JsopTokenizer;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.CommitBuilder;
import org.apache.jackrabbit.mk.model.DiffBuilder;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.NodeState;
import org.apache.jackrabbit.mk.model.PropertyState;
import org.apache.jackrabbit.mk.model.StoredCommit;
import org.apache.jackrabbit.mk.util.CommitGate;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class MicroKernelImpl
implements MicroKernel {
    protected Repository rep;
    private final CommitGate gate = new CommitGate();

    public MicroKernelImpl(String homeDir) throws MicroKernelException {
        this.init(homeDir);
    }

    public MicroKernelImpl() {
        this(new Repository());
    }

    public MicroKernelImpl(Repository rep) {
        this.rep = rep;
    }

    protected void init(String homeDir) throws MicroKernelException {
        try {
            this.rep = new Repository(homeDir);
            this.rep.init();
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public void dispose() {
        this.gate.commit("end");
        if (this.rep != null) {
            try {
                this.rep.shutDown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.rep = null;
        }
    }

    @Override
    public String getHeadRevision() throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        return this.getHeadRevisionId().toString();
    }

    private Id getHeadRevisionId() throws MicroKernelException {
        try {
            return this.rep.getHeadRevision();
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public String getRevisionHistory(long since, int maxEntries) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        maxEntries = maxEntries < 0 ? Integer.MAX_VALUE : maxEntries;
        ArrayList<StoredCommit> history = new ArrayList<StoredCommit>();
        try {
            StoredCommit commit = this.rep.getHeadCommit();
            while (commit != null && history.size() < maxEntries && commit.getCommitTS() >= since) {
                history.add(commit);
                Id commitId = commit.getParentId();
                if (commitId != null) {
                    commit = this.rep.getCommit(commitId);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
        JsopBuilder buff = new JsopBuilder().array();
        for (int i = history.size() - 1; i >= 0; --i) {
            StoredCommit commit = (StoredCommit)history.get(i);
            buff.object().key("id").value(commit.getId().toString()).key("ts").value(commit.getCommitTS()).key("msg").value(commit.getMsg()).endObject();
        }
        return buff.endArray().toString();
    }

    @Override
    public String waitForCommit(String oldHeadRevisionId, long maxWaitMillis) throws MicroKernelException, InterruptedException {
        return this.gate.waitForCommit(oldHeadRevisionId, maxWaitMillis);
    }

    @Override
    public String getJournal(String fromRevision, String toRevision, String filter) throws MicroKernelException {
        StoredCommit commit;
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id fromRevisionId = Id.fromString(fromRevision);
        Id toRevisionId = toRevision == null ? this.getHeadRevisionId() : Id.fromString(toRevision);
        ArrayList<StoredCommit> commits = new ArrayList<StoredCommit>();
        try {
            StoredCommit fromCommit;
            StoredCommit toCommit = this.rep.getCommit(toRevisionId);
            if (toCommit.getBranchRootId() != null) {
                throw new MicroKernelException("branch revisions are not supported: " + toRevisionId);
            }
            if (toRevisionId.equals(fromRevisionId)) {
                fromCommit = toCommit;
            } else {
                fromCommit = this.rep.getCommit(fromRevisionId);
                if (fromCommit.getCommitTS() > toCommit.getCommitTS()) {
                    return "[]";
                }
            }
            if (fromCommit.getBranchRootId() != null) {
                throw new MicroKernelException("branch revisions are not supported: " + fromRevisionId);
            }
            commit = toCommit;
            while (commit != null) {
                Id commitId;
                commits.add(commit);
                if (!commit.getId().equals(fromRevisionId) && (commitId = commit.getParentId()) != null && (commit = this.rep.getCommit(commitId)).getCommitTS() >= fromCommit.getCommitTS()) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
        JsopBuilder commitBuff = new JsopBuilder().array();
        for (int i = commits.size() - 1; i >= 0; --i) {
            commit = (StoredCommit)commits.get(i);
            if (commit.getParentId() == null) continue;
            commitBuff.object().key("id").value(commit.getId().toString()).key("ts").value(commit.getCommitTS()).key("msg").value(commit.getMsg()).key("changes").value(commit.getChanges()).endObject();
        }
        return commitBuff.endArray().toString();
    }

    @Override
    public String diff(String fromRevision, String toRevision, String filter) throws MicroKernelException {
        Id toRevisionId;
        Id fromRevisionId;
        String path = "/";
        if (fromRevision == null || toRevision == null) {
            Id head = this.getHeadRevisionId();
            fromRevisionId = fromRevision == null ? head : Id.fromString(fromRevision);
            toRevisionId = toRevision == null ? head : Id.fromString(toRevision);
        } else {
            fromRevisionId = Id.fromString(fromRevision);
            toRevisionId = Id.fromString(toRevision);
        }
        if (fromRevisionId.equals(toRevisionId)) {
            return "";
        }
        try {
            NodeState before = this.rep.getNodeState(fromRevisionId, path);
            NodeState after = this.rep.getNodeState(toRevisionId, path);
            return new DiffBuilder(before, after, path, this.rep.getRevisionStore(), filter).build();
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public boolean nodeExists(String path, String revisionId) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id revId = revisionId == null ? this.getHeadRevisionId() : Id.fromString(revisionId);
        try {
            return this.rep.nodeExists(revId, path);
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public long getChildNodeCount(String path, String revisionId) throws MicroKernelException {
        NodeState nodeState;
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id revId = revisionId == null ? this.getHeadRevisionId() : Id.fromString(revisionId);
        try {
            nodeState = this.rep.getNodeState(revId, path);
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
        if (nodeState != null) {
            return nodeState.getChildNodeCount();
        }
        throw new MicroKernelException("Path " + path + " not found in revision " + revisionId);
    }

    @Override
    public String getNodes(String path, String revisionId) throws MicroKernelException {
        return this.getNodes(path, revisionId, 1, 0L, -1, null);
    }

    @Override
    public String getNodes(String path, String revisionId, int depth, long offset, int count, String filter) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id revId = revisionId == null ? this.getHeadRevisionId() : Id.fromString(revisionId);
        try {
            NodeState nodeState = this.rep.getNodeState(revId, path);
            if (nodeState == null) {
                return null;
            }
            JsopBuilder buf = new JsopBuilder().object();
            this.toJson(buf, nodeState, depth, (int)offset, count, true);
            return buf.endObject().toString();
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public String commit(String path, String jsonDiff, String revisionId, String message) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        if (path.length() > 0 && !PathUtils.isAbsolute((String)path)) {
            throw new IllegalArgumentException("absolute path expected: " + path);
        }
        Id revId = revisionId == null ? this.getHeadRevisionId() : Id.fromString(revisionId);
        try {
            int r;
            JsopTokenizer t = new JsopTokenizer(jsonDiff);
            CommitBuilder cb = this.rep.getCommitBuilder(revId, message);
            block9: while ((r = t.read()) != 0) {
                switch (r) {
                    case 43: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        t.read(58);
                        if (t.matches(123)) {
                            String nodePath = PathUtils.concat((String)path, (String)subPath);
                            if (!PathUtils.isAbsolute((String)nodePath)) {
                                throw new Exception("absolute path expected: " + nodePath + ", pos: " + pos);
                            }
                            String parentPath = PathUtils.getParentPath((String)nodePath);
                            String nodeName = PathUtils.getName((String)nodePath);
                            cb.addNode(parentPath, nodeName, this.parseNode(t));
                            continue block9;
                        }
                        String value = t.matches(5) ? null : t.readRawValue().trim();
                        String targetPath = PathUtils.concat((String)path, (String)subPath);
                        if (!PathUtils.isAbsolute((String)targetPath)) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        String parentPath = PathUtils.getParentPath((String)targetPath);
                        String propName = PathUtils.getName((String)targetPath);
                        cb.setProperty(parentPath, propName, value);
                        continue block9;
                    }
                    case 45: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        String targetPath = PathUtils.concat((String)path, (String)subPath);
                        if (!PathUtils.isAbsolute((String)targetPath)) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        cb.removeNode(targetPath);
                        continue block9;
                    }
                    case 94: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        t.read(58);
                        String value = t.matches(5) ? null : t.readRawValue().trim();
                        String targetPath = PathUtils.concat((String)path, (String)subPath);
                        if (!PathUtils.isAbsolute((String)targetPath)) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        String parentPath = PathUtils.getParentPath((String)targetPath);
                        String propName = PathUtils.getName((String)targetPath);
                        cb.setProperty(parentPath, propName, value);
                        continue block9;
                    }
                    case 62: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        String srcPath = PathUtils.concat((String)path, (String)subPath);
                        if (!PathUtils.isAbsolute((String)srcPath)) {
                            throw new Exception("absolute path expected: " + srcPath + ", pos: " + pos);
                        }
                        t.read(58);
                        pos = t.getLastPos();
                        String targetPath = t.readString();
                        if (!PathUtils.isAbsolute((String)targetPath) && !PathUtils.isAbsolute((String)(targetPath = PathUtils.concat((String)path, (String)targetPath)))) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        cb.moveNode(srcPath, targetPath);
                        continue block9;
                    }
                    case 42: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        String srcPath = PathUtils.concat((String)path, (String)subPath);
                        if (!PathUtils.isAbsolute((String)srcPath)) {
                            throw new Exception("absolute path expected: " + srcPath + ", pos: " + pos);
                        }
                        t.read(58);
                        pos = t.getLastPos();
                        String targetPath = t.readString();
                        if (!PathUtils.isAbsolute((String)targetPath) && !PathUtils.isAbsolute((String)(targetPath = PathUtils.concat((String)path, (String)targetPath)))) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        cb.copyNode(srcPath, targetPath);
                        continue block9;
                    }
                }
                throw new AssertionError((Object)("token type: " + t.getTokenType()));
            }
            Id newHead = cb.doCommit();
            if (!newHead.equals(revId)) {
                this.gate.commit(newHead.toString());
            }
            return newHead.toString();
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public String branch(String trunkRevisionId) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id revId = trunkRevisionId == null ? this.getHeadRevisionId() : Id.fromString(trunkRevisionId);
        try {
            CommitBuilder cb = this.rep.getCommitBuilder(revId, "");
            return cb.doCommit(true).toString();
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public String merge(String branchRevisionId, String message) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id revId = Id.fromString(branchRevisionId);
        try {
            return this.rep.getCommitBuilder(revId, message).doMerge().toString();
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public long getLength(String blobId) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        try {
            return this.rep.getBlobStore().getBlobLength(blobId);
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public int read(String blobId, long pos, byte[] buff, int off, int length) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        try {
            return this.rep.getBlobStore().readBlob(blobId, pos, buff, off, length);
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    @Override
    public String write(InputStream in) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        try {
            return this.rep.getBlobStore().writeBlob(in);
        }
        catch (Exception e) {
            throw new MicroKernelException(e);
        }
    }

    void toJson(JsopBuilder builder, NodeState node, int depth, int offset, int count, boolean inclVirtualProps) {
        for (PropertyState propertyState : node.getProperties()) {
            builder.key(propertyState.getName()).encodedValue(propertyState.getEncodedValue());
        }
        long childCount = node.getChildNodeCount();
        if (inclVirtualProps) {
            builder.key(":childNodeCount").value(childCount);
        }
        if (childCount > 0L && depth >= 0) {
            for (ChildNodeEntry childNodeEntry : node.getChildNodeEntries(offset, count)) {
                builder.key(childNodeEntry.getName()).object();
                if (depth > 0) {
                    this.toJson(builder, childNodeEntry.getNode(), depth - 1, 0, -1, inclVirtualProps);
                }
                builder.endObject();
            }
        }
    }

    CommitBuilder.NodeTree parseNode(JsopTokenizer t) throws Exception {
        CommitBuilder.NodeTree node = new CommitBuilder.NodeTree();
        if (!t.matches(125)) {
            do {
                String key = t.readString();
                t.read(58);
                if (t.matches(123)) {
                    node.nodes.put(key, this.parseNode(t));
                    continue;
                }
                node.props.put(key, t.readRawValue().trim());
            } while (t.matches(44));
            t.read(125);
        }
        return node;
    }
}

