/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.NodeState;
import org.apache.jackrabbit.mk.model.NodeStore;
import org.apache.jackrabbit.mk.model.PropertyState;
import org.apache.jackrabbit.mk.model.TraversingNodeDiffHandler;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class DiffBuilder {
    private final NodeState before;
    private final NodeState after;
    private final String path;
    private final String filter;
    private final NodeStore store;

    public DiffBuilder(NodeState before, NodeState after, String path, NodeStore store, String filter) {
        this.before = before;
        this.after = after;
        this.path = path;
        this.store = store;
        this.filter = filter;
    }

    public String build() throws Exception {
        final JsopBuilder buff = new JsopBuilder();
        final HashMap addedNodes = new HashMap();
        final HashMap removedNodes = new HashMap();
        if (this.before == null) {
            if (this.after != null) {
                buff.tag('+').key(this.path).object();
                this.toJson(buff, this.after);
                return buff.endObject().newline().toString();
            }
            throw new Exception("path doesn't exist in the specified revisions: " + this.path);
        }
        if (this.after == null) {
            buff.tag('-');
            buff.value(this.path);
            return buff.newline().toString();
        }
        TraversingNodeDiffHandler diffHandler = new TraversingNodeDiffHandler(this.store){

            @Override
            public void propertyAdded(PropertyState after) {
                buff.tag('+').key(PathUtils.concat((String)this.getCurrentPath(), (String)after.getName())).encodedValue(after.getEncodedValue()).newline();
            }

            @Override
            public void propertyChanged(PropertyState before, PropertyState after) {
                buff.tag('^').key(PathUtils.concat((String)this.getCurrentPath(), (String)after.getName())).encodedValue(after.getEncodedValue()).newline();
            }

            @Override
            public void propertyDeleted(PropertyState before) {
                buff.tag('^').key(PathUtils.concat((String)this.getCurrentPath(), (String)before.getName())).value(null).newline();
            }

            @Override
            public void childNodeAdded(String name, NodeState after) {
                addedNodes.put(after, PathUtils.concat((String)this.getCurrentPath(), (String)name));
                buff.tag('+').key(PathUtils.concat((String)this.getCurrentPath(), (String)name)).object();
                DiffBuilder.this.toJson(buff, after);
                buff.endObject().newline();
            }

            @Override
            public void childNodeDeleted(String name, NodeState before) {
                removedNodes.put(before, PathUtils.concat((String)this.getCurrentPath(), (String)name));
                buff.tag('-');
                buff.value(PathUtils.concat((String)this.getCurrentPath(), (String)name));
                buff.newline();
            }
        };
        diffHandler.start(this.before, this.after, this.path);
        addedNodes.keySet().retainAll(removedNodes.keySet());
        if (!addedNodes.isEmpty()) {
            removedNodes.keySet().retainAll(addedNodes.keySet());
            buff.resetWriter();
            diffHandler = new TraversingNodeDiffHandler(this.store){

                @Override
                public void propertyAdded(PropertyState after) {
                    buff.tag('+').key(PathUtils.concat((String)this.getCurrentPath(), (String)after.getName())).encodedValue(after.getEncodedValue()).newline();
                }

                @Override
                public void propertyChanged(PropertyState before, PropertyState after) {
                    buff.tag('^').key(PathUtils.concat((String)this.getCurrentPath(), (String)after.getName())).encodedValue(after.getEncodedValue()).newline();
                }

                @Override
                public void propertyDeleted(PropertyState before) {
                    buff.tag('^').key(PathUtils.concat((String)this.getCurrentPath(), (String)before.getName())).value(null).newline();
                }

                @Override
                public void childNodeAdded(String name, NodeState after) {
                    if (addedNodes.containsKey(after)) {
                        return;
                    }
                    buff.tag('+').key(PathUtils.concat((String)this.getCurrentPath(), (String)name)).object();
                    DiffBuilder.this.toJson(buff, after);
                    buff.endObject().newline();
                }

                @Override
                public void childNodeDeleted(String name, NodeState before) {
                    if (addedNodes.containsKey(before)) {
                        return;
                    }
                    buff.tag('-');
                    buff.value(PathUtils.concat((String)this.getCurrentPath(), (String)name));
                    buff.newline();
                }
            };
            diffHandler.start(this.before, this.after, this.path);
            for (Map.Entry entry : addedNodes.entrySet()) {
                buff.tag('>').key((String)removedNodes.get(entry.getKey())).value((String)entry.getValue()).newline();
            }
        }
        return buff.toString();
    }

    private void toJson(JsopBuilder builder, NodeState node) {
        for (PropertyState propertyState : node.getProperties()) {
            builder.key(propertyState.getName()).encodedValue(propertyState.getEncodedValue());
        }
        for (ChildNodeEntry childNodeEntry : node.getChildNodeEntries(0L, -1)) {
            builder.key(childNodeEntry.getName()).object();
            this.toJson(builder, childNodeEntry.getNode());
            builder.endObject();
        }
    }
}

