/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.persistence;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.apache.jackrabbit.mk.model.ChildNodeEntriesMap;
import org.apache.jackrabbit.mk.model.Commit;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.Node;
import org.apache.jackrabbit.mk.model.StoredCommit;
import org.apache.jackrabbit.mk.model.StoredNode;
import org.apache.jackrabbit.mk.persistence.Persistence;
import org.apache.jackrabbit.mk.store.BinaryBinding;
import org.apache.jackrabbit.mk.store.IdFactory;
import org.apache.jackrabbit.mk.store.NotFoundException;
import org.apache.jackrabbit.mk.util.IOUtils;

public class FSPersistence
implements Persistence {
    private File dataDir;
    private File head;
    private IdFactory idFactory = IdFactory.getDigestFactory();

    @Override
    public void initialize(File homeDir) throws Exception {
        this.dataDir = new File(homeDir, "data");
        if (!this.dataDir.exists()) {
            this.dataDir.mkdirs();
        }
        this.head = new File(homeDir, "HEAD");
        if (!this.head.exists()) {
            this.writeHead(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Id readHead() throws Exception {
        FileInputStream in = new FileInputStream(this.head);
        try {
            String s = IOUtils.readString(in);
            Id id = s.equals("") ? null : Id.fromString(s);
            return id;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeHead(Id id) throws Exception {
        FileOutputStream out = new FileOutputStream(this.head);
        try {
            IOUtils.writeString(out, id == null ? "" : id.toString());
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readNode(StoredNode node) throws NotFoundException, Exception {
        Id id = node.getId();
        File f = this.getFile(id);
        if (f.exists()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            try {
                node.deserialize(new BinaryBinding(in));
            }
            finally {
                in.close();
            }
        } else {
            throw new NotFoundException(id.toString());
        }
    }

    @Override
    public Id writeNode(Node node) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        node.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        Id id = new Id(this.idFactory.createContentId(bytes));
        this.writeFile(id, bytes);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoredCommit readCommit(Id id) throws NotFoundException, Exception {
        File f = this.getFile(id);
        if (f.exists()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            try {
                StoredCommit storedCommit = StoredCommit.deserialize(id, new BinaryBinding(in));
                return storedCommit;
            }
            finally {
                in.close();
            }
        }
        throw new NotFoundException(id.toString());
    }

    @Override
    public void writeCommit(Id id, Commit commit) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        commit.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        this.writeFile(id, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChildNodeEntriesMap readCNEMap(Id id) throws NotFoundException, Exception {
        File f = this.getFile(id);
        if (f.exists()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            try {
                ChildNodeEntriesMap childNodeEntriesMap = ChildNodeEntriesMap.deserialize(new BinaryBinding(in));
                return childNodeEntriesMap;
            }
            finally {
                in.close();
            }
        }
        throw new NotFoundException(id.toString());
    }

    @Override
    public Id writeCNEMap(ChildNodeEntriesMap map) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        map.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        Id id = new Id(this.idFactory.createContentId(bytes));
        this.writeFile(id, bytes);
        return id;
    }

    private File getFile(Id id) {
        String sId = id.toString();
        StringBuilder buf = new StringBuilder(sId.substring(0, 2));
        buf.append('/');
        buf.append(sId.substring(2));
        return new File(this.dataDir, buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(Id id, byte[] data) throws Exception {
        File tmp = File.createTempFile("tmp", null, this.dataDir);
        try {
            FileOutputStream fos = new FileOutputStream(tmp);
            try {
                fos.write(data);
            }
            finally {
                fos.close();
            }
            File dst = this.getFile(id);
            if (dst.exists()) {
                return;
            }
            tmp.setReadOnly();
            if (tmp.renameTo(dst)) {
                return;
            }
            dst.getParentFile().mkdir();
            if (tmp.renameTo(dst)) {
                return;
            }
            throw new Exception("failed to create " + dst);
        }
        finally {
            tmp.delete();
        }
    }

    @Override
    public void close() {
    }
}

