/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.persistence;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.jackrabbit.mk.blobs.BlobStore;
import org.apache.jackrabbit.mk.model.ChildNodeEntriesMap;
import org.apache.jackrabbit.mk.model.Commit;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.Node;
import org.apache.jackrabbit.mk.model.StoredCommit;
import org.apache.jackrabbit.mk.model.StoredNode;
import org.apache.jackrabbit.mk.persistence.Persistence;
import org.apache.jackrabbit.mk.store.BinaryBinding;
import org.apache.jackrabbit.mk.store.Binding;
import org.apache.jackrabbit.mk.store.IdFactory;
import org.apache.jackrabbit.mk.store.NotFoundException;
import org.apache.jackrabbit.mk.util.ExceptionFactory;
import org.apache.jackrabbit.mk.util.IOUtils;
import org.apache.jackrabbit.mk.util.StringUtils;
import org.bson.types.ObjectId;

public class MongoPersistence
implements Persistence,
BlobStore {
    private static final boolean BINARY_FORMAT = false;
    private static final String HEAD_COLLECTION = "head";
    private static final String NODES_COLLECTION = "nodes";
    private static final String COMMITS_COLLECTION = "commits";
    private static final String CNEMAPS_COLLECTION = "cneMaps";
    private static final String ID_FIELD = ":id";
    private static final String DATA_FIELD = ":data";
    private Mongo con;
    private DB db;
    private DBCollection nodes;
    private DBCollection commits;
    private DBCollection cneMaps;
    private GridFS fs;
    private IdFactory idFactory = IdFactory.getDigestFactory();
    protected static final String ENCODED_DOT = "_x46_";
    protected static final String ENCODED_DOLLAR_SIGN = "_x36_";

    @Override
    public void initialize(File homeDir) throws Exception {
        this.con = new Mongo();
        this.db = this.con.getDB("mk");
        this.db.setWriteConcern(WriteConcern.SAFE);
        if (!this.db.collectionExists(HEAD_COLLECTION)) {
            this.db.createCollection(HEAD_COLLECTION, (DBObject)new BasicDBObject("capped", (Object)true).append("size", (Object)256).append("max", (Object)1));
        }
        this.nodes = this.db.getCollection(NODES_COLLECTION);
        this.nodes.ensureIndex((DBObject)new BasicDBObject(ID_FIELD, (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        this.commits = this.db.getCollection(COMMITS_COLLECTION);
        this.commits.ensureIndex((DBObject)new BasicDBObject(ID_FIELD, (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        this.cneMaps = this.db.getCollection(CNEMAPS_COLLECTION);
        this.cneMaps.ensureIndex((DBObject)new BasicDBObject(ID_FIELD, (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        this.fs = new GridFS(this.db);
    }

    @Override
    public void close() {
        this.con.close();
        this.con = null;
        this.db = null;
    }

    @Override
    public Id readHead() throws Exception {
        DBObject entry = this.db.getCollection(HEAD_COLLECTION).findOne();
        if (entry == null) {
            return null;
        }
        return new Id((byte[])entry.get(ID_FIELD));
    }

    @Override
    public void writeHead(Id id) throws Exception {
        this.db.getCollection(HEAD_COLLECTION).insert(new DBObject[]{new BasicDBObject(ID_FIELD, (Object)id.getBytes())});
    }

    @Override
    public void readNode(StoredNode node) throws NotFoundException, Exception {
        Id id = node.getId();
        BasicDBObject key = new BasicDBObject();
        key.put(ID_FIELD, (Object)id.toString());
        BasicDBObject nodeObject = (BasicDBObject)this.nodes.findOne((DBObject)key);
        if (nodeObject == null) {
            throw new NotFoundException(id.toString());
        }
        DBObjectBinding binding = new DBObjectBinding(nodeObject);
        node.deserialize(binding);
    }

    @Override
    public Id writeNode(Node node) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        node.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        Id id = new Id(this.idFactory.createContentId(bytes));
        BasicDBObject nodeObject = new BasicDBObject(ID_FIELD, (Object)id.toString());
        node.serialize(new DBObjectBinding(nodeObject));
        try {
            this.nodes.insert(new DBObject[]{nodeObject});
        }
        catch (MongoException.DuplicateKey ignore) {
            // empty catch block
        }
        return id;
    }

    @Override
    public StoredCommit readCommit(Id id) throws NotFoundException, Exception {
        BasicDBObject key = new BasicDBObject();
        key.put(ID_FIELD, (Object)id.toString());
        BasicDBObject commitObject = (BasicDBObject)this.commits.findOne((DBObject)key);
        if (commitObject != null) {
            return StoredCommit.deserialize(id, new DBObjectBinding(commitObject));
        }
        throw new NotFoundException(id.toString());
    }

    @Override
    public void writeCommit(Id id, Commit commit) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        commit.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        BasicDBObject commitObject = new BasicDBObject(ID_FIELD, (Object)id.toString());
        commit.serialize(new DBObjectBinding(commitObject));
        try {
            this.commits.insert(new DBObject[]{commitObject});
        }
        catch (MongoException.DuplicateKey ignore) {
            // empty catch block
        }
    }

    @Override
    public ChildNodeEntriesMap readCNEMap(Id id) throws NotFoundException, Exception {
        BasicDBObject key = new BasicDBObject();
        key.put(ID_FIELD, (Object)id.toString());
        BasicDBObject mapObject = (BasicDBObject)this.cneMaps.findOne((DBObject)key);
        if (mapObject != null) {
            return ChildNodeEntriesMap.deserialize(new DBObjectBinding(mapObject));
        }
        throw new NotFoundException(id.toString());
    }

    @Override
    public Id writeCNEMap(ChildNodeEntriesMap map) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        map.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        Id id = new Id(this.idFactory.createContentId(bytes));
        BasicDBObject mapObject = new BasicDBObject(ID_FIELD, (Object)id.toString());
        map.serialize(new DBObjectBinding(mapObject));
        try {
            this.cneMaps.insert(new DBObject[]{mapObject});
        }
        catch (MongoException.DuplicateKey ignore) {
            // empty catch block
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addBlob(String tempFilePath) throws Exception {
        String string;
        File file = new File(tempFilePath);
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            string = this.writeBlob(in);
            file.delete();
        }
        catch (Throwable throwable) {
            try {
                file.delete();
                throw throwable;
            }
            catch (Exception e) {
                throw ExceptionFactory.convert(e);
            }
        }
        return string;
    }

    @Override
    public String writeBlob(InputStream in) throws Exception {
        GridFSInputFile f = this.fs.createFile(in, true);
        f.save();
        IOUtils.closeQuietly(in);
        return f.getId().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readBlob(String blobId, long pos, byte[] buff, int off, int length) throws Exception {
        GridFSDBFile f = this.fs.findOne(new ObjectId(blobId));
        if (f == null) {
            throw new NotFoundException(blobId);
        }
        InputStream in = f.getInputStream();
        try {
            in.skip(pos);
            int n = in.read(buff, off, length);
            return n;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    @Override
    public long getBlobLength(String blobId) throws Exception {
        GridFSDBFile f = this.fs.findOne(new ObjectId(blobId));
        if (f == null) {
            throw new NotFoundException(blobId);
        }
        return f.getLength();
    }

    protected static String encodeName(String name) {
        StringBuilder buf = null;
        for (int i = 0; i < name.length(); ++i) {
            if (i == 0 && name.charAt(i) == '$') {
                buf = new StringBuilder();
                buf.append(ENCODED_DOLLAR_SIGN);
                continue;
            }
            if (name.charAt(i) == '.') {
                if (buf == null) {
                    buf = new StringBuilder(name.substring(0, i));
                }
                buf.append(ENCODED_DOT);
                continue;
            }
            if (buf == null) continue;
            buf.append(name.charAt(i));
        }
        return buf == null ? name : buf.toString();
    }

    protected static String decodeName(String name) {
        int pos;
        StringBuilder buf = null;
        int lastPos = 0;
        if (name.startsWith(ENCODED_DOLLAR_SIGN)) {
            buf = new StringBuilder("$");
            lastPos = ENCODED_DOLLAR_SIGN.length();
        }
        while ((pos = name.indexOf(ENCODED_DOT, lastPos)) != -1) {
            if (buf == null) {
                buf = new StringBuilder();
            }
            buf.append(name.substring(lastPos, pos));
            buf.append('.');
            lastPos = pos + ENCODED_DOT.length();
        }
        if (buf != null) {
            buf.append(name.substring(lastPos));
            return buf.toString();
        }
        return name;
    }

    protected class DBObjectBinding
    implements Binding {
        BasicDBObject obj;

        protected DBObjectBinding(BasicDBObject obj) {
            this.obj = obj;
        }

        @Override
        public void write(String key, String value) throws Exception {
            this.obj.append(MongoPersistence.encodeName(key), (Object)value);
        }

        @Override
        public void write(String key, byte[] value) throws Exception {
            this.obj.append(MongoPersistence.encodeName(key), (Object)StringUtils.convertBytesToHex(value));
        }

        @Override
        public void write(String key, long value) throws Exception {
            this.obj.append(MongoPersistence.encodeName(key), (Object)value);
        }

        @Override
        public void write(String key, int value) throws Exception {
            this.obj.append(MongoPersistence.encodeName(key), (Object)value);
        }

        @Override
        public void writeMap(String key, int count, Binding.StringEntryIterator iterator) throws Exception {
            BasicDBObject childObj = new BasicDBObject();
            while (iterator.hasNext()) {
                Binding.StringEntry entry = (Binding.StringEntry)iterator.next();
                childObj.append(MongoPersistence.encodeName(entry.getKey()), (Object)entry.getValue());
            }
            this.obj.append(MongoPersistence.encodeName(key), (Object)childObj);
        }

        @Override
        public void writeMap(String key, int count, Binding.BytesEntryIterator iterator) throws Exception {
            BasicDBObject childObj = new BasicDBObject();
            while (iterator.hasNext()) {
                Binding.BytesEntry entry = (Binding.BytesEntry)iterator.next();
                childObj.append(MongoPersistence.encodeName(entry.getKey()), (Object)StringUtils.convertBytesToHex(entry.getValue()));
            }
            this.obj.append(MongoPersistence.encodeName(key), (Object)childObj);
        }

        @Override
        public String readStringValue(String key) throws Exception {
            return this.obj.getString(MongoPersistence.encodeName(key));
        }

        @Override
        public byte[] readBytesValue(String key) throws Exception {
            return StringUtils.convertHexToBytes(this.obj.getString(MongoPersistence.encodeName(key)));
        }

        @Override
        public long readLongValue(String key) throws Exception {
            return this.obj.getLong(MongoPersistence.encodeName(key));
        }

        @Override
        public int readIntValue(String key) throws Exception {
            return this.obj.getInt(MongoPersistence.encodeName(key));
        }

        @Override
        public Binding.StringEntryIterator readStringMap(String key) throws Exception {
            final BasicDBObject childObj = (BasicDBObject)this.obj.get(MongoPersistence.encodeName(key));
            final Iterator it = childObj.keySet().iterator();
            return new Binding.StringEntryIterator(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Binding.StringEntry next() {
                    String key = (String)it.next();
                    return new Binding.StringEntry(MongoPersistence.decodeName(key), childObj.getString(key));
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Binding.BytesEntryIterator readBytesMap(String key) throws Exception {
            final BasicDBObject childObj = (BasicDBObject)this.obj.get(MongoPersistence.encodeName(key));
            final Iterator it = childObj.keySet().iterator();
            return new Binding.BytesEntryIterator(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Binding.BytesEntry next() {
                    String key = (String)it.next();
                    return new Binding.BytesEntry(MongoPersistence.decodeName(key), StringUtils.convertHexToBytes(childObj.getString(key)));
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

