/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.jackrabbit.mk.server.Request;
import org.apache.jackrabbit.mk.server.Response;
import org.apache.jackrabbit.mk.server.Servlet;
import org.apache.jackrabbit.mk.util.IOUtils;

class HttpProcessor {
    private static final int INITIAL_SO_TIMEOUT = 1000;
    private static final int DEFAULT_SO_TIMEOUT = 30000;
    private static final int MAX_KEEP_ALIVE_REQUESTS = 100;
    private final Socket socket;
    private final Servlet servlet;
    private InputStream socketIn;
    private OutputStream socketOut;
    private final Request request = new Request();
    private final Response response = new Response();

    public HttpProcessor(Socket socket, Servlet servlet) {
        this.socket = socket;
        this.servlet = servlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws IOException {
        try {
            this.socketIn = new BufferedInputStream(this.socket.getInputStream());
            this.socketOut = new BufferedOutputStream(this.socket.getOutputStream());
            this.socket.setSoTimeout(1000);
            int requestNum = 0;
            while (this.process(requestNum)) {
                if (requestNum == 0) {
                    this.socket.setSoTimeout(30000);
                }
                ++requestNum;
            }
        }
        finally {
            IOUtils.closeQuietly(this.socketOut);
            IOUtils.closeQuietly(this.socketIn);
            IOUtils.closeQuietly(this.socket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean process(int requestNum) throws IOException {
        try {
            this.request.parse(this.socketIn);
        }
        catch (IOException e) {
            if (requestNum == 0) {
                return false;
            }
            throw e;
        }
        try {
            boolean keepAlive = this.request.isKeepAlive() && requestNum + 1 < 100;
            this.response.recycle(this.socketOut, keepAlive);
            this.servlet.service(this.request, this.response);
            boolean bl = keepAlive;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(this.request);
            IOUtils.closeQuietly(this.response);
        }
    }
}

