/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jackrabbit.mk.util.IOUtils;

class Response
implements Closeable {
    private OutputStream out;
    private boolean keepAlive;
    private boolean headersSent;
    private boolean committed;
    private boolean chunked;
    private int statusCode;
    private String contentType;
    private final BodyOutputStream bodyOut = new BodyOutputStream();
    private OutputStream respOut;
    private final Map<String, String> headers = new LinkedHashMap<String, String>();

    Response() {
    }

    void recycle(OutputStream out, boolean keepAlive) {
        this.out = out;
        this.keepAlive = keepAlive;
        this.chunked = false;
        this.committed = false;
        this.headersSent = false;
        this.statusCode = 0;
        this.contentType = null;
        this.bodyOut.reset();
        this.respOut = null;
        this.headers.clear();
    }

    private static String getStatusMsg(int sc) {
        switch (sc) {
            case 200: {
                return "OK";
            }
            case 400: {
                return "Bad request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 404: {
                return "Not found";
            }
        }
        return "Internal server error";
    }

    private void sendHeaders() throws IOException {
        if (this.headersSent) {
            return;
        }
        this.headersSent = true;
        int statusCode = this.statusCode;
        if (statusCode == 0) {
            statusCode = 200;
        }
        String msg = Response.getStatusMsg(statusCode);
        if (this.respOut == null) {
            String body = String.format("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\"><html><head><title>%d %s</title></head><body><h1>%s</h1></body></html>", statusCode, msg, msg);
            this.setContentType("text/html");
            this.write(body);
        }
        this.writeLine(String.format("HTTP/1.1 %d %s", statusCode, msg));
        if (this.committed) {
            this.writeLine(String.format("Content-Length: %d", this.bodyOut.getCount()));
        } else {
            this.chunked = true;
            this.writeLine("Transfer-Encoding: chunked");
        }
        if (this.contentType != null) {
            this.writeLine(String.format("Content-Type: %s", this.contentType));
        }
        if (!this.keepAlive) {
            this.writeLine("Connection: Close");
        }
        if (this.headers != null) {
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                this.writeLine(String.format("%s: %s", header.getKey(), header.getValue()));
            }
        }
        this.writeLine("");
        if (this.out != null) {
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.committed = true;
        try {
            this.sendHeaders();
            IOUtils.closeQuietly(this.respOut);
            if (this.out != null) {
                this.out.flush();
            }
        }
        finally {
            this.out = null;
        }
    }

    private void writeLine(String s) throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.write(s.getBytes());
        this.out.write("\r\n".getBytes());
    }

    void writeBody(byte[] b, int off, int len) throws IOException {
        if (this.out == null) {
            return;
        }
        this.sendHeaders();
        if (this.chunked) {
            this.out.write(String.format("%04X\r\n", len).getBytes());
        }
        this.out.write(b, off, len);
        if (this.chunked) {
            this.out.write("\r\n".getBytes());
        }
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public OutputStream getOutputStream() {
        if (this.respOut == null) {
            this.respOut = this.bodyOut;
        }
        return this.respOut;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void write(String s) throws IOException {
        this.getOutputStream().write(s.getBytes("8859_1"));
    }

    class BodyOutputStream
    extends OutputStream {
        private final byte[] buf = new byte[32768];
        private int offset;

        BodyOutputStream() {
        }

        public int getCount() {
            return this.offset;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.offset == this.buf.length) {
                Response.this.writeBody(this.buf, 0, this.offset);
                this.offset = 0;
            }
            this.buf[this.offset++] = (byte)b;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int count = 0;
            while (count < len) {
                if (this.offset == this.buf.length) {
                    Response.this.writeBody(this.buf, 0, this.offset);
                    this.offset = 0;
                }
                int n = Math.min(len - count, this.buf.length - this.offset);
                System.arraycopy(b, off + count, this.buf, this.offset, n);
                count += n;
                this.offset += n;
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.offset > 0) {
                Response.this.writeBody(this.buf, 0, this.offset);
                this.offset = 0;
            }
        }

        public void reset() {
            this.offset = 0;
        }

        @Override
        public void close() throws IOException {
            this.flush();
            Response.this.writeBody(this.buf, 0, 0);
        }
    }
}

